/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.aliyunemr;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamUtil {
    private static final Logger log = LoggerFactory.getLogger(ParamUtil.class);
    private static final String DEFAULT_PARAMETER_CONVERT_PATTERN = "\\$\\{(?<expr>[y{4}|M{2}|d{2}|H{2}|h{2}|m{2}|s{2}|:|a-z|A-Z||_| ]+)\\s*((?<opr>[-|+])\\s*(?<count>\\d+)(?<unit>[y|m|d|h]))?}";

    public static String convertParameterExpression(String value) {
        Pattern p = Pattern.compile(DEFAULT_PARAMETER_CONVERT_PATTERN);
        Matcher m = p.matcher(value);
        boolean matched = false;
        String newValue = value;
        while (m.find()) {
            matched = true;
            String dateExpr = m.group("expr");
            String opr = m.group("opr");
            String count = m.group("count");
            String unit = m.group("unit");
            String newExpr = dateExpr.replace("mm", "mi").replace("MM", "mm").replace("HH", "hh24");
            String oprSuffix = null;
            if ("h".equalsIgnoreCase(unit)) {
                oprSuffix = "/24";
            }
            String newOpr = Optional.ofNullable(opr).orElse("") + Optional.ofNullable(count).orElse("") + Optional.ofNullable(oprSuffix).orElse("");
            if ("y".equalsIgnoreCase(unit)) {
                newExpr = "yyyy";
            }
            newValue = "$[" + newExpr.trim() + newOpr + "]";
            if (StringUtils.indexOfIgnoreCase((CharSequence)newExpr, (CharSequence)"dd") >= 0) continue;
            newValue = "${" + newExpr.trim() + newOpr + "}";
        }
        if (matched) {
            return newValue;
        }
        return value;
    }
}

