/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.aliyunemr;

import com.aliyun.dataworks.migrationx.domain.dataworks.aliyunemr.AliyunEmrExportRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.aliyunemr.AliyunEmrProject;
import com.aliyun.dataworks.migrationx.domain.dataworks.aliyunemr.CronUtil;
import com.aliyun.dataworks.migrationx.domain.dataworks.aliyunemr.Flow;
import com.aliyun.dataworks.migrationx.domain.dataworks.aliyunemr.PackageInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.aliyunemr.ParamUtil;
import com.aliyun.migrationx.common.utils.BeanUtils;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.emr.model.v20160408.DescribeFlowCategoryRequest;
import com.aliyuncs.emr.model.v20160408.DescribeFlowCategoryResponse;
import com.aliyuncs.emr.model.v20160408.DescribeFlowJobRequest;
import com.aliyuncs.emr.model.v20160408.DescribeFlowJobResponse;
import com.aliyuncs.emr.model.v20160408.DescribeFlowRequest;
import com.aliyuncs.emr.model.v20160408.DescribeFlowResponse;
import com.aliyuncs.emr.model.v20160408.ListFlowJobRequest;
import com.aliyuncs.emr.model.v20160408.ListFlowJobResponse;
import com.aliyuncs.emr.model.v20160408.ListFlowProjectRequest;
import com.aliyuncs.emr.model.v20160408.ListFlowProjectResponse;
import com.aliyuncs.emr.model.v20160408.ListFlowRequest;
import com.aliyuncs.emr.model.v20160408.ListFlowResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunEmrService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AliyunEmrService.class);
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static final String FLOW_DETAIL_EXT = ".detail";
    public static final String JSON_FILE_EXT = ".json";
    public static final String FLOW_DIR_NAME = "flow";
    public static final String JOB_DIR_NAME = "job";
    public static final String EMR_POP_PRODUCT = "emr";
    public static final String FILE_ENCODE = "utf-8";
    public static final String FILE_PACKAGE_INFO = ".package_info.txt";
    private final String accessId;
    private final String accessKey;
    private final String endpoint;
    private final String regionId;
    private DefaultAcsClient client;
    private final Map<String, DescribeFlowCategoryResponse> flowCategoryResponseLocalCache = new HashMap<String, DescribeFlowCategoryResponse>();

    public AliyunEmrService(String accessId, String accessKey, String endpoint, String regionId) {
        this.accessId = accessId;
        this.accessKey = accessKey;
        this.endpoint = endpoint;
        this.regionId = regionId;
        this.client = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultAcsClient getDefaultAcsClient() throws ClientException {
        if (this.client != null) {
            return this.client;
        }
        AliyunEmrService aliyunEmrService = this;
        synchronized (aliyunEmrService) {
            DefaultProfile.addEndpoint((String)this.regionId, (String)EMR_POP_PRODUCT, (String)this.endpoint);
            DefaultProfile profile = DefaultProfile.getProfile((String)this.regionId, (String)this.accessId, (String)this.accessKey);
            this.client = new DefaultAcsClient((IClientProfile)profile);
            return this.client;
        }
    }

    private void writePackageInfo(File dir) throws IOException {
        File file = new File(dir, FILE_PACKAGE_INFO);
        PackageInfo packageInfo = new PackageInfo();
        packageInfo.setType("ALIYUN_EMR");
        packageInfo.setTimestamp(new Date());
        packageInfo.setExporter("emr-exporter");
        FileUtils.writeStringToFile((File)file, (String)GsonUtils.toJsonString((Object)packageInfo), (Charset)StandardCharsets.UTF_8);
    }

    public void dump(AliyunEmrExportRequest request) throws ClientException, IOException {
        ListFlowProjectResponse response;
        LOGGER.info("specified export project list: {}", request.getProjects());
        File folder = request.getFolder();
        if (!folder.exists()) {
            folder.mkdirs();
        }
        int pageSize = 20;
        int pageNumber = 1;
        ListFlowProjectRequest listFlowProjectRequest = new ListFlowProjectRequest();
        listFlowProjectRequest.setPageSize(Integer.valueOf(pageSize));
        listFlowProjectRequest.setPageNumber(Integer.valueOf(pageNumber));
        int totalCount = 0;
        do {
            listFlowProjectRequest.setPageNumber(Integer.valueOf(pageNumber));
            response = (ListFlowProjectResponse)this.getDefaultAcsClient().getAcsResponse((AcsRequest)listFlowProjectRequest);
            for (ListFlowProjectResponse.Project project : response.getProjects()) {
                if (CollectionUtils.isNotEmpty(request.getProjects()) && !request.getProjects().contains(project.getName())) continue;
                List projectFlowList = ListUtils.emptyIfNull((List)((List)MapUtils.emptyIfNull(request.getProjectFlowList()).get(project.getName())));
                LOGGER.info("exporting project: {}, projectFlowList: {}", (Object)project.getName(), (Object)projectFlowList);
                File projectFolder = new File(folder.getAbsolutePath() + File.separator + project.getName());
                if (!projectFolder.exists()) {
                    boolean res = projectFolder.mkdirs();
                    LOGGER.info("mkdir project folder: {} {}", (Object)projectFolder, (Object)res);
                }
                String projectJson = gson.toJson((Object)project);
                File projectFile = new File(projectFolder.getAbsolutePath() + File.separator + project.getName() + JSON_FILE_EXT);
                FileUtils.write((File)projectFile, (CharSequence)projectJson, (Charset)Charset.forName(FILE_ENCODE));
                this.dumpProjectJobs(project, projectFolder.getAbsolutePath());
                this.dumpProjectFlows(project, projectFolder.getAbsolutePath(), projectFlowList, request.getFolderFilter());
            }
            ++pageNumber;
        } while ((totalCount += response.getProjects().size()) < response.getTotal());
        this.writePackageInfo(folder);
    }

    public void dumpProjectFlows(ListFlowProjectResponse.Project project, String absolutePath, List<String> projectFlowList, String folderFilter) throws ClientException, IOException {
        ListFlowResponse response;
        File projectFolder = new File(absolutePath);
        if (!projectFolder.exists()) {
            projectFolder.mkdirs();
        }
        int pageNumber = 1;
        int pageSize = 50;
        int total = 0;
        ListFlowRequest request = new ListFlowRequest();
        request.setPageNumber(Integer.valueOf(pageNumber));
        request.setPageNumber(Integer.valueOf(pageSize));
        request.setProjectId(project.getId());
        do {
            request.setPageNumber(Integer.valueOf(pageNumber));
            response = (ListFlowResponse)this.getDefaultAcsClient().getAcsResponse((AcsRequest)request);
            File jobFolder = new File(projectFolder.getAbsolutePath() + File.separator + FLOW_DIR_NAME);
            if (!jobFolder.exists()) {
                jobFolder.mkdirs();
            }
            for (ListFlowResponse.FlowItem flow : response.getFlow()) {
                if (CollectionUtils.isNotEmpty(projectFlowList) && !projectFlowList.contains(flow.getName())) {
                    LOGGER.info("skip flow name: {} that not in flow list expected to export", (Object)flow.getName());
                    continue;
                }
                flow.setCronExpr(CronUtil.cronToDwCron(flow.getCronExpr()));
                String json = gson.toJson((Object)flow);
                File flowFile = new File(jobFolder.getAbsolutePath() + File.separator + flow.getId() + JSON_FILE_EXT);
                DescribeFlowRequest describeFlowRequest = new DescribeFlowRequest();
                describeFlowRequest.setProjectId(project.getId());
                describeFlowRequest.setId(flow.getId());
                DescribeFlowResponse res = (DescribeFlowResponse)this.getDefaultAcsClient().getAcsResponse((AcsRequest)describeFlowRequest);
                Flow theFlow = new Flow();
                BeanUtils.copyProperties((Object)res, (Object)((Object)theFlow));
                theFlow.setProject(project);
                ArrayList<String> paths = new ArrayList<String>();
                this.supplyFlowCategoryPath(paths, project, res.getCategoryId());
                theFlow.setPath(StringUtils.join(paths, (String)File.separator));
                theFlow.setCronExpr(CronUtil.cronToDwCron(theFlow.getCronExpr()));
                if (StringUtils.isNotBlank((CharSequence)folderFilter) && !StringUtils.startsWith((CharSequence)theFlow.getPath(), (CharSequence)folderFilter)) {
                    LOGGER.info("ignore flow that not in path: {}, ignored flow path: {}", (Object)folderFilter, (Object)theFlow.getPath());
                    continue;
                }
                String flowDetailJson = gson.toJson((Object)theFlow);
                File flowDetailFile = new File(jobFolder.getAbsolutePath() + File.separator + flow.getId() + FLOW_DETAIL_EXT + JSON_FILE_EXT);
                FileUtils.write((File)flowFile, (CharSequence)json, (Charset)Charset.forName(FILE_ENCODE));
                FileUtils.write((File)flowDetailFile, (CharSequence)flowDetailJson, (Charset)Charset.forName(FILE_ENCODE));
            }
            ++pageNumber;
        } while ((total += response.getFlow().size()) < response.getTotal());
    }

    public void supplyFlowCategoryPath(List<String> paths, ListFlowProjectResponse.Project project, String categoryId) throws ClientException {
        DescribeFlowCategoryRequest request = new DescribeFlowCategoryRequest();
        request.setProjectId(project.getId());
        request.setId(categoryId);
        DescribeFlowCategoryResponse response = Optional.ofNullable(this.flowCategoryResponseLocalCache.get(categoryId)).orElse((DescribeFlowCategoryResponse)this.getDefaultAcsClient().getAcsResponse((AcsRequest)request));
        if (response == null) {
            LOGGER.warn("response got null by request: {}", (Object)GsonUtils.toJsonString((Object)request));
            return;
        }
        this.flowCategoryResponseLocalCache.put(response.getId(), response);
        paths.add(response.getName());
        if (StringUtils.isBlank((CharSequence)response.getParentId())) {
            Collections.reverse(paths);
            LOGGER.info("got full category path: {}", (Object)StringUtils.join(paths, (String)File.separator));
            return;
        }
        this.supplyFlowCategoryPath(paths, project, response.getParentId());
    }

    public void dumpProjectJobs(ListFlowProjectResponse.Project project, String absolutePath) throws ClientException, IOException {
        ListFlowJobResponse response;
        File projectFolder = new File(absolutePath);
        if (!projectFolder.exists()) {
            projectFolder.mkdirs();
        }
        int pageNumber = 1;
        int pageSize = 50;
        int total = 0;
        ListFlowJobRequest request = new ListFlowJobRequest();
        request.setPageNumber(Integer.valueOf(pageNumber));
        request.setPageNumber(Integer.valueOf(pageSize));
        request.setProjectId(project.getId());
        request.setAdhoc(Boolean.valueOf(false));
        do {
            request.setPageNumber(Integer.valueOf(pageNumber));
            response = (ListFlowJobResponse)this.getDefaultAcsClient().getAcsResponse((AcsRequest)request);
            File jobFolder = new File(projectFolder.getAbsolutePath() + File.separator + JOB_DIR_NAME);
            if (!jobFolder.exists()) {
                boolean res = jobFolder.mkdirs();
                LOGGER.info("mkdir {} {}", (Object)jobFolder, (Object)res);
            }
            for (ListFlowJobResponse.Job job : response.getJobList()) {
                job.setParamConf(this.replaceJobDateParam(job.getParamConf()));
                DescribeFlowJobRequest descFlowJobRequest = new DescribeFlowJobRequest();
                descFlowJobRequest.setProjectId(project.getId());
                descFlowJobRequest.setId(job.getId());
                DescribeFlowJobResponse jobResponse = (DescribeFlowJobResponse)this.getDefaultAcsClient().getAcsResponse((AcsRequest)descFlowJobRequest);
                if (jobResponse != null) {
                    jobResponse.setParamConf(this.replaceJobDateParam(jobResponse.getParamConf()));
                }
                String json = gson.toJson(jobResponse != null ? jobResponse : job);
                File jobFile = new File(jobFolder.getAbsolutePath() + File.separator + job.getId() + JSON_FILE_EXT);
                FileUtils.write((File)jobFile, (CharSequence)json, (Charset)Charset.forName(FILE_ENCODE));
            }
            ++pageNumber;
        } while ((total += response.getJobList().size()) < response.getTotal());
    }

    private String replaceJobDateParam(String paramConf) {
        if (StringUtils.isBlank((CharSequence)paramConf)) {
            return paramConf;
        }
        Map paramMap = (Map)GsonUtils.fromJsonString((String)paramConf, (Type)new TypeToken<Map<String, String>>(){}.getType());
        MapUtils.emptyIfNull((Map)paramMap).forEach((key, val) -> MapUtils.emptyIfNull((Map)paramMap).put(key, ParamUtil.convertParameterExpression(val)));
        return GsonUtils.toJsonString((Object)paramMap);
    }

    public static List<AliyunEmrProject> load(String fromFolder) throws IOException {
        File folderPath = new File(fromFolder);
        ArrayList<AliyunEmrProject> projects = new ArrayList<AliyunEmrProject>();
        for (File projectPath : Objects.requireNonNull(folderPath.listFiles(File::isDirectory))) {
            File projectJsonFile = new File(projectPath.getAbsolutePath() + File.separator + projectPath.getName() + JSON_FILE_EXT);
            String prjJson = FileUtils.readFileToString((File)projectJsonFile, (Charset)Charset.forName(FILE_ENCODE));
            ListFlowProjectResponse.Project project = (ListFlowProjectResponse.Project)gson.fromJson(prjJson, new TypeToken<ListFlowProjectResponse.Project>(){}.getType());
            List<ListFlowJobResponse.Job> jobs = AliyunEmrService.loadProjectJobs(projectPath);
            Map<ListFlowResponse.FlowItem, Flow> flows = AliyunEmrService.loadProjectFlows(projectPath);
            AliyunEmrProject aliyunEmrProject = new AliyunEmrProject();
            aliyunEmrProject.setProject(project);
            aliyunEmrProject.setFlows(flows);
            aliyunEmrProject.setJobs(jobs);
            projects.add(aliyunEmrProject);
        }
        return projects;
    }

    private static Map<ListFlowResponse.FlowItem, Flow> loadProjectFlows(File projectPath) throws IOException {
        File flowFolder = new File(projectPath.getAbsolutePath() + File.separator + FLOW_DIR_NAME);
        HashMap<ListFlowResponse.FlowItem, Flow> flows = new HashMap<ListFlowResponse.FlowItem, Flow>(100);
        File[] files = flowFolder.listFiles(f -> f.isFile() && f.getName().endsWith(JSON_FILE_EXT));
        if (files == null) {
            return flows;
        }
        for (File flowJsonFile : files) {
            if (flowJsonFile.getName().contains(FLOW_DETAIL_EXT)) continue;
            String flowJson = FileUtils.readFileToString((File)flowJsonFile, (Charset)Charset.forName(FILE_ENCODE));
            ListFlowResponse.FlowItem flowItem = (ListFlowResponse.FlowItem)gson.fromJson(flowJson, new TypeToken<ListFlowResponse.FlowItem>(){}.getType());
            File jobDetailFile = new File(flowJsonFile.getAbsolutePath().replaceAll(".json$", "") + FLOW_DETAIL_EXT + JSON_FILE_EXT);
            Flow flowDetail = null;
            if (jobDetailFile.exists()) {
                String jobDetailJson = FileUtils.readFileToString((File)jobDetailFile, (Charset)Charset.forName(FILE_ENCODE));
                flowDetail = (Flow)((Object)gson.fromJson(jobDetailJson, new TypeToken<Flow>(){}.getType()));
            }
            flows.put(flowItem, flowDetail);
        }
        return flows;
    }

    private static List<ListFlowJobResponse.Job> loadProjectJobs(File projectPath) throws IOException {
        File jobFolder = new File(projectPath.getAbsolutePath() + File.separator + JOB_DIR_NAME);
        ArrayList<ListFlowJobResponse.Job> jobs = new ArrayList<ListFlowJobResponse.Job>(100);
        File[] files = jobFolder.listFiles(f -> f.isFile() && f.getName().endsWith(JSON_FILE_EXT));
        if (files == null) {
            return jobs;
        }
        for (File jobJsonFile : files) {
            String jobJson = FileUtils.readFileToString((File)jobJsonFile, (Charset)Charset.forName(FILE_ENCODE));
            ListFlowJobResponse.Job jobItem = (ListFlowJobResponse.Job)gson.fromJson(jobJson, new TypeToken<ListFlowJobResponse.Job>(){}.getType());
            jobs.add(jobItem);
        }
        return jobs;
    }
}

