/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.tool;

import com.aliyun.dataworks_public20200518.models.GetBusinessRequest;
import com.aliyun.dataworks_public20200518.models.GetBusinessResponse;
import com.aliyun.dataworks_public20200518.models.GetBusinessResponseBody;
import com.aliyun.dataworks_public20200518.models.GetFileRequest;
import com.aliyun.dataworks_public20200518.models.GetFileResponse;
import com.aliyun.dataworks_public20200518.models.GetFileResponseBody;
import com.aliyun.dataworks_public20200518.models.GetProjectRequest;
import com.aliyun.dataworks_public20200518.models.GetProjectResponse;
import com.aliyun.dataworks_public20200518.models.GetProjectResponseBody;
import com.aliyun.dataworks_public20200518.models.ListBusinessResponseBody;
import com.aliyun.dataworks_public20200518.models.ListDataSourcesResponseBody;
import com.aliyun.dataworks_public20200518.models.ListFilesRequest;
import com.aliyun.dataworks_public20200518.models.ListFilesResponseBody;
import com.aliyun.dataworks_public20200518.models.ListProjectsResponseBody;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.workflow.migration.common.utils.CustomCreateFileRequest;
import com.aliyun.migration.workflow.migration.common.utils.CustomCreateFileResponse;
import com.aliyun.migration.workflow.migration.common.utils.DwClient;
import com.aliyun.migration.workflow.migration.common.utils.PageUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwTaskReaderTool {
    private static final Logger log = LoggerFactory.getLogger(DwTaskReaderTool.class);
    private DwClient dwClient;

    public DwTaskReaderTool(Map<String, String> properties) {
        String endpoint = properties.get("endpoint");
        String ak = properties.get("ak");
        String sk = properties.get("sk");
        String oss = properties.get("oss-path");
        this.dwClient = oss == null ? new DwClient(endpoint, ak, sk) : new DwClient(endpoint, ak, sk, oss);
    }

    public DwTaskReaderTool(String endpoint, String accessKeyId, String accessKeySecret) {
        this.dwClient = new DwClient(endpoint, accessKeyId, accessKeySecret);
    }

    public DwTaskReaderTool(String endpoint, String accessKeyId, String accessKeySecret, String ossPath) {
        this.dwClient = new DwClient(endpoint, accessKeyId, accessKeySecret, ossPath);
    }

    public DwClient getDwClient() {
        return this.dwClient;
    }

    public List<ListProjectsResponseBody.ListProjectsResponseBodyPageResultProjectList> getProjectList() throws InterruptedException {
        PageUtil.Paginator paginator = new PageUtil.Paginator();
        paginator.setPageSize(20);
        paginator.setPageNum(1);
        ArrayList<ListProjectsResponseBody.ListProjectsResponseBodyPageResultProjectList> result = new ArrayList<ListProjectsResponseBody.ListProjectsResponseBodyPageResultProjectList>();
        PageUtil.doPaginate((PageUtil.Paginator)paginator, p -> {
            try {
                ListProjectsResponseBody.ListProjectsResponseBodyPageResult listProjectsResponse = this.dwClient.listProjectsWithOptions(Integer.valueOf(p.getPageSize()), Integer.valueOf(p.getPageNum()));
                ArrayList data = listProjectsResponse.getProjectList();
                if (data == null) {
                    data = new ArrayList();
                }
                result.addAll(data);
                Integer count = data.size();
                PageUtil.PaginateResult paginateResult = new PageUtil.PaginateResult();
                paginateResult.setPageNum(p.getPageNum());
                paginateResult.setPageSize(p.getPageSize());
                paginateResult.setData(data);
                paginateResult.setTotalCount(count.intValue());
                return paginateResult;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return result;
    }

    public GetProjectResponseBody.GetProjectResponseBodyData getProjectDetailById(String projectId) {
        GetProjectRequest getProjectRequest = new GetProjectRequest();
        getProjectRequest.setProjectId(Long.valueOf(Long.parseLong(projectId)));
        GetProjectResponseBody.GetProjectResponseBodyData project = null;
        try {
            GetProjectResponse response = this.dwClient.getProject(getProjectRequest);
            project = response.getBody().getData();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return project;
    }

    public GetProjectResponseBody.GetProjectResponseBodyData getProjectDetailByName(String projectName) throws InterruptedException {
        ListProjectsResponseBody.ListProjectsResponseBodyPageResultProjectList project = this.getProjectList().stream().filter(p -> p.projectIdentifier.equalsIgnoreCase(projectName)).findFirst().orElse(null);
        if (project == null) {
            return null;
        }
        return this.getProjectDetailById(project.projectId.toString());
    }

    public List<ListBusinessResponseBody.ListBusinessResponseBodyDataBusiness> getBusinessList(String projectId) {
        return this.dwClient.getAllBusiness(Long.valueOf(Long.parseLong(projectId)));
    }

    public List<GetBusinessResponseBody.GetBusinessResponseBodyData> getBusinessDetailList(String projectId) {
        List<ListBusinessResponseBody.ListBusinessResponseBodyDataBusiness> businessList = this.getBusinessList(projectId);
        ArrayList<GetBusinessResponseBody.GetBusinessResponseBodyData> businessDetailList = new ArrayList<GetBusinessResponseBody.GetBusinessResponseBodyData>();
        businessList.forEach(business -> {
            GetBusinessRequest getBusinessRequest = new GetBusinessRequest();
            getBusinessRequest.setBusinessId(business.getBusinessId());
            getBusinessRequest.setProjectId(Long.valueOf(Long.parseLong(projectId)));
            GetBusinessResponseBody.GetBusinessResponseBodyData businessDetail = null;
            try {
                GetBusinessResponse response = this.dwClient.getBusiness(Long.valueOf(Long.parseLong(projectId)), business.getBusinessId());
                businessDetail = response.getBody().getData();
                businessDetailList.add(businessDetail);
                log.info("Get business: {}, {}", (Object)businessDetail.getBusinessName(), (Object)businessDetail.getBusinessId());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return businessDetailList;
    }

    public List<ListFilesResponseBody.ListFilesResponseBodyDataFiles> getWorkflowNodeList(String projectId) throws InterruptedException {
        ListFilesRequest listFilesRequest = new ListFilesRequest();
        listFilesRequest.setKeyword(null);
        listFilesRequest.setProjectId(Long.valueOf(Long.parseLong(projectId)));
        listFilesRequest.setNeedContent(Boolean.valueOf(true));
        listFilesRequest.setNeedAbsoluteFolderPath(Boolean.valueOf(true));
        List listFilesResponseBodyDataFiles = null;
        listFilesResponseBodyDataFiles = this.dwClient.listFiles(listFilesRequest);
        return listFilesResponseBodyDataFiles;
    }

    public List<GetFileResponseBody.GetFileResponseBodyData> getWorkflowNodeDetailList(String projectId) {
        List<Object> nodeList = new ArrayList();
        try {
            nodeList = this.getWorkflowNodeList(projectId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ArrayList<GetFileResponseBody.GetFileResponseBodyData> nodeDetailList = new ArrayList<GetFileResponseBody.GetFileResponseBodyData>();
        nodeList.forEach(node -> {
            try {
                GetFileRequest getFileRequest = new GetFileRequest();
                getFileRequest.setFileId(node.getFileId());
                getFileRequest.setProjectId(Long.valueOf(Long.parseLong(projectId)));
                GetFileResponseBody.GetFileResponseBodyData nodeDetail = null;
                GetFileResponse response = this.dwClient.getFile(getFileRequest);
                nodeDetail = response.getBody().getData();
                nodeDetailList.add(nodeDetail);
                log.info("Get node: {}, {}", (Object)nodeDetail.getFile().getFileName(), (Object)nodeDetail.getFile().getFileId());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return nodeDetailList;
    }

    public Map<String, String> getFolderList(String projectId) throws InterruptedException {
        return this.dwClient.getFolderList(Long.parseLong(projectId));
    }

    public String getFolderPathById(String projectId, String folderId) {
        return this.dwClient.getFolderPathById(Long.parseLong(projectId), folderId);
    }

    public CustomCreateFileResponse sendRequest(CustomCreateFileRequest request) throws Exception {
        CustomCreateFileResponse response = this.dwClient.createFileTemplate(request);
        return response;
    }

    public Long getRequestTimesCount() {
        return this.dwClient.getRequestTimesCount();
    }

    public List<ListDataSourcesResponseBody.ListDataSourcesResponseBodyDataDataSources> getDatasourceList(String projectId) {
        try {
            return this.dwClient.getDatasourceList(Long.parseLong(projectId));
        }
        catch (Exception e) {
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.READER_READ_FAILED);
        }
    }
}

