/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dataarts.convert.di.util;

import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.RebuildPartitionDTO;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.util.ParamTemplateUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class PartitionUtils {
    private static final Logger log = LoggerFactory.getLogger(PartitionUtils.class);

    public static RebuildPartitionDTO rebuildPartitionValueAndBackParam(String sourcePartition) {
        HashMap<String, String> dwParamMap = new HashMap<String, String>();
        ArrayList<CallSite> targetPartitionList = new ArrayList<CallSite>();
        for (String sourcePartitionItem : sourcePartition.split("&&")) {
            String dwParam = null;
            String fhao = ">=";
            String targetPartitionItem = null;
            if (sourcePartitionItem.contains(">=")) {
                dwParam = ParamTemplateUtils.converToDwDayParam(sourcePartitionItem.split(">=")[1]);
                fhao = ">=";
            } else if (sourcePartitionItem.contains(">")) {
                dwParam = ParamTemplateUtils.converToDwDayParam(sourcePartitionItem.split(">")[1]);
                fhao = ">";
            } else if (sourcePartitionItem.contains("<=")) {
                dwParam = ParamTemplateUtils.converToDwDayParam(sourcePartition.split("<=")[1]);
                fhao = "<=";
            } else if (sourcePartitionItem.contains("<")) {
                dwParam = ParamTemplateUtils.converToDwDayParam(sourcePartitionItem.split("<")[1]);
                fhao = "<";
            }
            if (StringUtils.isEmpty((CharSequence)dwParam)) {
                log.error("======dwParam is empty,sourcePartitionItem:{}", (Object)sourcePartitionItem);
                continue;
            }
            if (fhao.equals(">=") || fhao.equals(">")) {
                dwParamMap.put("partitionStart", dwParam);
                targetPartitionItem = sourcePartitionItem.split(fhao)[0] + fhao + "${partitionStart}";
            } else if (fhao.equals("<=") || fhao.equals("<")) {
                dwParamMap.put("partitionEnd", dwParam);
                targetPartitionItem = sourcePartitionItem.split(fhao)[0] + fhao + "${partitionEnd}";
            }
            targetPartitionList.add((CallSite)((Object)targetPartitionItem));
        }
        if (!CollectionUtils.isEmpty(targetPartitionList)) {
            RebuildPartitionDTO rebuildPartitionDTO = new RebuildPartitionDTO();
            rebuildPartitionDTO.setDwParamMap(dwParamMap);
            rebuildPartitionDTO.setTargetPartition(StringUtils.join(targetPartitionList, (String)" and "));
            return rebuildPartitionDTO;
        }
        return null;
    }
}

