/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dataarts.convert.di.config;

import com.aliyun.migration.spec.domain.ConnectionMapping;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.TableMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataArtsDiConfig {
    private static final Logger log = LoggerFactory.getLogger(DataArtsDiConfig.class);
    private BwmConfiguration bwmConfiguration;

    public void init(String bwmConfigurationStr) {
        if (StringUtils.isBlank((String)bwmConfigurationStr)) {
            this.bwmConfiguration = BwmConfiguration.from((String)"{}");
            return;
        }
        this.bwmConfiguration = BwmConfiguration.from((String)bwmConfigurationStr);
    }

    public ConnectionMapping getConnectionMapping(String dataArtsLinkName) {
        if (StringUtils.isBlank((String)dataArtsLinkName) || Objects.isNull(this.bwmConfiguration)) {
            log.warn("\u6570\u636e\u6e90" + dataArtsLinkName + "\u672a\u914d\u7f6e\u6620\u5c04\u89c4\u5219\uff0c\u5df2\u8d4b\u9ed8\u8ba4");
            return this.getDefaultConnMapping();
        }
        Object diDsMapObj = this.bwmConfiguration.getMap("self").get("di.datasource.map");
        if (Objects.isNull(diDsMapObj)) {
            log.warn("not found di ds config");
            return this.getDefaultConnMapping();
        }
        List connMappingList = (List)BwmJsonUtil.parseObject((String)BwmJsonUtil.toJsonString(diDsMapObj), (TypeReference)new TypeReference<List<ConnectionMapping>>(){});
        for (ConnectionMapping conn : connMappingList) {
            if (!Objects.nonNull(conn) || !dataArtsLinkName.equals(conn.getDataArtsLinkName())) continue;
            return conn;
        }
        return this.getDefaultConnMapping();
    }

    public ConnectionMapping getConnectionMapping(String dataArtsLinkName, String database) {
        ConnectionMapping connectionMapping = this.getDefaultConnMapping();
        if (database != null) {
            connectionMapping = this.getConnectionMapping(dataArtsLinkName + "." + database);
        }
        if (connectionMapping.getDataArtsLinkDataSourceType().equals("default_link_type")) {
            connectionMapping = this.getConnectionMapping(dataArtsLinkName);
        }
        return connectionMapping;
    }

    private ConnectionMapping getDefaultConnMapping() {
        ConnectionMapping connectionMapping = new ConnectionMapping();
        connectionMapping.setDataArtsLinkName("default_link_name");
        connectionMapping.setDataArtsLinkDataSourceType("default_link_type");
        connectionMapping.setDwConnectionName("default_dw_type");
        connectionMapping.setDwDataSourceType("default_dw_type");
        return connectionMapping;
    }

    public String getMcDatasource(String dataArtsDataBase) {
        HashMap map = this.bwmConfiguration.getMap("mc.datasource.map", new HashMap());
        if (null == map) {
            map = new HashMap();
        }
        return map.getOrDefault(dataArtsDataBase, "default_dw_type").toString();
    }

    public TableMetadata getTableMetadata(String dataArtsTableName) {
        List list = this.bwmConfiguration.getList("table.meta.list", new ArrayList());
        for (Object o : list) {
            TableMetadata tableMetadata = (TableMetadata)BwmJsonUtil.parseObject((String)o.toString(), TableMetadata.class);
            if (!Objects.nonNull(tableMetadata) || !tableMetadata.getTableName().equals(dataArtsTableName)) continue;
            return tableMetadata;
        }
        return null;
    }

    public String getHBasePluginVersion() {
        return this.bwmConfiguration.getString("hBasePluginVersion", "");
    }

    public BwmConfiguration getBwmConfiguration() {
        return this.bwmConfiguration;
    }

    public void setBwmConfiguration(BwmConfiguration bwmConfiguration) {
        this.bwmConfiguration = bwmConfiguration;
    }
}

