/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dataarts.convert.di;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.migration.spec.domain.ConnectionMapping;
import com.aliyun.migration.spec.domain.DataArtsJobParamDTO;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfig;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfigInput;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfigValues;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobExtendedConfigs;
import com.aliyun.migration.spec.domain.constant.DataArtsConstant;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.DISetpTypeHandler;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.annotation.DIRef;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.config.DataArtsDiConfig;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptStep;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptStepParameter;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.util.Base64Utils;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.util.DataArtsUtil;
import io.micrometer.common.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DIRef(value="SQLSERVER_STEP_TYPE")
public class SqlServerStepTypeHandler
implements DISetpTypeHandler {
    private static final Logger log = LoggerFactory.getLogger(SqlServerStepTypeHandler.class);

    @Override
    public DiScriptStep convertToDwSourceStep(DataArtsDiConfig config, List<DataArtsJobParamDTO> jobParams, DataArtsCdmJobConfigValues dataArtsCdmJobConfigValues, String dataArtsLinkName) throws RuntimeException {
        DiScriptStep diScriptStep = new DiScriptStep();
        diScriptStep.setName("Reader");
        diScriptStep.setStepType("sqlserver");
        diScriptStep.setCategory("reader");
        DiScriptStepParameter setepParameter = new DiScriptStepParameter();
        ConnectionMapping dwFromDataSource = config.getConnectionMapping(dataArtsLinkName);
        setepParameter.setDatasource(dwFromDataSource.getDwConnectionName());
        setepParameter.setDatasource(config.getConnectionMapping(dataArtsLinkName).getDwConnectionName());
        List inputList = ((DataArtsCdmJobConfig)dataArtsCdmJobConfigValues.getConfigs().get(0)).getInputs();
        for (DataArtsCdmJobConfigInput input : inputList) {
            if ("fromJobConfig.useSql".equals(input.getName()) && Boolean.valueOf(input.getValue()).booleanValue()) {
                setepParameter.setQuerySql(DataArtsUtil.getSql(inputList).replace("\"", "`"));
                continue;
            }
            if ("fromJobConfig.tableName".equals(input.getName())) {
                setepParameter.setTable(input.getValue());
                continue;
            }
            if ("fromJobConfig.columnList".equals(input.getName())) {
                setepParameter.setColumn(Arrays.asList(input.getValue().split("&")));
                continue;
            }
            if ("fromJobConfig.whereClause".equals(input.getName())) {
                setepParameter.setWhere(Base64Utils.decodeUtf8(input.getValue()));
                continue;
            }
            if (!"fromJobConfig.partitionColumn".equals(input.getName())) continue;
            setepParameter.setSplitPk(input.getValue());
        }
        diScriptStep.setParameter(setepParameter);
        return diScriptStep;
    }

    @Override
    public DiScriptStep convertToDwDestStep(DataArtsDiConfig config, DataArtsCdmJobConfigValues dataArtsCdmJobConfigValues, String dataArtsLinkName) {
        DataArtsCdmJobConfig dataArtsCdmJobConfig = (DataArtsCdmJobConfig)dataArtsCdmJobConfigValues.getConfigs().get(0);
        DataArtsCdmJobExtendedConfigs dataArtsCdmJobExtendedConfigs = dataArtsCdmJobConfigValues.getExtendedConfigs();
        ConnectionMapping dwFromDataSource = config.getConnectionMapping(dataArtsLinkName);
        DiScriptStep diScriptStep = new DiScriptStep();
        diScriptStep.setName("Writer");
        diScriptStep.setStepType("sqlserver");
        diScriptStep.setCategory("writer");
        DiScriptStepParameter setepParameter = new DiScriptStepParameter();
        setepParameter.setDatasource(dwFromDataSource.getDwConnectionName());
        ArrayList<String> preSql = new ArrayList<String>();
        if (dataArtsCdmJobExtendedConfigs != null && "toJobConfig.extendedFields".equals(dataArtsCdmJobExtendedConfigs.getName()) && StringUtils.isNotEmpty((String)dataArtsCdmJobExtendedConfigs.getValue())) {
            String extendedFieldsValue = null;
            try {
                extendedFieldsValue = new String(Base64.getDecoder().decode(dataArtsCdmJobExtendedConfigs.getValue()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            final JSONObject extendedFieldsValueJson = JSON.parseObject(extendedFieldsValue);
            if (extendedFieldsValueJson.containsKey((Object)"preSql")) {
                preSql.add(extendedFieldsValueJson.getString("presql"));
            }
            if (extendedFieldsValueJson.containsKey((Object)"postSql")) {
                setepParameter.setPostSql((List<String>)new ArrayList<String>(){
                    {
                        this.add(extendedFieldsValueJson.getString("presql"));
                    }
                });
            }
        }
        boolean deleteAllOldData = false;
        List inputList = dataArtsCdmJobConfig.getInputs();
        for (DataArtsCdmJobConfigInput input : inputList) {
            if ("toJobConfig.tableName".equals(input.getName())) {
                setepParameter.setTable(input.getValue());
                continue;
            }
            if ("toJobConfig.columnList".equals(input.getName())) {
                setepParameter.setColumn(Arrays.asList(input.getValue().split("&")));
                continue;
            }
            if (!"toJobConfig.beforeImportType".equals(input.getName()) || !input.getValue().equals("shouldClearTable")) continue;
            deleteAllOldData = true;
        }
        if (deleteAllOldData) {
            preSql.add("TRUNCATE  TABLE " + setepParameter.getTable() + ";");
        }
        setepParameter.setBatchSize(DataArtsConstant.DW_DI_SYNC_BATCH_SIZE);
        setepParameter.setPreSql(preSql);
        diScriptStep.setParameter(setepParameter);
        return diScriptStep;
    }
}

