/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dataarts.convert.di;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.migration.spec.domain.ConnectionMapping;
import com.aliyun.migration.spec.domain.DataArtsJobParamDTO;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfig;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfigInput;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfigValues;
import com.aliyun.migration.spec.domain.constant.DataArtsConstant;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.DISetpTypeHandler;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.annotation.DIRef;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.config.DataArtsDiConfig;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptStep;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptStepParameter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DIRef(value="OSS_STEP_TYPE")
public class OSSStepTypeHandler
implements DISetpTypeHandler {
    private static final Logger log = LoggerFactory.getLogger(OSSStepTypeHandler.class);

    @Override
    public DiScriptStep convertToDwSourceStep(DataArtsDiConfig config, List<DataArtsJobParamDTO> jobParams, DataArtsCdmJobConfigValues dataArtsCdmJobConfigValues, String dataArtsLinkName) {
        DiScriptStep diScriptStep = new DiScriptStep();
        diScriptStep.setName("Reader");
        diScriptStep.setStepType("oss");
        diScriptStep.setCategory("reader");
        DiScriptStepParameter setepParameter = new DiScriptStepParameter();
        setepParameter.setDatasource(config.getConnectionMapping(dataArtsLinkName).getDwConnectionName());
        List inputList = ((DataArtsCdmJobConfig)dataArtsCdmJobConfigValues.getConfigs().get(0)).getInputs();
        String schemaName = "public";
        for (DataArtsCdmJobConfigInput input : inputList) {
            if ("fromJobConfig.columnList".equals(input.getName())) {
                ArrayList<String> columnList = new ArrayList<String>();
                for (String column : input.getValue().split("&")) {
                    columnList.add(column);
                }
                setepParameter.setColumn(columnList);
                continue;
            }
            if ("fromJobConfig.inputFormat".equals(input.getName())) {
                setepParameter.setFileFormat(input.getValue());
                continue;
            }
            if ("fromJobConfig.fieldSeparator".equals(input.getName())) {
                setepParameter.setFieldDelimiter(input.getValue());
                continue;
            }
            if ("fromJobConfig.firstRowAsHeader".equals(input.getName())) {
                setepParameter.setSkipHeader(input.getValue());
                continue;
            }
            if (!"fromJobConfig.encodeType".equals(input.getName())) continue;
            setepParameter.setEncoding(input.getValue());
        }
        setepParameter.setTable(schemaName + "." + setepParameter.getTable());
        diScriptStep.setParameter(setepParameter);
        return diScriptStep;
    }

    @Override
    public DiScriptStep convertToDwDestStep(DataArtsDiConfig config, DataArtsCdmJobConfigValues dataArtsCdmJobConfigValues, String dataArtsLinkName) {
        ConnectionMapping dwFromDataSource = config.getConnectionMapping(dataArtsLinkName);
        DiScriptStep diScriptStep = new DiScriptStep();
        diScriptStep.setName("Writer");
        diScriptStep.setStepType("oss");
        diScriptStep.setCategory("writer");
        DiScriptStepParameter setepParameter = new DiScriptStepParameter();
        setepParameter.setDatasource(dwFromDataSource.getDwConnectionName());
        setepParameter.setBatchSize(DataArtsConstant.DW_DI_SYNC_BATCH_SIZE);
        diScriptStep.setParameter(setepParameter);
        return diScriptStep;
    }

    public static void main(String[] args) {
        ArrayList<String> columnList1 = new ArrayList<String>();
        columnList1.add("user");
        columnList1.add("name");
        ArrayList<CallSite> columnList = new ArrayList<CallSite>();
        for (String string : columnList1) {
            String string2 = "\"" + string + "\"";
            columnList.add((CallSite)((Object)string2));
        }
        System.err.println(JSONObject.toJSONString(columnList));
    }
}

