/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.expression.AggregateNumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.SimpleNumericAggregateMethod;
import org.datanucleus.util.Localiser;

public class SumFunction
extends SimpleNumericAggregateMethod {
    @Override
    protected String getFunctionName() {
        return "SUM";
    }

    @Override
    public SQLExpression getExpression(SQLExpression expr, List<SQLExpression> args) {
        if (expr == null) {
            if (args == null || args.size() != 1) {
                throw new NucleusException(this.getFunctionName() + " is only supported with a single argument");
            }
            SQLExpression argExpr = args.get(0);
            JavaTypeMapping m = null;
            Class cls = argExpr.getJavaTypeMapping().getJavaType();
            if (cls == Integer.class || cls == Short.class || cls == Long.class) {
                m = this.getMappingForClass(Long.class);
            } else if (Number.class.isAssignableFrom(cls)) {
                m = this.getMappingForClass(argExpr.getJavaTypeMapping().getJavaType());
            } else {
                throw new NucleusUserException("Cannot perform static SUM with arg of type " + cls.getName());
            }
            return new AggregateNumericExpression(this.stmt, m, this.getFunctionName(), args);
        }
        throw new NucleusException(Localiser.msg((String)"060002", (Object[])new Object[]{this.getFunctionName(), expr}));
    }

    @Override
    protected Class getClassForMapping() {
        return Double.TYPE;
    }
}

