/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.utils.cloud;

import com.aliyun.migration.api.exception.HealthCheckException;
import com.aliyun.migration.workflow.migration.common.utils.cloud.CloudStoreClient;
import com.aliyun.migration.workflow.migration.common.utils.cloud.ProgressListener;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCloudClient
implements CloudStoreClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractCloudClient.class);
    private ProgressListener progressListener;

    protected void uploadProgress(String bucketName, String objectName, InputStream inputStream) {
        int total = -1;
        try {
            if (inputStream == null || inputStream.available() == 0) {
                return;
            }
            total = inputStream.available();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        while (true) {
            InputStream tmpInput = inputStream;
            try {
                int progress = (int)((double)(total - tmpInput.available()) * 100.0 / (double)total);
                if (this.progressListener != null) {
                    this.progressListener.uploadProgress(bucketName, objectName, progress);
                }
                if (tmpInput.available() == 0) {
                }
            }
            catch (IOException e) {}
            break;
            try {
                Thread.sleep(this.progressListener == null || this.progressListener.getIntervalTimeMs() <= 0L ? 100L : this.progressListener.getIntervalTimeMs());
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
        try {
            this.statObject(bucketName, objectName);
            if (this.progressListener != null) {
                this.progressListener.uploadProgress(bucketName, objectName, 100);
            }
        }
        catch (Exception e) {
            log.error(objectName + "\u4e0a\u4f20\u5931\u8d25, e:" + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public abstract void healthCheck() throws HealthCheckException;

    public abstract void statObject(String var1, String var2) throws Exception;
}

