/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.utils;

import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobUtil {
    private static final Logger log = LoggerFactory.getLogger(JobUtil.class);

    public static JobDetail buildJobDetail(String clazz, String jobName, String groupName, Map<String, Object> params) throws ClassNotFoundException {
        return JobUtil.jobBuilder(clazz, jobName, groupName).usingJobData(new JobDataMap(params)).build();
    }

    public static JobBuilder jobBuilder(String clazz, String jobName, String groupName) throws ClassNotFoundException {
        Class<?> jobClass = Class.forName(clazz);
        JobBuilder jobBuilder = JobBuilder.newJob(jobClass).withIdentity(jobName, groupName);
        return jobBuilder;
    }

    public static Trigger buildCronTrigger(Integer interval, String cronExpr, String jobName, String groupName) {
        if (StringUtils.isNotBlank((CharSequence)cronExpr)) {
            return JobUtil.buildCronTrigger(cronExpr, jobName, groupName);
        }
        if (interval != null) {
            return JobUtil.buildCronTrigger(interval, jobName, groupName);
        }
        return null;
    }

    public static Trigger buildCronTrigger(String cronExpr, String jobName, String groupName) {
        CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronExpr).withMisfireHandlingInstructionDoNothing();
        return TriggerBuilder.newTrigger().withIdentity(jobName, groupName).withSchedule((ScheduleBuilder)scheduleBuilder).build();
    }

    public static Trigger buildCronTrigger(Integer interval, String jobName, String groupName) {
        return TriggerBuilder.newTrigger().withIdentity(jobName, groupName).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(interval.intValue()).repeatForever()).build();
    }

    public static Boolean isExists(Scheduler scheduler, String jobName, String groupName) throws SchedulerException {
        return JobUtil.queryCronTrigger(scheduler, JobUtil.triggerKey(jobName, groupName)) != null;
    }

    public static Trigger buildSimpleTrigger(String jobName, String groupName) {
        return TriggerBuilder.newTrigger().withIdentity(jobName, groupName).startAt(new Date()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(0).withRepeatCount(0)).build();
    }

    public static void setNextFireTime(Scheduler scheduler, TriggerKey triggerKey, Date date) throws SchedulerException {
        SimpleTriggerImpl trigger = (SimpleTriggerImpl)scheduler.getTrigger(triggerKey);
        SimpleTrigger newTrigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(trigger.getJobName(), trigger.getJobGroup()).startAt(date).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds((int)trigger.getRepeatInterval() / 1000).withRepeatCount(trigger.getRepeatCount())).build();
        scheduler.rescheduleJob(triggerKey, (Trigger)newTrigger);
    }

    public static CronTrigger queryCronTrigger(Scheduler scheduler, String jobName, String groupName) throws SchedulerException {
        return JobUtil.queryCronTrigger(scheduler, JobUtil.triggerKey(jobName, groupName));
    }

    public static CronTrigger queryCronTrigger(Scheduler scheduler, TriggerKey triggerKey) throws SchedulerException {
        return (CronTrigger)scheduler.getTrigger(triggerKey);
    }

    public static TriggerKey triggerKey(String jobName, String groupName) {
        return new TriggerKey(jobName, groupName);
    }

    public static JobDetail resetJobParams(Scheduler scheduler, String jobName, String groupName, Map<String, Object> params) throws SchedulerException {
        JobDetail jobDetail = JobUtil.queryJobDetail(scheduler, jobName, groupName);
        jobDetail.getJobDataMap().putAll(params);
        return jobDetail;
    }

    public static JobDetail queryJobDetail(Scheduler scheduler, String jobName, String groupName) throws SchedulerException {
        return scheduler.getJobDetail(JobUtil.jobKey(jobName, groupName));
    }

    public static JobDetail queryJobDetail(Scheduler scheduler, JobKey jobKey) throws SchedulerException {
        return scheduler.getJobDetail(jobKey);
    }

    public static JobKey jobKey(String jobName, String groupName) {
        return new JobKey(jobName, groupName);
    }
}

