/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.utils;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.credentials.Client;
import com.aliyun.dataworks_public20240518.models.CreateNodeRequest;
import com.aliyun.dataworks_public20240518.models.CreateNodeResponse;
import com.aliyun.dataworks_public20240518.models.CreatePipelineRunRequest;
import com.aliyun.dataworks_public20240518.models.CreatePipelineRunResponse;
import com.aliyun.dataworks_public20240518.models.CreateWorkflowDefinitionRequest;
import com.aliyun.dataworks_public20240518.models.DeleteFolderRequest;
import com.aliyun.dataworks_public20240518.models.DeleteWorkflowDefinitionRequest;
import com.aliyun.dataworks_public20240518.models.ExecPipelineRunStageRequest;
import com.aliyun.dataworks_public20240518.models.ExecPipelineRunStageResponse;
import com.aliyun.dataworks_public20240518.models.GetJobStatusRequest;
import com.aliyun.dataworks_public20240518.models.GetJobStatusResponse;
import com.aliyun.dataworks_public20240518.models.GetJobStatusResponseBody;
import com.aliyun.dataworks_public20240518.models.GetNodeRequest;
import com.aliyun.dataworks_public20240518.models.GetNodeResponse;
import com.aliyun.dataworks_public20240518.models.GetNodeResponseBody;
import com.aliyun.dataworks_public20240518.models.GetPipelineRunRequest;
import com.aliyun.dataworks_public20240518.models.GetPipelineRunResponse;
import com.aliyun.dataworks_public20240518.models.GetPipelineRunResponseBody;
import com.aliyun.dataworks_public20240518.models.GetProjectRequest;
import com.aliyun.dataworks_public20240518.models.GetProjectResponse;
import com.aliyun.dataworks_public20240518.models.GetProjectResponseBody;
import com.aliyun.dataworks_public20240518.models.GetResourceRequest;
import com.aliyun.dataworks_public20240518.models.GetResourceResponse;
import com.aliyun.dataworks_public20240518.models.GetWorkflowDefinitionRequest;
import com.aliyun.dataworks_public20240518.models.GetWorkflowDefinitionResponse;
import com.aliyun.dataworks_public20240518.models.GetWorkflowDefinitionResponseBody;
import com.aliyun.dataworks_public20240518.models.ImportWorkflowDefinitionRequest;
import com.aliyun.dataworks_public20240518.models.ImportWorkflowDefinitionResponse;
import com.aliyun.dataworks_public20240518.models.ListDataSourcesRequest;
import com.aliyun.dataworks_public20240518.models.ListDataSourcesResponse;
import com.aliyun.dataworks_public20240518.models.ListDataSourcesResponseBody;
import com.aliyun.dataworks_public20240518.models.ListFoldersRequest;
import com.aliyun.dataworks_public20240518.models.ListFoldersResponse;
import com.aliyun.dataworks_public20240518.models.ListNodesRequest;
import com.aliyun.dataworks_public20240518.models.ListNodesResponse;
import com.aliyun.dataworks_public20240518.models.ListNodesResponseBody;
import com.aliyun.dataworks_public20240518.models.ListPipelineRunItemsRequest;
import com.aliyun.dataworks_public20240518.models.ListPipelineRunItemsResponse;
import com.aliyun.dataworks_public20240518.models.ListPipelineRunItemsResponseBody;
import com.aliyun.dataworks_public20240518.models.ListPipelineRunsRequest;
import com.aliyun.dataworks_public20240518.models.ListPipelineRunsResponse;
import com.aliyun.dataworks_public20240518.models.ListPipelineRunsResponseBody;
import com.aliyun.dataworks_public20240518.models.ListProjectMembersRequest;
import com.aliyun.dataworks_public20240518.models.ListProjectMembersResponse;
import com.aliyun.dataworks_public20240518.models.ListProjectsRequest;
import com.aliyun.dataworks_public20240518.models.ListProjectsResponse;
import com.aliyun.dataworks_public20240518.models.ListProjectsResponseBody;
import com.aliyun.dataworks_public20240518.models.ListResourceGroupsRequest;
import com.aliyun.dataworks_public20240518.models.ListResourceGroupsResponse;
import com.aliyun.dataworks_public20240518.models.ListResourcesRequest;
import com.aliyun.dataworks_public20240518.models.ListResourcesResponse;
import com.aliyun.dataworks_public20240518.models.ListWorkflowDefinitionsRequest;
import com.aliyun.dataworks_public20240518.models.ListWorkflowDefinitionsResponse;
import com.aliyun.dataworks_public20240518.models.UpdateNodeRequest;
import com.aliyun.dataworks_public20240518.models.UpdateNodeResponse;
import com.aliyun.dataworks_public20240518.models.UpdateWorkflowDefinitionRequest;
import com.aliyun.dataworks_public20240518.models.UpdateWorkflowDefinitionResponse;
import com.aliyun.migration.spec.domain.dataworks.DwNewideAsyncJobLog;
import com.aliyun.migration.spec.domain.dataworks.WorkflowMainSpec;
import com.aliyun.migration.workflow.migration.common.utils.PageUtil;
import com.aliyun.tea.TeaException;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.Common;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwNewideClient {
    private static final Logger log = LoggerFactory.getLogger(DwNewideClient.class);
    private com.aliyun.dataworks_public20240518.Client client;
    private List<DwNewideAsyncJobLog> jobStatusPool;
    private Long delayInterval = 200L;
    private Long queryJobStatusInterval = 1000L;
    private Long apiCallCount;

    public DwNewideClient(String accessKeyId, String accessKeySecret, String endpoint, String region) {
        try {
            this.client = this.createClient(accessKeyId, accessKeySecret, endpoint, region);
        }
        catch (Exception e) {
            log.error("Create DwNewideClient error", (Throwable)e);
        }
        this.apiCallCount = 0L;
    }

    public void qpsControl(Integer qps) {
        qps = qps > 20 ? 20 : qps;
        qps = qps < 1 ? 1 : qps;
        this.delayInterval = Integer.toUnsignedLong(1000 / qps);
    }

    private com.aliyun.dataworks_public20240518.Client createClient(String accessKeyId, String accessKeySecret, String endpoint, String region) {
        Client credential = new Client();
        Config config = new Config().setCredential(credential).setEndpoint(endpoint).setRegionId(region).setAccessKeyId(accessKeyId).setAccessKeySecret(accessKeySecret);
        try {
            return new com.aliyun.dataworks_public20240518.Client(config);
        }
        catch (Exception e) {
            log.error("Create DwNewideClient error", (Throwable)e);
            return null;
        }
    }

    private void addOneJobInListening(String jobId, String apiName, DwNewideAsyncJobLog.ElementType elementType, String elementId) {
        if (this.jobStatusPool == null) {
            this.jobStatusPool = new ArrayList<DwNewideAsyncJobLog>();
        }
        DwNewideAsyncJobLog jobLog = new DwNewideAsyncJobLog();
        jobLog.setJobId(jobId);
        jobLog.setApiName(apiName);
        jobLog.setElementType(elementType);
        jobLog.setElementId(elementId);
        this.jobStatusPool.add(jobLog);
        log.info("addOneJobInListening jobId={} apiName={} elementType={} elementId={}", new Object[]{jobId, apiName, elementType, elementId});
    }

    public DwNewideAsyncJobLog getDwNewideAsyncJobLogByElementId(String elementId) {
        if (this.jobStatusPool == null) {
            return null;
        }
        for (DwNewideAsyncJobLog log : this.jobStatusPool) {
            if (!log.getElementId().equals(elementId)) continue;
            return log;
        }
        return null;
    }

    public void createWorkflowDefinition(CreateWorkflowDefinitionRequest request) {
        try {
            Thread.sleep(this.delayInterval);
            Long l = this.apiCallCount;
            this.apiCallCount = this.apiCallCount + 1L;
            this.client.createWorkflowDefinition(request);
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            System.out.println(error.getMessage());
            System.out.println(error.getData().get("Recommend"));
            Common.assertAsString((Object)error.message);
        }
    }

    public String importWorkflowDefinition(String projectId, String spec) {
        ImportWorkflowDefinitionRequest request = new ImportWorkflowDefinitionRequest();
        request.setProjectId(Long.valueOf(Long.parseLong(projectId)));
        request.setSpec(spec);
        try {
            Thread.sleep(this.delayInterval);
            Long l = this.apiCallCount;
            this.apiCallCount = this.apiCallCount + 1L;
            ImportWorkflowDefinitionResponse response = this.client.importWorkflowDefinition(request);
            log.info("importWorkflowDefinition requestId={}", (Object)response.getBody().getRequestId());
            this.addOneJobInListening(response.getBody().getAsyncJob().getId(), "ImportWorkflowDefinition", DwNewideAsyncJobLog.ElementType.WORKFLOW, response.getBody().getAsyncJob().getResponse());
            return response.getBody().getAsyncJob().getResponse();
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            System.out.println(error.getMessage());
            System.out.println(error.getData().get("Recommend"));
            Common.assertAsString((Object)error.message);
            return null;
        }
    }

    public Boolean updateWorkflowDefinition(String projectId, String workflowId, String spec) {
        UpdateWorkflowDefinitionRequest request = new UpdateWorkflowDefinitionRequest();
        request.setProjectId(Long.valueOf(Long.parseLong(projectId)));
        request.setId(Long.valueOf(Long.parseLong(workflowId)));
        request.setSpec(spec);
        try {
            Thread.sleep(this.delayInterval);
            Long l = this.apiCallCount;
            this.apiCallCount = this.apiCallCount + 1L;
            UpdateWorkflowDefinitionResponse response = this.client.updateWorkflowDefinition(request);
            return response.getBody().getSuccess();
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            System.out.println(error.getMessage());
            System.out.println(error.getData().get("Recommend"));
            Common.assertAsString((Object)error.message);
            return false;
        }
    }

    public GetJobStatusResponseBody.GetJobStatusResponseBodyJobStatus getAsyncJobStatus(String jobId) {
        GetJobStatusRequest request = new GetJobStatusRequest();
        request.setJobId(jobId);
        try {
            Thread.sleep(this.delayInterval);
            Long l = this.apiCallCount;
            this.apiCallCount = this.apiCallCount + 1L;
            GetJobStatusResponse response = this.client.getJobStatus(request);
            return response.getBody().getJobStatus();
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            System.out.println(error.getMessage());
            System.out.println(error.getData().get("Recommend"));
            Common.assertAsString((Object)error.message);
            return null;
        }
    }

    public Boolean isAnyJobInRunning() {
        if (this.jobStatusPool == null && this.jobStatusPool.size() == 0) {
            return false;
        }
        for (DwNewideAsyncJobLog jobLog : this.jobStatusPool) {
            if (jobLog.getJobStatus() != null && !jobLog.getJobStatus().equals((Object)DwNewideAsyncJobLog.JobStatus.RUNNING)) continue;
            GetJobStatusResponseBody.GetJobStatusResponseBodyJobStatus jobStatus = this.getAsyncJobStatus(jobLog.getJobId());
            jobLog.setJobType(DwNewideAsyncJobLog.JobType.valueOf((String)jobStatus.getJobType().toUpperCase()));
            jobLog.setJobStatus(DwNewideAsyncJobLog.JobStatus.valueOf((String)jobStatus.getStatus().toUpperCase()));
            jobLog.setErrorMsg(jobStatus.getError());
            if (jobLog.getJobStatus().equals((Object)DwNewideAsyncJobLog.JobStatus.RUNNING)) {
                return true;
            }
            log.info("getAsyncJobStatus jobId={} apiName={} elementType={} elementId={} jobType={} jobStatus={} errorMsg={}", new Object[]{jobLog.getJobId(), jobLog.getApiName(), jobLog.getElementType(), jobLog.getElementId(), jobLog.getJobType(), jobLog.getJobStatus(), jobLog.getErrorMsg()});
        }
        return false;
    }

    public void waitingForComplete() {
        while (this.isAnyJobInRunning().booleanValue()) {
            try {
                Thread.sleep(this.queryJobStatusInterval);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public ListWorkflowDefinitionsResponse listWorkflowDefinitions(ListWorkflowDefinitionsRequest request) {
        try {
            Thread.sleep(this.delayInterval);
            Long l = this.apiCallCount;
            this.apiCallCount = this.apiCallCount + 1L;
            return this.client.listWorkflowDefinitions(request);
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            System.out.println(error.getMessage());
            System.out.println(error.getData().get("Recommend"));
            Common.assertAsString((Object)error.message);
            return null;
        }
    }

    public GetWorkflowDefinitionResponse getWorkflowDefinition(String projectId, String workflowId, Boolean needNodeScript) {
        GetWorkflowDefinitionRequest request = new GetWorkflowDefinitionRequest();
        request.setProjectId(Long.valueOf(Long.parseLong(projectId)));
        request.setId(Long.valueOf(Long.parseLong(workflowId)));
        request.setIncludeScriptContent(needNodeScript);
        try {
            Thread.sleep(this.delayInterval);
            Long l = this.apiCallCount;
            this.apiCallCount = this.apiCallCount + 1L;
            return this.client.getWorkflowDefinition(request);
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            System.out.println(error.getMessage());
            if (error.getData() != null) {
                System.out.println(error.getData().get("Recommend"));
            }
            Common.assertAsString((Object)error.message);
            return null;
        }
    }

    public List<String> listWorkflowIds(String projectId) {
        PageUtil.Paginator paginator = new PageUtil.Paginator();
        paginator.setPageSize(100);
        paginator.setPageNum(1);
        ArrayList<String> result = new ArrayList<String>();
        try {
            PageUtil.doPaginate(paginator, p -> {
                try {
                    ListWorkflowDefinitionsRequest request = new ListWorkflowDefinitionsRequest();
                    request.setProjectId(Long.valueOf(Long.parseLong(projectId)));
                    request.setType("CycleWorkflow");
                    request.setPageNumber(Integer.valueOf(p.getPageNum()));
                    request.setPageSize(Integer.valueOf(p.getPageSize()));
                    Thread.sleep(this.delayInterval);
                    Long l = this.apiCallCount;
                    this.apiCallCount = this.apiCallCount + 1L;
                    ListWorkflowDefinitionsResponse response = this.client.listWorkflowDefinitions(request);
                    ArrayList wfIdList = new ArrayList();
                    response.getBody().getPagingInfo().getWorkflowDefinitions().forEach(wf -> wfIdList.add(String.valueOf(wf.getId())));
                    result.addAll(wfIdList);
                    Integer count = wfIdList.size();
                    PageUtil.PaginateResult paginateResult = new PageUtil.PaginateResult();
                    paginateResult.setPageNum(p.getPageNum());
                    paginateResult.setPageSize(p.getPageSize());
                    paginateResult.setData(wfIdList);
                    paginateResult.setTotalCount(count);
                    log.info("...\u5206\u9875\u7d2f\u8ba1\u83b7\u53d6{}", (Object)result.size());
                    return paginateResult;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (InterruptedException e) {
            log.error("listWorkflowIds error", (Throwable)e);
        }
        return result;
    }

    public List<String> listManualWorkflowIds(String projectId) {
        PageUtil.Paginator paginator = new PageUtil.Paginator();
        paginator.setPageSize(100);
        paginator.setPageNum(1);
        ArrayList<String> result = new ArrayList<String>();
        try {
            PageUtil.doPaginate(paginator, p -> {
                try {
                    ListWorkflowDefinitionsRequest request = new ListWorkflowDefinitionsRequest();
                    request.setProjectId(Long.valueOf(Long.parseLong(projectId)));
                    request.setType("ManualWorkflow");
                    request.setPageNumber(Integer.valueOf(p.getPageNum()));
                    request.setPageSize(Integer.valueOf(p.getPageSize()));
                    Thread.sleep(this.delayInterval);
                    Long l = this.apiCallCount;
                    this.apiCallCount = this.apiCallCount + 1L;
                    ListWorkflowDefinitionsResponse response = this.client.listWorkflowDefinitions(request);
                    ArrayList wfIdList = new ArrayList();
                    response.getBody().getPagingInfo().getWorkflowDefinitions().forEach(wf -> wfIdList.add(String.valueOf(wf.getId())));
                    result.addAll(wfIdList);
                    Integer count = wfIdList.size();
                    PageUtil.PaginateResult paginateResult = new PageUtil.PaginateResult();
                    paginateResult.setPageNum(p.getPageNum());
                    paginateResult.setPageSize(p.getPageSize());
                    paginateResult.setData(wfIdList);
                    paginateResult.setTotalCount(count);
                    log.info("...\u5206\u9875\u7d2f\u8ba1\u83b7\u53d6{}", (Object)result.size());
                    return paginateResult;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (InterruptedException e) {
            log.error("listWorkflowIds error", (Throwable)e);
        }
        return result;
    }

    public List<WorkflowMainSpec> listWorkflowMainSpec(String projectId, Boolean needNodeScript) {
        List<GetWorkflowDefinitionResponseBody.GetWorkflowDefinitionResponseBodyWorkflowDefinition> wfDefs = this.listWorkflowDefinitions(projectId, needNodeScript);
        ArrayList<WorkflowMainSpec> wflist = new ArrayList<WorkflowMainSpec>();
        Integer i = 0;
        while (i < wfDefs.size()) {
            WorkflowMainSpec workflowMainSpec = this.getWorkflowWithSpec(wfDefs.get(i));
            wflist.add(workflowMainSpec);
            Integer n = i;
            i = i + 1;
        }
        return wflist;
    }

    public List<GetWorkflowDefinitionResponseBody.GetWorkflowDefinitionResponseBodyWorkflowDefinition> listWorkflowDefinitions(String projectId, Boolean needNodeScript) {
        log.info("\u6b63\u5728\u83b7\u53d6{}\u4e2d\u7684\u5de5\u4f5c\u6d41\u5217\u8868...", (Object)projectId);
        List<String> workflowIds = this.listWorkflowIds(projectId);
        log.info("\u83b7\u53d6\u5230\u5de5\u4f5c\u6d41\u5217\u8868, \u5171{}\u4e2a", (Object)workflowIds.size());
        if (workflowIds.isEmpty()) {
            return new ArrayList<GetWorkflowDefinitionResponseBody.GetWorkflowDefinitionResponseBodyWorkflowDefinition>();
        }
        ArrayList<GetWorkflowDefinitionResponseBody.GetWorkflowDefinitionResponseBodyWorkflowDefinition> workflowList = new ArrayList<GetWorkflowDefinitionResponseBody.GetWorkflowDefinitionResponseBodyWorkflowDefinition>();
        Integer i = 0;
        while (i < workflowIds.size()) {
            GetWorkflowDefinitionResponse response = this.getWorkflowDefinition(projectId, workflowIds.get(i), needNodeScript);
            if (response != null && response.getStatusCode().equals(200) && response.getBody().getWorkflowDefinition() != null) {
                log.info("[GET-NEW-WORKFLOW]({}/{}) wfId={} wfName={} requestId={}", new Object[]{i + 1, workflowIds.size(), response.getBody().getWorkflowDefinition().getId(), response.getBody().getWorkflowDefinition().getName(), response.getBody().getRequestId()});
                workflowList.add(response.getBody().getWorkflowDefinition());
            } else {
                log.error("[GET-NEW-WORKFLOW]({}/{}) wfId={} \u83b7\u53d6\u5de5\u4f5c\u6d41\u5931\u8d25: {}", new Object[]{i + 1, workflowIds.size(), workflowIds.get(i), response.getStatusCode(), response.getBody().getRequestId()});
            }
            Integer n = i;
            i = i + 1;
        }
        return workflowList;
    }

    public WorkflowMainSpec getWorkflowWithSpec(GetWorkflowDefinitionResponseBody.GetWorkflowDefinitionResponseBodyWorkflowDefinition workflowDefinition) {
        return WorkflowMainSpec.getWorkflowMainSpec((String)workflowDefinition.getSpec());
    }

    public String getWorkflowJsonStr(WorkflowMainSpec workflowMainSpec) {
        return WorkflowMainSpec.getWorkflowMainSpecJson((WorkflowMainSpec)workflowMainSpec).toJSONString(new JSONWriter.Feature[0]);
    }

    public String createNode(String projectId, String containerId, String spec) {
        CreateNodeRequest request = new CreateNodeRequest();
        request.setProjectId(Long.valueOf(Long.parseLong(projectId)));
        request.setContainerId(Long.valueOf(Long.parseLong(containerId)));
        request.setScene("DataworksProject");
        request.setSpec(spec);
        try {
            Thread.sleep(this.delayInterval);
            Long l = this.apiCallCount;
            this.apiCallCount = this.apiCallCount + 1L;
            CreateNodeResponse response = this.client.createNode(request);
            log.info("createNode requestId={}", (Object)response.getBody().getRequestId());
            return String.valueOf(response.getBody().getId());
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            System.out.println(error.getMessage());
            System.out.println(error.getData().get("Recommend"));
            Common.assertAsString((Object)error.message);
            return null;
        }
    }

    public Boolean updateNode(String projectId, String nodeId, String spec) {
        UpdateNodeRequest request = new UpdateNodeRequest();
        request.setProjectId(Long.valueOf(Long.parseLong(projectId)));
        request.setId(Long.valueOf(Long.parseLong(nodeId)));
        request.setSpec(spec);
        try {
            Thread.sleep(this.delayInterval);
            Long l = this.apiCallCount;
            this.apiCallCount = this.apiCallCount + 1L;
            UpdateNodeResponse response = this.client.updateNode(request);
            log.info("updateNode requestId={}", (Object)response.getBody().getRequestId());
            return response.getBody().getSuccess();
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            System.out.println(error.getMessage());
            System.out.println(error.getData().get("Recommend"));
            Common.assertAsString((Object)error.message);
            return false;
        }
    }

    public List<ListNodesResponseBody.ListNodesResponseBodyPagingInfoNodes> listNodes(String projectId, String containerId) {
        PageUtil.Paginator paginator = new PageUtil.Paginator();
        paginator.setPageSize(100);
        paginator.setPageNum(1);
        ArrayList<ListNodesResponseBody.ListNodesResponseBodyPagingInfoNodes> result = new ArrayList<ListNodesResponseBody.ListNodesResponseBodyPagingInfoNodes>();
        try {
            PageUtil.doPaginate(paginator, p -> {
                try {
                    List<ListNodesResponseBody.ListNodesResponseBodyPagingInfoNodes> data = this.listNodes(projectId, containerId, p.getPageNum(), p.getPageSize());
                    if (data == null) {
                        data = new ArrayList<ListNodesResponseBody.ListNodesResponseBodyPagingInfoNodes>();
                    }
                    result.addAll(data);
                    Integer count = data.size();
                    PageUtil.PaginateResult<ListNodesResponseBody.ListNodesResponseBodyPagingInfoNodes> paginateResult = new PageUtil.PaginateResult<ListNodesResponseBody.ListNodesResponseBodyPagingInfoNodes>();
                    paginateResult.setPageNum(p.getPageNum());
                    paginateResult.setPageSize(p.getPageSize());
                    paginateResult.setData(data);
                    paginateResult.setTotalCount(count);
                    return paginateResult;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (InterruptedException e) {
            log.error("listNodes error", (Throwable)e);
        }
        return result;
    }

    public List<ListNodesResponseBody.ListNodesResponseBodyPagingInfoNodes> listNodes(String projectId, String containerId, Integer pageNumber, Integer pageSize) {
        ListNodesRequest request = new ListNodesRequest();
        request.setProjectId(Long.valueOf(Long.parseLong(projectId)));
        request.setContainerId(Long.valueOf(Long.parseLong(containerId)));
        request.setPageNumber(pageNumber);
        request.setPageSize(pageSize);
        try {
            Thread.sleep(this.delayInterval);
            Long l = this.apiCallCount;
            this.apiCallCount = this.apiCallCount + 1L;
            ListNodesResponse response = this.client.listNodes(request);
            return response.getBody().getPagingInfo().getNodes();
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            System.out.println(error.getMessage());
            System.out.println(error.getData().get("Recommend"));
            Common.assertAsString((Object)error.message);
            return new ArrayList<ListNodesResponseBody.ListNodesResponseBodyPagingInfoNodes>();
        }
    }

    public GetNodeResponseBody.GetNodeResponseBodyNode getNode(String projectId, String nodeId) {
        GetNodeRequest request = new GetNodeRequest();
        request.setProjectId(Long.valueOf(Long.parseLong(projectId)));
        request.setId(Long.valueOf(Long.parseLong(nodeId)));
        try {
            Thread.sleep(this.delayInterval);
            Long l = this.apiCallCount;
            this.apiCallCount = this.apiCallCount + 1L;
            GetNodeResponse response = this.client.getNode(request);
            return response.getBody().getNode();
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            System.out.println(error.getMessage());
            System.out.println(error.getData().get("Recommend"));
            Common.assertAsString((Object)error.message);
            return null;
        }
    }

    public void deleteWorkflowDefinition(String projectId, String workflowId) {
        DeleteWorkflowDefinitionRequest request = new DeleteWorkflowDefinitionRequest();
        request.setProjectId(Long.valueOf(Long.parseLong(projectId)));
        request.setId(Long.valueOf(Long.parseLong(workflowId)));
        try {
            Thread.sleep(this.delayInterval);
            Long l = this.apiCallCount;
            this.apiCallCount = this.apiCallCount + 1L;
            this.client.deleteWorkflowDefinition(request);
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            System.out.println(error.getMessage());
            System.out.println(error.getData().get("Recommend"));
            Common.assertAsString((Object)error.message);
        }
    }

    public List<String> listFolderIds(String projectId) {
        return this.listFolderIdsInPath(projectId, "/");
    }

    public List<String> listFolderIdsInPath(String projectId, String path) {
        PageUtil.Paginator paginator = new PageUtil.Paginator();
        paginator.setPageSize(100);
        paginator.setPageNum(1);
        ArrayList<String> result = new ArrayList<String>();
        ArrayList pathList = new ArrayList();
        try {
            PageUtil.doPaginate(paginator, p -> {
                ListFoldersRequest request = new ListFoldersRequest();
                request.setProjectId(Long.valueOf(Long.parseLong(projectId)));
                request.setParentFolderPath(path);
                request.setPageNumber(Integer.valueOf(p.getPageNum()));
                request.setPageSize(Integer.valueOf(p.getPageSize()));
                ArrayList data = new ArrayList();
                try {
                    Thread.sleep(this.delayInterval);
                    Long l = this.apiCallCount;
                    this.apiCallCount = this.apiCallCount + 1L;
                    ListFoldersResponse response = this.client.listFolders(request);
                    response.getBody().getData().getFolders().forEach(folder -> {
                        data.add(folder.getFolderId().toString());
                        pathList.add(folder.getFolderPath());
                    });
                }
                catch (Exception _error) {
                    TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
                    System.out.println(error.getMessage());
                    System.out.println(error.getData().get("Recommend"));
                    Common.assertAsString((Object)error.message);
                }
                result.addAll(data);
                Integer count = data.size();
                PageUtil.PaginateResult paginateResult = new PageUtil.PaginateResult();
                paginateResult.setPageNum(p.getPageNum());
                paginateResult.setPageSize(p.getPageSize());
                paginateResult.setData(data);
                paginateResult.setTotalCount(count);
                return paginateResult;
            });
        }
        catch (InterruptedException e) {
            log.error("listUserId error", (Throwable)e);
        }
        if (!pathList.isEmpty()) {
            for (String p2 : pathList) {
                result.addAll(this.listFolderIdsInPath(projectId, p2));
            }
        }
        return result;
    }

    public void deleteFolder(String projectId, String folderId) {
        DeleteFolderRequest request = new DeleteFolderRequest();
        request.setProjectId(Long.valueOf(Long.parseLong(projectId)));
        request.setFolderId(folderId);
        try {
            Thread.sleep(this.delayInterval);
            Long l = this.apiCallCount;
            this.apiCallCount = this.apiCallCount + 1L;
            l = this.client.deleteFolder(request);
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            System.out.println(error.getMessage());
            System.out.println(error.getData().get("Recommend"));
            Common.assertAsString((Object)error.message);
        }
    }

    public List<ListProjectsResponseBody.ListProjectsResponseBodyPagingInfoProjects> listProjects() {
        PageUtil.Paginator paginator = new PageUtil.Paginator();
        paginator.setPageSize(100);
        paginator.setPageNum(1);
        ArrayList<ListProjectsResponseBody.ListProjectsResponseBodyPagingInfoProjects> result = new ArrayList<ListProjectsResponseBody.ListProjectsResponseBodyPagingInfoProjects>();
        try {
            PageUtil.doPaginate(paginator, p -> {
                ListProjectsRequest request = new ListProjectsRequest();
                request.setPageNumber(Integer.valueOf(p.getPageNum()));
                request.setPageSize(Integer.valueOf(p.getPageSize()));
                ArrayList data = new ArrayList();
                try {
                    Thread.sleep(this.delayInterval);
                    Long l = this.apiCallCount;
                    this.apiCallCount = this.apiCallCount + 1L;
                    ListProjectsResponse response = this.client.listProjects(request);
                    data.addAll(response.getBody().getPagingInfo().getProjects());
                }
                catch (Exception _error) {
                    TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
                    System.out.println(error.getMessage());
                    System.out.println(error.getData().get("Recommend"));
                    Common.assertAsString((Object)error.message);
                }
                result.addAll(data);
                Integer count = data.size();
                PageUtil.PaginateResult paginateResult = new PageUtil.PaginateResult();
                paginateResult.setPageNum(p.getPageNum());
                paginateResult.setPageSize(p.getPageSize());
                paginateResult.setData(data);
                paginateResult.setTotalCount(count);
                return paginateResult;
            });
        }
        catch (InterruptedException e) {
            log.error("listUserId error", (Throwable)e);
        }
        return result;
    }

    public List<ListProjectsResponseBody.ListProjectsResponseBodyPagingInfoProjects> listProjectsByPage(Integer pageSize, Integer pageNumber) {
        ListProjectsRequest request = new ListProjectsRequest();
        request.setPageNumber(pageNumber);
        request.setPageSize(pageSize);
        try {
            Thread.sleep(this.delayInterval);
            Long l = this.apiCallCount;
            this.apiCallCount = this.apiCallCount + 1L;
            ListProjectsResponse response = this.client.listProjects(request);
            return response.getBody().getPagingInfo().getProjects();
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            System.out.println(error.getMessage());
            System.out.println(error.getData().get("Recommend"));
            Common.assertAsString((Object)error.message);
            return null;
        }
    }

    public List<ListDataSourcesResponseBody.ListDataSourcesResponseBodyPagingInfoDataSources> listDatasource(String projectId) {
        PageUtil.Paginator paginator = new PageUtil.Paginator();
        paginator.setPageSize(100);
        paginator.setPageNum(1);
        ArrayList<ListDataSourcesResponseBody.ListDataSourcesResponseBodyPagingInfoDataSources> result = new ArrayList<ListDataSourcesResponseBody.ListDataSourcesResponseBodyPagingInfoDataSources>();
        try {
            PageUtil.doPaginate(paginator, p -> {
                ListDataSourcesRequest request = new ListDataSourcesRequest();
                request.setProjectId(Long.valueOf(Long.parseLong(projectId)));
                request.setPageNumber(Integer.valueOf(p.getPageNum()));
                request.setPageSize(Integer.valueOf(p.getPageSize()));
                ArrayList data = new ArrayList();
                try {
                    Thread.sleep(this.delayInterval);
                    Long l = this.apiCallCount;
                    this.apiCallCount = this.apiCallCount + 1L;
                    ListDataSourcesResponse response = this.client.listDataSources(request);
                    data.addAll(response.getBody().getPagingInfo().getDataSources());
                }
                catch (Exception _error) {
                    TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
                    System.out.println(error.getMessage());
                    System.out.println(error.getData().get("Recommend"));
                    Common.assertAsString((Object)error.message);
                }
                result.addAll(data);
                Integer count = data.size();
                PageUtil.PaginateResult paginateResult = new PageUtil.PaginateResult();
                paginateResult.setPageNum(p.getPageNum());
                paginateResult.setPageSize(p.getPageSize());
                paginateResult.setData(data);
                paginateResult.setTotalCount(count);
                return paginateResult;
            });
        }
        catch (InterruptedException e) {
            log.error("listUserId error", (Throwable)e);
        }
        return result;
    }

    public List<ListDataSourcesResponseBody.ListDataSourcesResponseBodyPagingInfoDataSources> listDatasourceByTypeAndPage(String projectId, String engineType, Integer pageSize, Integer pageNumber) {
        ListDataSourcesRequest request = new ListDataSourcesRequest();
        request.setProjectId(Long.valueOf(Long.parseLong(projectId)));
        request.setTypes(Arrays.asList(engineType));
        request.setPageNumber(pageNumber);
        request.setPageSize(pageSize);
        try {
            Thread.sleep(this.delayInterval);
            Long l = this.apiCallCount;
            this.apiCallCount = this.apiCallCount + 1L;
            ListDataSourcesResponse response = this.client.listDataSources(request);
            return response.getBody().getPagingInfo().getDataSources();
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            System.out.println(error.getMessage());
            System.out.println(error.getData().get("Recommend"));
            Common.assertAsString((Object)error.message);
            return null;
        }
    }

    public GetProjectResponseBody.GetProjectResponseBodyProject getProject(String projectId) {
        GetProjectRequest request = new GetProjectRequest();
        request.setId(Long.valueOf(Long.parseLong(projectId)));
        try {
            Thread.sleep(this.delayInterval);
            Long l = this.apiCallCount;
            this.apiCallCount = this.apiCallCount + 1L;
            GetProjectResponse response = this.client.getProject(request);
            return response.getBody().getProject();
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            System.out.println(error.getMessage());
            System.out.println(error.getData().get("Recommend"));
            Common.assertAsString((Object)error.message);
            return null;
        }
    }

    public List<String> listProjectMemberId(String projectId) {
        PageUtil.Paginator paginator = new PageUtil.Paginator();
        paginator.setPageSize(100);
        paginator.setPageNum(1);
        ArrayList<String> result = new ArrayList<String>();
        try {
            PageUtil.doPaginate(paginator, p -> {
                ListProjectMembersRequest request = new ListProjectMembersRequest();
                request.setProjectId(Long.valueOf(Long.parseLong(projectId)));
                request.setPageNumber(Integer.valueOf(p.getPageNum()));
                request.setPageSize(Integer.valueOf(p.getPageSize()));
                ArrayList data = new ArrayList();
                try {
                    Thread.sleep(this.delayInterval);
                    Long l = this.apiCallCount;
                    this.apiCallCount = this.apiCallCount + 1L;
                    ListProjectMembersResponse response = this.client.listProjectMembers(request);
                    response.getBody().getPagingInfo().getProjectMembers().forEach(projectMember -> data.add(projectMember.getUserId()));
                }
                catch (Exception _error) {
                    TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
                    System.out.println(error.getMessage());
                    System.out.println(error.getData().get("Recommend"));
                    Common.assertAsString((Object)error.message);
                }
                result.addAll(data);
                Integer count = data.size();
                PageUtil.PaginateResult paginateResult = new PageUtil.PaginateResult();
                paginateResult.setPageNum(p.getPageNum());
                paginateResult.setPageSize(p.getPageSize());
                paginateResult.setData(data);
                paginateResult.setTotalCount(count);
                return paginateResult;
            });
        }
        catch (InterruptedException e) {
            log.error("listUserId error", (Throwable)e);
        }
        return result;
    }

    public Map<String, String> listResourcePathId(String projectId) {
        PageUtil.Paginator paginator = new PageUtil.Paginator();
        paginator.setPageSize(100);
        paginator.setPageNum(1);
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            PageUtil.doPaginate(paginator, p -> {
                ListResourcesRequest request = new ListResourcesRequest();
                request.setProjectId(Long.valueOf(Long.parseLong(projectId)));
                request.setPageNumber(Integer.valueOf(p.getPageNum()));
                request.setPageSize(Integer.valueOf(p.getPageSize()));
                HashMap data = new HashMap();
                ArrayList dataRecord = new ArrayList();
                try {
                    Thread.sleep(this.delayInterval);
                    Long l = this.apiCallCount;
                    this.apiCallCount = this.apiCallCount + 1L;
                    ListResourcesResponse response = this.client.listResources(request);
                    response.getBody().getPagingInfo().getResources().forEach(resources -> {
                        data.put(resources.getScript().getPath(), resources.getId().toString());
                        dataRecord.add(new Pair((Object)resources.getScript().getPath(), (Object)resources.getId().toString()));
                    });
                }
                catch (Exception _error) {
                    TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
                    System.out.println(error.getMessage());
                    System.out.println(error.getData().get("Recommend"));
                    Common.assertAsString((Object)error.message);
                }
                result.putAll(data);
                Integer count = data.size();
                PageUtil.PaginateResult paginateResult = new PageUtil.PaginateResult();
                paginateResult.setPageNum(p.getPageNum());
                paginateResult.setPageSize(p.getPageSize());
                paginateResult.setData(dataRecord);
                paginateResult.setTotalCount(count);
                return paginateResult;
            });
        }
        catch (InterruptedException e) {
            log.error("listUserId error", (Throwable)e);
        }
        return result;
    }

    public void getResourceDetail(String projectId, String resourceId) {
        GetResourceRequest request = new GetResourceRequest();
        request.setProjectId(Long.valueOf(Long.parseLong(projectId)));
        request.setId(Long.valueOf(Long.parseLong(resourceId)));
        try {
            Thread.sleep(this.delayInterval);
            Long l = this.apiCallCount;
            this.apiCallCount = this.apiCallCount + 1L;
            GetResourceResponse response = this.client.getResource(request);
            log.info("!");
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void createResource(String projectId, String resourceId) {
    }

    public JSONArray listResourceGroupId(String projectId) {
        ListResourceGroupsRequest request = new ListResourceGroupsRequest();
        request.setProjectId(projectId != null && StringUtils.isNumeric((CharSequence)projectId) ? Long.valueOf(Long.parseLong(projectId)) : null);
        request.setPageSize(Integer.valueOf(100));
        try {
            Thread.sleep(this.delayInterval);
            Long l = this.apiCallCount;
            this.apiCallCount = this.apiCallCount + 1L;
            ListResourceGroupsResponse response = this.client.listResourceGroups(request);
            if (response != null && response.getBody() != null && response.getBody().getPagingInfo() != null && response.getBody().getPagingInfo().getResourceGroupList() != null) {
                JSONArray resourceGroupList = JSONArray.from((Object)response.getBody().getPagingInfo().getResourceGroupList());
                return resourceGroupList;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new JSONArray();
    }

    public PipeLineStatus onlineWorkflow(String projectId, String workflowId) {
        try {
            String pipelineId = this.createOnlinePipelineRun(projectId, Arrays.asList(workflowId));
            Integer onlineStep = 1;
            block2: while (true) {
                Thread.sleep(this.queryJobStatusInterval);
                GetPipelineRunResponseBody.GetPipelineRunResponseBodyPipeline pipelineStatus = this.getPipelineRun(projectId, pipelineId);
                if (pipelineStatus.getStatus().equals(PipeLineStatus.Running.name())) {
                    GetPipelineRunResponseBody.GetPipelineRunResponseBodyPipelineStages stage2;
                    Boolean thisStageFinish = false;
                    for (GetPipelineRunResponseBody.GetPipelineRunResponseBodyPipelineStages stage2 : pipelineStatus.getStages()) {
                        if (!stage2.getStep().equals(onlineStep) || !stage2.getStatus().equals(PipeLineStatus.Success.name())) continue;
                        thisStageFinish = true;
                        log.info("pipeline: " + pipelineId + " - stage: " + stage2.getCode() + " finish");
                        break;
                    }
                    if (!thisStageFinish.booleanValue()) continue;
                    Iterator iterator = onlineStep;
                    onlineStep = onlineStep + 1;
                    iterator = pipelineStatus.getStages().iterator();
                    do {
                        if (!iterator.hasNext()) continue block2;
                    } while (!(stage2 = (GetPipelineRunResponseBody.GetPipelineRunResponseBodyPipelineStages)iterator.next()).getStep().equals(onlineStep) || !stage2.getStatus().equals(PipeLineStatus.Init.name()));
                    this.execPipelineRunStage(projectId, pipelineId, stage2.getCode());
                    continue;
                }
                if (pipelineStatus.getStatus().equals(PipeLineStatus.Success.name())) {
                    log.info("pipeline: " + pipelineId + " - finish");
                    return PipeLineStatus.Success;
                }
                if (pipelineStatus.getStatus().equals(PipeLineStatus.Fail.name())) {
                    log.info("pipeline: " + pipelineId + " - fail\uff1a " + pipelineStatus.getMessage());
                    return PipeLineStatus.Fail;
                }
                if (pipelineStatus.getStatus().equals(PipeLineStatus.Termination.name())) {
                    log.info("pipeline: " + pipelineId + " - termination");
                    return PipeLineStatus.Termination;
                }
                if (pipelineStatus.getStatus().equals(PipeLineStatus.Cancel.name())) break;
            }
            log.info("pipeline: " + pipelineId + " - cancel");
            return PipeLineStatus.Cancel;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String createOnlinePipelineRun(String projectId, List<String> objectIds) {
        CreatePipelineRunRequest request = new CreatePipelineRunRequest();
        request.setProjectId(Long.valueOf(Long.parseLong(projectId)));
        request.setObjectIds(objectIds);
        request.setType("Online");
        try {
            Thread.sleep(this.delayInterval);
            Long l = this.apiCallCount;
            this.apiCallCount = this.apiCallCount + 1L;
            CreatePipelineRunResponse response = this.client.createPipelineRun(request);
            return response.getBody().getId();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public GetPipelineRunResponseBody.GetPipelineRunResponseBodyPipeline getPipelineRun(String projectId, String pipelineId) {
        GetPipelineRunRequest request = new GetPipelineRunRequest();
        request.setProjectId(Long.valueOf(Long.parseLong(projectId)));
        request.setId(pipelineId);
        try {
            Thread.sleep(this.delayInterval);
            Long l = this.apiCallCount;
            this.apiCallCount = this.apiCallCount + 1L;
            GetPipelineRunResponse response = this.client.getPipelineRun(request);
            return response.getBody().getPipeline();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Boolean execPipelineRunStage(String projectId, String id, String code) {
        ExecPipelineRunStageRequest request = new ExecPipelineRunStageRequest();
        request.setProjectId(Long.valueOf(Long.parseLong(projectId)));
        request.setId(id);
        request.setCode(code);
        try {
            Thread.sleep(this.delayInterval);
            Long l = this.apiCallCount;
            this.apiCallCount = this.apiCallCount + 1L;
            ExecPipelineRunStageResponse response = this.client.execPipelineRunStage(request);
            return response.getBody().getSuccess();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<ListPipelineRunsResponseBody.ListPipelineRunsResponseBodyPagingInfoPipelineRuns> listPipelineRuns(String projectId) {
        PageUtil.Paginator paginator = new PageUtil.Paginator();
        paginator.setPageSize(100);
        paginator.setPageNum(1);
        ArrayList<ListPipelineRunsResponseBody.ListPipelineRunsResponseBodyPagingInfoPipelineRuns> result = new ArrayList<ListPipelineRunsResponseBody.ListPipelineRunsResponseBodyPagingInfoPipelineRuns>();
        try {
            PageUtil.doPaginate(paginator, p -> {
                try {
                    ListPipelineRunsRequest request = new ListPipelineRunsRequest();
                    request.setProjectId(Long.valueOf(Long.parseLong(projectId)));
                    request.setPageNumber(Integer.valueOf(p.getPageNum()));
                    request.setPageSize(Integer.valueOf(p.getPageSize()));
                    Thread.sleep(this.delayInterval);
                    Long l = this.apiCallCount;
                    this.apiCallCount = this.apiCallCount + 1L;
                    ListPipelineRunsResponse response = this.client.listPipelineRuns(request);
                    result.addAll(response.getBody().getPagingInfo().getPipelineRuns());
                    Integer count = response.getBody().getPagingInfo().getPipelineRuns().size();
                    PageUtil.PaginateResult paginateResult = new PageUtil.PaginateResult();
                    paginateResult.setPageNum(p.getPageNum());
                    paginateResult.setPageSize(p.getPageSize());
                    paginateResult.setData(response.getBody().getPagingInfo().getPipelineRuns());
                    paginateResult.setTotalCount(count);
                    return paginateResult;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (InterruptedException e) {
            log.error("listPipelineRuns error", (Throwable)e);
        }
        return result;
    }

    public List<ListPipelineRunItemsResponseBody.ListPipelineRunItemsResponseBodyPagingInfoPipelineRunItems> listPipelineRunItems(String projectId, String pipelineRunId) {
        PageUtil.Paginator paginator = new PageUtil.Paginator();
        paginator.setPageSize(100);
        paginator.setPageNum(1);
        ArrayList<ListPipelineRunItemsResponseBody.ListPipelineRunItemsResponseBodyPagingInfoPipelineRunItems> result = new ArrayList<ListPipelineRunItemsResponseBody.ListPipelineRunItemsResponseBodyPagingInfoPipelineRunItems>();
        try {
            PageUtil.doPaginate(paginator, p -> {
                try {
                    ListPipelineRunItemsRequest request = new ListPipelineRunItemsRequest();
                    request.setProjectId(Long.valueOf(Long.parseLong(projectId)));
                    request.setPipelineRunId(pipelineRunId);
                    request.setPageNumber(Integer.valueOf(p.getPageNum()));
                    request.setPageSize(Integer.valueOf(p.getPageSize()));
                    Thread.sleep(this.delayInterval);
                    Long l = this.apiCallCount;
                    this.apiCallCount = this.apiCallCount + 1L;
                    ListPipelineRunItemsResponse response = this.client.listPipelineRunItems(request);
                    result.addAll(response.getBody().getPagingInfo().getPipelineRunItems());
                    Integer count = response.getBody().getPagingInfo().getPipelineRunItems().size();
                    PageUtil.PaginateResult paginateResult = new PageUtil.PaginateResult();
                    paginateResult.setPageNum(p.getPageNum());
                    paginateResult.setPageSize(p.getPageSize());
                    paginateResult.setData(response.getBody().getPagingInfo().getPipelineRunItems());
                    paginateResult.setTotalCount(count);
                    return paginateResult;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (InterruptedException e) {
            log.error("listPipelineRuns error", (Throwable)e);
        }
        return result;
    }

    public Map<Long, PipelineState> listPipelineState(String projectId) {
        HashMap<Long, PipelineState> result = new HashMap<Long, PipelineState>();
        List<ListPipelineRunsResponseBody.ListPipelineRunsResponseBodyPagingInfoPipelineRuns> pipelineRuns = this.listPipelineRuns(projectId);
        log.info("\u5de5\u4f5c\u7a7a\u95f4\u5185\u7684\u53d1\u5e03\u8bb0\u5f55\u6570\u91cf\uff1a" + pipelineRuns.size());
        log.info("\u6b63\u5728\u4e3aWorkflow\u5339\u914d\u53d1\u5e03\u6d41\u7a0b\u72b6\u6001...");
        Integer count = 0;
        for (ListPipelineRunsResponseBody.ListPipelineRunsResponseBodyPagingInfoPipelineRuns pipelineRun : pipelineRuns) {
            Integer n = count;
            count = count + 1;
            log.info("\u83b7\u53d6\u7b2c({}/{})\u4e2a\u53d1\u5e03\u8bb0\u5f55\u8be6\u60c5\uff1a{}", new Object[]{count, pipelineRuns.size(), pipelineRun.getId()});
            try {
                this.listPipelineRunItems(projectId, pipelineRun.getId()).forEach(pipelineRunItem -> {
                    if (!result.containsKey(pipelineRunItem.getId())) {
                        PipelineState pipelineState = new PipelineState();
                        pipelineState.setObjectId(pipelineRunItem.getId());
                        try {
                            pipelineState.setObjectType(ObjectType.valueOf(pipelineRunItem.getType()));
                        }
                        catch (Exception e) {
                            log.warn("\u5728DataWorks\u53d1\u5e03\u8bb0\u5f55\u4e2d\u83b7\u53d6\u5230\u4e86\u672a\u77e5\u7684\u53d1\u5e03\u7269\u79cd\u7c7b\uff1a" + pipelineRunItem.getType());
                        }
                        pipelineState.setLatestPipelineRunId(pipelineRun.getId());
                        pipelineState.setLatestPipelineRunStatus(PipeLineStatus.valueOf(pipelineRunItem.getStatus()));
                        pipelineState.setLatestPipelineRunCreateTime(pipelineRunItem.getCreateTime());
                        pipelineState.setLatestPipelineRunVersion(pipelineRunItem.getVersion());
                        if (ObjectUtils.equals((Object)pipelineRunItem.getStatus(), (Object)PipeLineStatus.Success.name())) {
                            pipelineState.setSuccessPipelineRunId(pipelineRun.getId());
                            pipelineState.setSuccessPipelineRunCreateTime(pipelineRunItem.getCreateTime());
                            pipelineState.setSuccessPipelineRunVersion(pipelineRunItem.getVersion());
                        }
                        result.put(pipelineRunItem.getId(), pipelineState);
                    } else {
                        PipelineState pipelineState = (PipelineState)result.get(pipelineRunItem.getId());
                        if (pipelineRunItem.getCreateTime() > pipelineState.getLatestPipelineRunCreateTime()) {
                            pipelineState.setLatestPipelineRunId(pipelineRun.getId());
                            pipelineState.setLatestPipelineRunStatus(PipeLineStatus.valueOf(pipelineRunItem.getStatus()));
                            pipelineState.setLatestPipelineRunCreateTime(pipelineRunItem.getCreateTime());
                            pipelineState.setLatestPipelineRunVersion(pipelineRunItem.getVersion());
                        }
                        if (ObjectUtils.equals((Object)pipelineRunItem.getStatus(), (Object)PipeLineStatus.Success.name()) && (pipelineState.getSuccessPipelineRunCreateTime() == null || pipelineRunItem.getCreateTime() > pipelineState.getSuccessPipelineRunCreateTime())) {
                            pipelineState.setSuccessPipelineRunId(pipelineRun.getId());
                            pipelineState.setSuccessPipelineRunCreateTime(pipelineRunItem.getCreateTime());
                            pipelineState.setSuccessPipelineRunVersion(pipelineRunItem.getVersion());
                        }
                    }
                });
            }
            catch (Exception e) {}
        }
        log.info("\u5de5\u4f5c\u7a7a\u95f4\u5185\u7684\u53d1\u5e03\u8bb0\u5f55\u5339\u914d\u5b8c\u6210");
        return result;
    }

    public Long getApiCallCount() {
        return this.apiCallCount;
    }

    public static enum PipeLineStatus {
        Init,
        Running,
        Success,
        Fail,
        Termination,
        Cancel;

    }

    public class PipelineState {
        private Long objectId;
        private ObjectType objectType;
        private String latestPipelineRunId;
        private PipeLineStatus latestPipelineRunStatus;
        private Long latestPipelineRunCreateTime;
        private Long latestPipelineRunVersion;
        private String successPipelineRunId;
        private Long successPipelineRunCreateTime;
        private Long successPipelineRunVersion;

        public Long getObjectId() {
            return this.objectId;
        }

        public ObjectType getObjectType() {
            return this.objectType;
        }

        public String getLatestPipelineRunId() {
            return this.latestPipelineRunId;
        }

        public PipeLineStatus getLatestPipelineRunStatus() {
            return this.latestPipelineRunStatus;
        }

        public Long getLatestPipelineRunCreateTime() {
            return this.latestPipelineRunCreateTime;
        }

        public Long getLatestPipelineRunVersion() {
            return this.latestPipelineRunVersion;
        }

        public String getSuccessPipelineRunId() {
            return this.successPipelineRunId;
        }

        public Long getSuccessPipelineRunCreateTime() {
            return this.successPipelineRunCreateTime;
        }

        public Long getSuccessPipelineRunVersion() {
            return this.successPipelineRunVersion;
        }

        public void setObjectId(Long objectId) {
            this.objectId = objectId;
        }

        public void setObjectType(ObjectType objectType) {
            this.objectType = objectType;
        }

        public void setLatestPipelineRunId(String latestPipelineRunId) {
            this.latestPipelineRunId = latestPipelineRunId;
        }

        public void setLatestPipelineRunStatus(PipeLineStatus latestPipelineRunStatus) {
            this.latestPipelineRunStatus = latestPipelineRunStatus;
        }

        public void setLatestPipelineRunCreateTime(Long latestPipelineRunCreateTime) {
            this.latestPipelineRunCreateTime = latestPipelineRunCreateTime;
        }

        public void setLatestPipelineRunVersion(Long latestPipelineRunVersion) {
            this.latestPipelineRunVersion = latestPipelineRunVersion;
        }

        public void setSuccessPipelineRunId(String successPipelineRunId) {
            this.successPipelineRunId = successPipelineRunId;
        }

        public void setSuccessPipelineRunCreateTime(Long successPipelineRunCreateTime) {
            this.successPipelineRunCreateTime = successPipelineRunCreateTime;
        }

        public void setSuccessPipelineRunVersion(Long successPipelineRunVersion) {
            this.successPipelineRunVersion = successPipelineRunVersion;
        }
    }

    public static enum ObjectType {
        Node,
        Flow,
        WorkflowDefinition,
        Resource,
        FileResource,
        Function;

    }
}

