/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.utils;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);
    public static final String DEFAULT_DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";

    public static String format(Date date) {
        return DateUtil.format(date, DEFAULT_DATE_TIME_PATTERN);
    }

    public static String format(Date date, String pattern) {
        if (Objects.isNull(date) || Objects.isNull(pattern)) {
            return null;
        }
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
            LocalDateTime localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            return localDateTime.format(formatter);
        }
        catch (Exception e) {
            log.error("\u65e5\u671f\u683c\u5f0f\u5316\u5931\u8d25\uff0cdate={}, pattern={}", new Object[]{date, pattern, e});
            return null;
        }
    }

    public static String format(LocalDateTime localDateTime) {
        return DateUtil.format(localDateTime, DEFAULT_DATE_TIME_PATTERN);
    }

    public static String format(LocalDateTime localDateTime, String pattern) {
        if (Objects.isNull(localDateTime) || Objects.isNull(pattern)) {
            return null;
        }
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
            return localDateTime.format(formatter);
        }
        catch (Exception e) {
            log.error("\u65e5\u671f\u683c\u5f0f\u5316\u5931\u8d25\uff0clocalDateTime={}, pattern={}", new Object[]{localDateTime, pattern, e});
            return null;
        }
    }

    public static String now() {
        return DateUtil.format(LocalDateTime.now());
    }

    public static String now(String pattern) {
        return DateUtil.format(LocalDateTime.now(), pattern);
    }
}

