/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.utils;

import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.constant.report.StatisticsReportConstant;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BwmPackageCheckingUtil {
    private static final Logger log = LoggerFactory.getLogger(BwmPackageCheckingUtil.class);
    private WorkflowProjectPackage workflowProjectPackage;
    private List<String> allWorkflowsId;
    private Map<String, WorkflowNode> allNodes;
    private List<String> allNodesName;
    private List<String> allNodesId;
    private List<RelationError> relationErrorList = new ArrayList<RelationError>();

    public BwmPackageCheckingUtil(WorkflowProjectPackage workflowProjectPackage) {
        this.init(workflowProjectPackage);
    }

    public void init(WorkflowProjectPackage workflowProjectPackage) {
        this.workflowProjectPackage = workflowProjectPackage;
        this.getAllNodes();
    }

    private void getAllNodes() {
        this.allWorkflowsId = new ArrayList<String>();
        this.allNodes = new HashMap<String, WorkflowNode>();
        this.allNodesName = new ArrayList<String>();
        this.allNodesId = new ArrayList<String>();
        for (Workflow workflow : this.workflowProjectPackage.getWorkflowList()) {
            this.allWorkflowsId.add(workflow.getWorkflowId());
            for (WorkflowNode node : workflow.getWorkflowNodes()) {
                if (this.allNodes.containsKey(node.getNodeId())) {
                    log.warn("\u8282\u70b9id\u91cd\u590d:{}" + node.getNodeId());
                }
                this.allNodes.put(node.getNodeId(), node);
                this.allNodesName.add(node.getNodeName());
                this.allNodesId.add(node.getNodeId());
            }
        }
    }

    public void oneClickChecking() {
        for (Workflow workflow : this.workflowProjectPackage.getWorkflowList()) {
            workflow.setNodeRelations(this.deleteNullRelation(workflow.getNodeRelations()));
        }
        this.relationChecking();
        for (Workflow workflow : this.workflowProjectPackage.getWorkflowList()) {
            for (WorkflowNode node : workflow.getWorkflowNodes()) {
                this.scriptParamChecking(node);
            }
        }
    }

    public void logCheckingReport() {
        log.info("==========Package\u4f53\u68c0===========");
        for (RelationError relationError : this.relationErrorList) {
            log.error(relationError.getErrorMsg());
        }
        log.info("==========Package\u4f53\u68c0\u7ed3\u675f===========");
    }

    public void exportCheckingReport() {
    }

    public void relationChecking() {
        for (Workflow workflow : this.workflowProjectPackage.getWorkflowList()) {
            for (RelationPackage relation : workflow.getNodeRelations()) {
                String from = relation.getFrom();
                String to = relation.getTo();
                if (!relation.getReType().equals((Object)RelationPackage.ReType.NODE) || this.allNodesId.contains(from) && this.allNodesId.contains(to)) continue;
                this.relationErrorList.add(new RelationError(from, to, this.allNodes.get(from), this.allNodes.get(to), workflow.getWorkflowId(), workflow.getWorkflowName(), relation.getReType()));
            }
        }
    }

    public List<RelationPackage> deleteNullRelation(List<RelationPackage> relationList) {
        ArrayList<RelationPackage> result = new ArrayList<RelationPackage>();
        if (relationList == null) {
            return result;
        }
        for (RelationPackage relation : relationList) {
            String from = relation.getFrom();
            String to = relation.getTo();
            if (from != null && to != null) {
                result.add(relation);
                continue;
            }
            log.warn("\u5220\u9664\u542b\u7a7a\u8840\u7f18: " + from + "->" + to);
        }
        return result;
    }

    public void scriptParamChecking(WorkflowNode node) {
        if (node == null || StringUtils.isEmpty((CharSequence)node.getScript())) {
            return;
        }
        HashMap<String, String> paramMap = node.getParamMap();
        if (paramMap == null) {
            paramMap = new HashMap<String, String>();
        }
        Map<String, Map<String, String>> allParams = BwmPackageCheckingUtil.findAllParams(node.getScript());
        ArrayList<String> rawParams = new ArrayList<String>();
        for (String regex : allParams.keySet()) {
            for (String param : allParams.get(regex).keySet()) {
                String rawParam = allParams.get(regex).get(param);
                if (!paramMap.containsKey(param)) {
                    paramMap.put(param, "");
                }
                rawParams.add(rawParam);
            }
        }
        node.setParamMap(paramMap);
        if (node.getCustomProperties() == null) {
            node.setCustomProperties(new HashMap());
        }
        node.getCustomProperties().put(StatisticsReportConstant.RAW_SCRIPT_PARAMS, rawParams);
    }

    public static Map<String, Map<String, String>> findAllParams(String input) {
        HashMap<String, Map<String, String>> paramMap = new HashMap<String, Map<String, String>>();
        List<String> regexs = List.of("\\$\\{", "\\$\\[", "\\$\\(");
        for (String regex : regexs) {
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(input);
            while (matcher.find()) {
                String rawParam = BwmPackageCheckingUtil.getRawParam(input.substring(matcher.start()));
                if (StringUtils.isEmpty((CharSequence)rawParam)) continue;
                if (!paramMap.containsKey(regex)) {
                    paramMap.put(regex, new HashMap());
                }
                ((Map)paramMap.get(regex)).put(rawParam.substring(2, rawParam.length() - 1), rawParam);
            }
        }
        return paramMap;
    }

    public static String getRawParam(String input) {
        if (!(input.startsWith("${") || input.startsWith("$[") || input.startsWith("$("))) {
            return null;
        }
        Stack<Character> stack = new Stack<Character>();
        Integer index = 1;
        while (index < input.length()) {
            char c = input.charAt(index);
            if (c == '{' || c == '[' || c == '(') {
                stack.push(Character.valueOf(c));
            } else if (c == '}' || c == ']' || c == ')') {
                if (stack.isEmpty()) {
                    return null;
                }
                char top = ((Character)stack.pop()).charValue();
                if (c == '}' && top != '{' || c == ']' && top != '[' || c == ')' && top != '(') {
                    return null;
                }
                if (stack.isEmpty()) {
                    return input.substring(0, index + 1);
                }
            }
            Integer n = index;
            index = index + 1;
        }
        return null;
    }

    public WorkflowProjectPackage getWorkflowProjectPackage() {
        return this.workflowProjectPackage;
    }

    public List<String> getAllWorkflowsId() {
        return this.allWorkflowsId;
    }

    public List<String> getAllNodesName() {
        return this.allNodesName;
    }

    public List<String> getAllNodesId() {
        return this.allNodesId;
    }

    public List<RelationError> getRelationErrorList() {
        return this.relationErrorList;
    }

    public class RelationError {
        private String workflowId;
        private String workflowName;
        private String fromId;
        private String fromName;
        private Boolean isfromMissing;
        private String toId;
        private String toName;
        private Boolean isToMissing;
        private RelationPackage.ReType reType;
        private String errorMsg;

        public RelationError(String fromId, String toId, WorkflowNode from, WorkflowNode to, String workflowId, String workflowName, RelationPackage.ReType reType) {
            this.workflowId = workflowId;
            this.workflowName = workflowName;
            this.fromId = fromId;
            this.toId = toId;
            this.reType = reType;
            if (reType.equals((Object)RelationPackage.ReType.NODE)) {
                if (from == null) {
                    this.isfromMissing = true;
                } else {
                    this.isfromMissing = false;
                    this.fromName = from.getNodeName();
                }
                if (to == null) {
                    this.isToMissing = true;
                } else {
                    this.isToMissing = false;
                    this.toName = to.getNodeName();
                }
                this.buildErrorMsg();
            } else if (reType.equals((Object)RelationPackage.ReType.WORKFLOW)) {
                this.errorMsg = fromId.equals(workflowId) ? "\u5de5\u4f5c\u6d41<" + workflowName + workflowId + ">\u7684\u4e0b\u6e38\u5de5\u4f5c\u6d41" + toId + " not found in package" : "\u5de5\u4f5c\u6d41<" + workflowName + workflowId + ">\u7684\u4e0a\u6e38\u5de5\u4f5c\u6d41" + fromId + " not found in package";
            }
        }

        private void buildErrorMsg() {
            if (this.isfromMissing.booleanValue() && this.isToMissing.booleanValue()) {
                this.errorMsg = "\u5de5\u4f5c\u6d41<" + this.workflowName + this.workflowId + ">\u8bb0\u5f55\u7684\u8840\u7f18\u9519\u8bef: \u8282\u70b9<" + this.fromId + ">\u548c\u8282\u70b9<" + this.toId + "> not found in package";
            } else if (this.isfromMissing.booleanValue()) {
                this.errorMsg = "\u5de5\u4f5c\u6d41<" + this.workflowName + this.workflowId + ">\u8bb0\u5f55\u7684\u8840\u7f18\u9519\u8bef: \u8282\u70b9<" + this.toName + this.toId + ">\u7684\u4e0a\u6e38\u8282\u70b9<" + this.fromId + "> not found in package";
            } else if (this.isToMissing.booleanValue()) {
                this.errorMsg = "\u5de5\u4f5c\u6d41<" + this.workflowName + this.workflowId + ">\u8bb0\u5f55\u7684\u8840\u7f18\u9519\u8bef: \u8282\u70b9<" + this.fromName + this.fromId + ">\u7684\u4e0b\u6e38\u8282\u70b9<" + this.toId + "> not found in package";
            }
        }

        public String getWorkflowId() {
            return this.workflowId;
        }

        public String getWorkflowName() {
            return this.workflowName;
        }

        public String getFromId() {
            return this.fromId;
        }

        public String getFromName() {
            return this.fromName;
        }

        public Boolean getIsfromMissing() {
            return this.isfromMissing;
        }

        public String getToId() {
            return this.toId;
        }

        public String getToName() {
            return this.toName;
        }

        public Boolean getIsToMissing() {
            return this.isToMissing;
        }

        public RelationPackage.ReType getReType() {
            return this.reType;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }
    }
}

