/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.utils;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.TypeReference;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.workflow.migration.common.bean.HttpClientRes;
import com.aliyun.migration.workflow.migration.common.bean.HttpGetWithEntity;
import com.aliyun.migration.workflow.migration.common.bean.HttpMethodEnum;
import com.aliyun.migration.workflow.migration.common.bean.LogLevel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public final class BwmHttpClientUtil {
    private static final Logger logger = LoggerFactory.getLogger(BwmHttpClientUtil.class);
    private static final Integer MAX_TIME_OUT = 5000;
    private static final Integer MAX_SO_TIME_OUT = 30000;
    private static final Integer MAX_REQUEST_TIME_OUT = 5000;
    private static final Integer MAX_CONN = 200;
    private static final Integer MAX_CONN_PER_HOST = 10;
    private static final Integer MAX_IDLE_TIME_OUT = 0;
    private static PoolingHttpClientConnectionManager poolConnManager = new PoolingHttpClientConnectionManager();
    private static RequestConfig requestConfig;
    private static CloseableHttpClient httpClient;
    private static Map<String, String> defaultJsonHeader;

    public static String supplyHttpProtol(String url) {
        if (!((String)url).startsWith("http://") && !((String)url).startsWith("https://")) {
            url = "http://" + (String)url;
        }
        return url;
    }

    public static String uploadFile(String url, Map<String, String> headers, File srcFile) {
        String tgtFilePath = "";
        FileBody fileBody = new FileBody(srcFile, ContentType.MULTIPART_FORM_DATA, srcFile.getName());
        HttpPost httpPost = new HttpPost(url);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setCharset(Charset.forName("utf-8"));
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.setContentType(ContentType.MULTIPART_FORM_DATA);
        builder.addPart("file", (ContentBody)fileBody);
        HttpEntity httpEntity = builder.build();
        httpPost.setEntity(httpEntity);
        try {
            CloseableHttpResponse execute = httpClient.execute((HttpUriRequest)httpPost);
            tgtFilePath = BwmHttpClientUtil.parseResponse(execute);
        }
        catch (Exception e) {
            logger.error("upload file error", (Throwable)e);
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.META_FILE_UPLOAD_FAILED);
        }
        finally {
            poolConnManager.closeExpiredConnections();
            poolConnManager.closeIdleConnections((long)MAX_IDLE_TIME_OUT.intValue(), TimeUnit.SECONDS);
        }
        return tgtFilePath;
    }

    public static void downloadFile(String url, Map<String, String> headers, File tgtFile) {
        HttpGetWithEntity httpGet = new HttpGetWithEntity(url);
        BwmHttpClientUtil.addHeader((HttpUriRequest)httpGet, headers);
        try (CloseableHttpResponse execute = httpClient.execute((HttpUriRequest)httpGet);){
            int statusCode = execute.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                BwmHttpClientUtil.saveToFile(execute.getEntity(), tgtFile);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("HttpClientUtils.httpRequest HttpException caught, URL:" + url + ", msg:", e);
        }
        finally {
            poolConnManager.closeExpiredConnections();
            poolConnManager.closeIdleConnections((long)MAX_IDLE_TIME_OUT.intValue(), TimeUnit.SECONDS);
        }
    }

    private static void saveToFile(HttpEntity entity, File tgtFile) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(tgtFile);){
            if (entity != null) {
                entity.writeTo((OutputStream)fileOutputStream);
            }
            logger.info("File saved successfully.");
        }
        catch (IOException e) {
            logger.error("file saved error ", (Throwable)e);
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.META_FILE_SAVE_FAILED);
        }
    }

    private static CloseableHttpClient getConnection() {
        CloseableHttpClient httpClient = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).setConnectionManager((HttpClientConnectionManager)poolConnManager).setDefaultRequestConfig(requestConfig).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false)).build();
        if (poolConnManager != null && poolConnManager.getTotalStats() != null) {
            logger.warn("now client pool " + poolConnManager.getTotalStats().toString());
        }
        return httpClient;
    }

    public static HttpClientRes httpRequestWithJsonHeader(HttpMethodEnum methodType, String url, String body) {
        return BwmHttpClientUtil.httpRequest(methodType, url, body, defaultJsonHeader, LogLevel.debug);
    }

    public static HttpClientRes httpRequest(HttpMethodEnum methodType, String url, String body, Map<String, String> headerMap) {
        return BwmHttpClientUtil.httpRequest(methodType, url, body, headerMap, LogLevel.debug);
    }

    public static HttpClientRes httpRequest(HttpMethodEnum methodType, String url, String body, Map<String, String> headerMap, LogLevel logLevel) {
        HttpClientRes var11;
        try {
            CloseableHttpResponse response = null;
            if (methodType.equals((Object)HttpMethodEnum.HEAD)) {
                response = BwmHttpClientUtil.doHead(url, headerMap);
            } else if (methodType.equals((Object)HttpMethodEnum.DELETE)) {
                response = BwmHttpClientUtil.doDelete(url, headerMap);
            } else if (methodType.equals((Object)HttpMethodEnum.POST)) {
                response = BwmHttpClientUtil.doPost(url, body, headerMap);
            } else if (methodType.equals((Object)HttpMethodEnum.PUT)) {
                response = BwmHttpClientUtil.doPut(url, body, headerMap);
            } else if (methodType.equals((Object)HttpMethodEnum.GET)) {
                response = BwmHttpClientUtil.doGet(url, body, headerMap);
            } else {
                if (!methodType.equals((Object)HttpMethodEnum.PATCH)) {
                    logger.error("method not fit, methodType:" + methodType.name());
                    HttpClientRes httpClientRes = null;
                    return httpClientRes;
                }
                response = BwmHttpClientUtil.doPatch(url, body, headerMap);
            }
            ArrayList<String> reqLogs = new ArrayList<String>();
            reqLogs.add("====HttpClient RequestURL: " + url);
            reqLogs.add("====HttpClient RequestHeader: " + JSON.toJSONString(headerMap));
            reqLogs.add("====HttpClient RequestBody: " + body);
            BwmHttpClientUtil.httpLog(reqLogs, logLevel);
            int statusCode = response.getStatusLine().getStatusCode();
            ArrayList<Header> headerList = new ArrayList<Header>();
            headerList.addAll(Arrays.asList(response.getAllHeaders()));
            String responseBody = BwmHttpClientUtil.parseResponse(response);
            ArrayList<String> respLogs = new ArrayList<String>();
            respLogs.add("====HttpClient ResponseCode: " + statusCode);
            respLogs.add("====HttpClient ResponseBody: " + responseBody);
            BwmHttpClientUtil.httpLog(respLogs, logLevel);
            var11 = new HttpClientRes(statusCode, headerList, responseBody);
        }
        catch (Exception var15) {
            throw new RuntimeException("HttpClientUtils.httpRequest HttpException caught, URL:" + url + ", msg:", var15);
        }
        finally {
            poolConnManager.closeExpiredConnections();
            poolConnManager.closeIdleConnections((long)MAX_IDLE_TIME_OUT.intValue(), TimeUnit.SECONDS);
        }
        return var11;
    }

    private static void httpLog(List<String> contents, LogLevel logLevel) {
        if (!CollectionUtils.isEmpty(contents) && LogLevel.none != logLevel) {
            if (LogLevel.info == logLevel) {
                for (String content : contents) {
                    logger.info(content);
                }
            }
            if (LogLevel.debug == logLevel) {
                for (String content : contents) {
                    logger.debug(content);
                }
            }
            if (LogLevel.warn == logLevel) {
                for (String content : contents) {
                    logger.warn(content);
                }
            }
            if (LogLevel.error == logLevel) {
                for (String content : contents) {
                    logger.error(content);
                }
            }
        }
    }

    private static CloseableHttpResponse doPost(String url, String bodyJsonParams, Map<String, String> headers) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        if (StringUtils.isNotEmpty((CharSequence)bodyJsonParams)) {
            httpPost.setEntity((HttpEntity)new StringEntity(bodyJsonParams, StandardCharsets.UTF_8));
        }
        BwmHttpClientUtil.addHeader((HttpUriRequest)httpPost, headers);
        return httpClient.execute((HttpUriRequest)httpPost);
    }

    private static CloseableHttpResponse doPatch(String url, String bodyJsonParams, Map<String, String> headers) throws IOException {
        HttpPatch httpPatch = new HttpPatch(url);
        if (StringUtils.isNotEmpty((CharSequence)bodyJsonParams)) {
            httpPatch.setEntity((HttpEntity)new StringEntity(bodyJsonParams, StandardCharsets.UTF_8));
        }
        BwmHttpClientUtil.addHeader((HttpUriRequest)httpPatch, headers);
        return httpClient.execute((HttpUriRequest)httpPatch);
    }

    private static CloseableHttpResponse doPut(String url, String bodyJsonParams, Map<String, String> headers) throws IOException {
        HttpPut httpPut = new HttpPut(url);
        if (StringUtils.isNotEmpty((CharSequence)bodyJsonParams)) {
            httpPut.setEntity((HttpEntity)new StringEntity(bodyJsonParams, StandardCharsets.UTF_8));
        }
        BwmHttpClientUtil.addHeader((HttpUriRequest)httpPut, headers);
        return httpClient.execute((HttpUriRequest)httpPut);
    }

    private static CloseableHttpResponse doDelete(String url, Map<String, String> headers) throws IOException {
        HttpDelete httpDelete = new HttpDelete(url);
        BwmHttpClientUtil.addHeader((HttpUriRequest)httpDelete, headers);
        return httpClient.execute((HttpUriRequest)httpDelete);
    }

    private static CloseableHttpResponse doGet(String url, String bodyJsonParams, Map<String, String> headers) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)bodyJsonParams)) {
            Map paramMap = (Map)JSON.parseObject((String)bodyJsonParams, (TypeReference)new TypeReference<HashMap<String, Object>>(){}, (JSONReader.Feature[])new JSONReader.Feature[0]);
            ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
            if (!CollectionUtils.isEmpty((Map)paramMap)) {
                for (Map.Entry entry : paramMap.entrySet()) {
                    paramList.add(new BasicNameValuePair((String)entry.getKey(), String.valueOf(entry.getValue())));
                }
            }
            String fmtParamStr = null;
            if (!CollectionUtils.isEmpty(paramList)) {
                fmtParamStr = URLEncodedUtils.format(paramList, (Charset)Consts.UTF_8);
            }
            if (StringUtils.isNotBlank(fmtParamStr)) {
                url = url.contains("?") ? String.format("%s&%s", url, fmtParamStr) : String.format("%s?%s", url, fmtParamStr);
            }
        }
        HttpGetWithEntity httpGet = new HttpGetWithEntity(url);
        if (StringUtils.isNotEmpty((CharSequence)bodyJsonParams)) {
            httpGet.setEntity((HttpEntity)new StringEntity(bodyJsonParams, ContentType.APPLICATION_JSON));
        }
        BwmHttpClientUtil.addHeader((HttpUriRequest)httpGet, headers);
        return httpClient.execute((HttpUriRequest)httpGet);
    }

    private static CloseableHttpResponse doHead(String url, Map<String, String> headers) throws IOException {
        HttpHead httpHead = new HttpHead(url);
        BwmHttpClientUtil.addHeader((HttpUriRequest)httpHead, headers);
        return httpClient.execute((HttpUriRequest)httpHead);
    }

    private static String parseResponse(CloseableHttpResponse response) {
        String defaultCharset = "UTF-8";
        if (response.getEntity() != null && response.getEntity().getContentType() != null) {
            Header type = response.getEntity().getContentType();
            logger.debug("Type:" + type.getValue());
            String charset = BwmHttpClientUtil.getCharSet(type.getValue());
            if (!StringUtils.isEmpty((CharSequence)charset)) {
                defaultCharset = charset;
            }
        }
        try {
            return EntityUtils.toString((HttpEntity)response.getEntity(), (String)defaultCharset);
        }
        catch (Exception var4) {
            logger.error("\u89e3\u6790http\u8fd4\u56de\u503c\u51fa\u9519\u5566\u3002" + var4.toString());
            return null;
        }
    }

    private static String getCharSet(String content) {
        String regex = ".*charset=([^;]*).*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(content);
        return matcher.find() ? matcher.group(1) : null;
    }

    private static void addHeader(HttpUriRequest httpUriRequest, Map<String, String> headers) {
        if (httpUriRequest != null && headers != null && !headers.keySet().isEmpty()) {
            Set<String> keySet = headers.keySet();
            for (String key : keySet) {
                String value = headers.get(key);
                httpUriRequest.addHeader(key, value);
            }
        }
    }

    public static Map<String, String> buildHeaderMap() {
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("Content-Type", "application/json");
        headMap.put("Accept", "application/json");
        return headMap;
    }

    static {
        defaultJsonHeader = new HashMap<String, String>();
        poolConnManager.setMaxTotal(MAX_CONN.intValue());
        poolConnManager.setDefaultMaxPerRoute(MAX_CONN_PER_HOST.intValue());
        requestConfig = RequestConfig.custom().setConnectionRequestTimeout(MAX_REQUEST_TIME_OUT.intValue()).setSocketTimeout(MAX_SO_TIME_OUT.intValue()).setConnectTimeout(MAX_TIME_OUT.intValue()).build();
        httpClient = BwmHttpClientUtil.getConnection();
        defaultJsonHeader.put("Content-Type", "application/json;charset=UTF-8");
    }
}

