/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.type;

import com.aliyun.migration.workflow.migration.common.type.DbType;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum SQLDialectType {
    MYSQL(DbType.MYSQL.getDescp(), "mysql"),
    POSTGRESQL(DbType.POSTGRESQL.getDescp(), "postgres"),
    HIVE(DbType.HIVE.getDescp(), "hive"),
    SPARK(DbType.SPARK.getDescp(), "spark"),
    CLICKHOUSE(DbType.CLICKHOUSE.getDescp(), "clickhouse"),
    ORACLE(DbType.ORACLE.getDescp(), "oracle"),
    GAUSS(DbType.GAUSSDB.getDescp(), "gaussdb"),
    PRESTO(DbType.PRESTO.getDescp(), "presto"),
    REDSHIFT(DbType.REDSHIFT.getDescp(), "redshift"),
    STARROCKS(DbType.STARROCKS.getDescp(), "starrocks"),
    DORIS(DbType.DORIS.getDescp(), "doris"),
    MAXCOMPUTE("maxcompute", "maxcompute"),
    HOLOGRES("hologres", "hologres");

    private String dbType;
    private String sqlDialectType;

    private SQLDialectType(String dbType, String sqlDialectType) {
        this.dbType = dbType;
        this.sqlDialectType = sqlDialectType;
    }

    public static String sqlDialectOf(String dbType) {
        for (SQLDialectType dialectType : SQLDialectType.values()) {
            if (!dialectType.dbType.equalsIgnoreCase(dbType)) continue;
            return dialectType.sqlDialectType;
        }
        return null;
    }

    public static String dbTypeOf(String sqlDialectType) {
        for (SQLDialectType dialectType : SQLDialectType.values()) {
            if (!dialectType.sqlDialectType.equalsIgnoreCase(sqlDialectType)) continue;
            return dialectType.dbType;
        }
        return null;
    }

    public static List<String> allDialect() {
        return Arrays.stream(SQLDialectType.values()).map(t -> t.sqlDialectType).collect(Collectors.toList());
    }
}

