/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.serializes;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.DateDeserializers;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomerDateDeserializer
extends DateDeserializers.DateDeserializer {
    private static final Logger log = LoggerFactory.getLogger(CustomerDateDeserializer.class);
    private static final long serialVersionUID = -6736490822940239996L;
    private static String[] formatArray = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ssXXX", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "EEE, dd MMM yyyy HH:mm:ss zzz", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd"};

    public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Date date;
        if (6 == jsonParser.getCurrentTokenId() && Objects.nonNull(date = this.parseDateTraverseFormat(jsonParser.getText().trim()))) {
            return date;
        }
        return super.deserialize(jsonParser, deserializationContext);
    }

    private Date parseDateTraverseFormat(String value) {
        for (String dateFormat : formatArray) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat, Locale.CHINESE);
                return simpleDateFormat.parse(value);
            }
            catch (ParseException parseException) {
            }
        }
        log.error("failed to parse data String:{}", (Object)value);
        return null;
    }
}

