/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.convert.sqoop2di;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DIJsonProcessor;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.DIType;
import com.aliyun.migration.workflow.migration.common.convert.sqoop2di.AbstractSqoopConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQL2MySQLForSqoopReaderConverter
extends AbstractSqoopConverter {
    private static final Logger log = LoggerFactory.getLogger(MySQL2MySQLForSqoopReaderConverter.class);

    public MySQL2MySQLForSqoopReaderConverter(List<Datasource> datasourceList) {
        super(datasourceList);
    }

    @Override
    public void convert(JSONObject readerJson, DIJsonProcessor readerJp) {
        JSONObject parameter = readerJson.getJSONObject("parameter");
        if (parameter == null) {
            log.warn("reader.parameter.can.not.be.null");
            return;
        }
        Integer srcDataSource = parameter.containsKey((Object)"srcDataSource") ? parameter.getInteger("srcDataSource") : null;
        String srcTable = parameter.containsKey((Object)"srcTable") ? parameter.getString("srcTable") : null;
        Integer srcQueryType = parameter.containsKey((Object)"srcQueryType") ? parameter.getInteger("srcQueryType") : null;
        String srcQuerySql = parameter.containsKey((Object)"srcQuerySql") ? parameter.getString("srcQuerySql") : null;
        Integer srcColumnType = parameter.containsKey((Object)"srcColumnType") ? parameter.getInteger("srcColumnType") : null;
        String srcColumns = parameter.containsKey((Object)"srcColumns") ? parameter.getString("srcColumns") : null;
        ArrayList srcConditionList = new ArrayList();
        ArrayList mapColumnList = new ArrayList();
        ArrayList mapColumnJava = new ArrayList();
        if (parameter.containsKey((Object)"srcConditionList")) {
            parameter.getJSONArray("srcConditionList").forEach(x -> ((JSONObject)x).forEach((k, v) -> srcConditionList.add(Map.of(k, v.toString()))));
        }
        if (parameter.containsKey((Object)"mapColumnList")) {
            parameter.getJSONArray("mapColumnList").forEach(x -> ((JSONObject)x).forEach((k, v) -> mapColumnList.add(Map.of(k, v.toString()))));
        }
        if (parameter.containsKey((Object)"mapColumnJava")) {
            parameter.getJSONArray("mapColumnJava").forEach(x -> ((JSONObject)x).forEach((k, v) -> mapColumnJava.add(Map.of(k, v.toString()))));
        }
        readerJp.set("stepType", (Object)DIType.MYSQL.getStepType());
        readerJp.set("parameter.column", (Object)srcColumns);
        JSONArray connection = new JSONArray();
        JSONObject singleConnection = new JSONObject();
        singleConnection.put("parameter.table", (Object)new String[]{srcTable});
        singleConnection.put("parameter.querySql", (Object)srcQuerySql);
        singleConnection.put("parameter.datasource", (Object)super.getDatasourceNamebyId(srcDataSource));
        connection.add((Object)singleConnection);
        readerJp.set("parameter.connection", (Object)connection);
    }
}

