/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.convert.shell2n;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.shell.ShellParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.CodeModeType;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DIJsonProcessor;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.shell2n.AbstractShellConverter;
import com.aliyun.migration.workflow.migration.common.convert.shell2n.component.SqoopCommand;
import com.aliyun.migration.workflow.migration.common.convert.utils.ScriptArgsReplace;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellSqoopConverter
extends AbstractShellConverter {
    private static final Logger log = LoggerFactory.getLogger(ShellSqoopConverter.class);

    public ShellSqoopConverter(TaskContext taskContext, Workflow workflow) {
        super(taskContext, workflow);
        this.workflow = workflow;
    }

    @Override
    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = BwmJsonUtil.deepCopy(workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            tgtNodes.add(workflowNode);
            return tgtNodes;
        }
        tgtworkflowNode.setNodeType(CodeProgramType.DI.name());
        if (super.isShellSqoopScriptConvertEnabled(workflowNode).booleanValue()) {
            if (this.isJsonString(workflowNode.getScript()).booleanValue()) {
                ShellParameters parameter = (ShellParameters)GsonUtils.fromJsonString((String)workflowNode.getScript(), (Type)TypeToken.get(ShellParameters.class).getType());
                if (tgtworkflowNode.getParamMap() == null) {
                    tgtworkflowNode.setParamMap(new HashMap());
                }
                ListUtils.emptyIfNull((List)parameter.getLocalParams()).forEach(x -> {
                    String prop = x.getProp();
                    String value = x.getValue();
                    tgtworkflowNode.getParamMap().put(prop, value);
                });
                if (this.isShellScriptParamReplaceEnabled(workflowNode).booleanValue()) {
                    parameter.setRawScript(ScriptArgsReplace.replace(parameter.getRawScript(), tgtworkflowNode.getParamMap(), this.workflow.getCustomProperties(), null));
                }
                DIJsonProcessor diProcessor = new SqoopCommand(parameter.getRawScript()).convertCmdToDiJson();
                diProcessor.set("extend.mode", (Object)CodeModeType.CODE.getValue());
                tgtworkflowNode.setScript(diProcessor.toJSON());
            } else {
                if (this.isShellScriptParamReplaceEnabled(workflowNode).booleanValue()) {
                    workflowNode.setScript(ScriptArgsReplace.replace(workflowNode.getScript(), workflowNode.getParamMap(), this.workflow.getCustomProperties(), null));
                }
                DIJsonProcessor diProcessor = new SqoopCommand(workflowNode.getScript()).convertCmdToDiJson();
                diProcessor.set("extend.mode", (Object)CodeModeType.CODE.getValue());
                tgtworkflowNode.setScript(diProcessor.toJSON());
            }
        }
        this.supplyBaseMsg(tgtworkflowNode);
        tgtNodes.add(tgtworkflowNode);
        return tgtNodes;
    }
}

