/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.convert.datax2di;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DIJsonProcessor;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.AbstractDataxConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.DIType;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SqlServer2SqlServerForDataXWriterConverter
extends AbstractDataxConverter {
    private static final Logger log = LoggerFactory.getLogger(SqlServer2SqlServerForDataXWriterConverter.class);

    @Override
    public void convert(JSONObject readerJson, DIJsonProcessor writerJp) {
        Object[] objectArray;
        Integer batchSize;
        JSONObject parameter = readerJson.getJSONObject("parameter");
        if (parameter == null) {
            log.warn("reader.parameter.can.not.be.null");
            return;
        }
        String jdbcUrl = "";
        ArrayList table = new ArrayList();
        ArrayList column = new ArrayList();
        ArrayList session = new ArrayList();
        ArrayList preSql = new ArrayList();
        ArrayList postSql = new ArrayList();
        Integer n = batchSize = parameter.containsKey((Object)"batchSize") ? parameter.getInteger("batchSize") : null;
        if (parameter.containsKey((Object)"connection")) {
            JSONObject connection = (JSONObject)parameter.getJSONArray("connection").get(0);
            String string = jdbcUrl = connection.containsKey((Object)"jdbcUrl") ? connection.getString("jdbcUrl") : "";
            if (connection.containsKey((Object)"table")) {
                connection.getJSONArray("table").forEach(x -> table.add(x.toString()));
            }
        }
        if (parameter.containsKey((Object)"column")) {
            parameter.getJSONArray("column").forEach(x -> column.add(x.toString()));
        }
        if (parameter.containsKey((Object)"session")) {
            parameter.getJSONArray("session").forEach(x -> session.add(x.toString()));
        }
        if (parameter.containsKey((Object)"preSql")) {
            parameter.getJSONArray("preSql").forEach(x -> preSql.add(x.toString()));
        }
        if (parameter.containsKey((Object)"postSql")) {
            parameter.getJSONArray("postSql").forEach(x -> postSql.add(x.toString()));
        }
        writerJp.set("stepType", (Object)DIType.SQLSERVER.getStepType());
        if (CollectionUtils.isEmpty(column)) {
            String[] stringArray = new String[1];
            objectArray = stringArray;
            stringArray[0] = "*";
        } else {
            objectArray = column.toArray();
        }
        writerJp.set("parameter.column", (Object)objectArray);
        writerJp.set("parameter.preSql", (Object)(CollectionUtils.isEmpty(preSql) ? new String[]{} : preSql.toArray()));
        writerJp.set("parameter.postSql", (Object)(CollectionUtils.isEmpty(postSql) ? new String[]{} : postSql.toArray()));
        writerJp.set("parameter.batchSize", (Object)(batchSize == null ? 256 : batchSize));
        writerJp.set("parameter.table", !table.isEmpty() ? table.get(0) : "");
        writerJp.set("parameter.datasource", (Object)this.getDatabaseFromUrl(jdbcUrl));
    }
}

