/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.convert.datax2di;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DIJsonProcessor;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.AbstractDataxConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.DIType;
import java.util.ArrayList;
import org.apache.commons.lang.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class Odps2OdpsForDataXWriterConverter
extends AbstractDataxConverter {
    private static final Logger log = LoggerFactory.getLogger(Odps2OdpsForDataXWriterConverter.class);

    @Override
    public void convert(JSONObject readerJson, DIJsonProcessor writerJp) {
        Object[] objectArray;
        String tunnelServer;
        JSONObject parameter = readerJson.getJSONObject("parameter");
        if (parameter == null) {
            log.warn("reader.parameter.can.not.be.null");
            return;
        }
        String accessId = parameter.containsKey((Object)"accessId") ? parameter.getString("accessId") : "";
        String accessKey = parameter.containsKey((Object)"accessKey") ? parameter.getString("accessKey") : "";
        String project = parameter.containsKey((Object)"project") ? parameter.getString("project") : "";
        String table = parameter.containsKey((Object)"table") ? parameter.getString("table") : "";
        ArrayList partition = new ArrayList();
        ArrayList column = new ArrayList();
        Boolean truncate = parameter.containsKey((Object)"truncate") ? BooleanUtils.toBoolean((String)parameter.getString("truncate")) : true;
        String odpsServer = parameter.containsKey((Object)"odpsServer") ? parameter.getString("odpsServer") : "";
        String string = tunnelServer = parameter.containsKey((Object)"tunnelServer") ? parameter.getString("tunnelServer") : "";
        if (parameter.containsKey((Object)"partition")) {
            parameter.getJSONArray("partition").forEach(x -> partition.add(x.toString()));
        }
        if (parameter.containsKey((Object)"column")) {
            parameter.getJSONArray("column").forEach(x -> column.add(x.toString()));
        }
        writerJp.set("stepType", (Object)DIType.ODPS.getStepType());
        writerJp.set("parameter.datasource", (Object)project);
        writerJp.set("parameter.table", (Object)table);
        writerJp.set("parameter.partition", (Object)(CollectionUtils.isEmpty(partition) ? new String[]{} : partition.toArray()));
        if (CollectionUtils.isEmpty(column)) {
            String[] stringArray = new String[1];
            objectArray = stringArray;
            stringArray[0] = "*";
        } else {
            objectArray = column.toArray();
        }
        writerJp.set("parameter.column", (Object)objectArray);
        writerJp.set("parameter.truncate", (Object)truncate);
    }
}

