/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.convert.datax2di;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DIJsonProcessor;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.AbstractDataxConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.DIType;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.Oss2OssForDataXReaderConverter;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hdfs2HdfsForDataXReaderConverter
extends AbstractDataxConverter {
    private static final Logger log = LoggerFactory.getLogger(Hdfs2HdfsForDataXReaderConverter.class);

    @Override
    public void convert(JSONObject readerJson, DIJsonProcessor readerJp) {
        String fileFormat;
        JSONObject parameter = readerJson.getJSONObject("parameter");
        if (parameter == null) {
            log.warn("reader.parameter.can.not.be.null");
            return;
        }
        String path = parameter.containsKey((Object)"path") ? parameter.getString("path") : "";
        String defaultFs = parameter.containsKey((Object)"defaultFs") ? parameter.getString("defaultFs") : "";
        String fileType = parameter.containsKey((Object)"fileType") ? parameter.getString("fileType") : fileFormatType.TEXT.getType();
        ArrayList column = new ArrayList();
        String fieldDelimiter = parameter.containsKey((Object)"fieldDelimiter") ? parameter.getString("fieldDelimiter") : "";
        String compress = parameter.containsKey((Object)"compress") ? parameter.getString("compress") : null;
        String encoding = parameter.containsKey((Object)"encoding") ? parameter.getString("encoding") : "utf-8";
        String nullFormat = parameter.containsKey((Object)"nullFormat") ? parameter.getString("nullFormat") : "\\N";
        HashMap csvReaderConfig = new HashMap();
        Boolean haveKerberos = parameter.containsKey((Object)"haveKerberos") ? BooleanUtils.toBoolean((String)parameter.getString("haveKerberos")) : false;
        String kerberosKeytab = parameter.containsKey((Object)"kerberosKeytab") ? parameter.getString("kerberosKeytab") : "";
        String kerberosPrincipal = parameter.containsKey((Object)"kerberosPrincipal") ? parameter.getString("kerberosPrincipal") : "";
        HashMap hadoopConfig = new HashMap();
        if (parameter.containsKey((Object)"column")) {
            parameter.getJSONArray("column").forEach(singleColumn -> column.add(new HashMap<String, Object>(){
                {
                    ((JSONObject)singleColumn).forEach((key, value) -> this.put(key, value));
                }
            }));
        }
        if (parameter.containsKey((Object)"csvReaderConfig")) {
            parameter.getJSONObject("csvReaderConfig").keySet().forEach(x -> csvReaderConfig.put(x, parameter.getJSONObject("csvReaderConfig").get(x)));
        }
        if (parameter.containsKey((Object)"hadoopConfig")) {
            parameter.getJSONObject("hadoopConfig").keySet().forEach(x -> hadoopConfig.put(x, parameter.getJSONObject("hadoopConfig").getString(x)));
        }
        readerJp.set("stepType", (Object)DIType.HDFS.getStepType());
        readerJp.set("parameter.path", (Object)path);
        readerJp.set("parameter.defaultFs", (Object)defaultFs);
        readerJp.set("parameter.fileType", (Object)fileType);
        readerJp.set("parameter.fieldDelimiter", (Object)fieldDelimiter);
        readerJp.set("parameter.compress", (Object)compress);
        readerJp.set("parameter.encoding", (Object)encoding);
        readerJp.set("parameter.nullFormat", (Object)nullFormat);
        readerJp.set("parameter.haveKerberos", (Object)haveKerberos);
        readerJp.set("parameter.kerberosKeytab", (Object)kerberosKeytab);
        readerJp.set("parameter.kerberosPrincipal", (Object)kerberosPrincipal);
        readerJp.set("parameter.column", (Object)parameter.getJSONArray("column"));
        readerJp.set("parameter.csvReaderConfig", (Object)parameter.getJSONObject("csvReaderConfig"));
        readerJp.set("parameter.hadoopConfig", (Object)parameter.getJSONObject("hadoopConfig"));
        String string = fileFormat = parameter.containsKey((Object)"fileFormat") ? parameter.getString("fileFormat") : Oss2OssForDataXReaderConverter.fileFormatType.CSV.getType();
        if (fileFormat.equals(Oss2OssForDataXReaderConverter.fileFormatType.PARQUET.getType()) || fileFormat.equals(Oss2OssForDataXReaderConverter.fileFormatType.PARQUET.getType().toUpperCase())) {
            String parquetSchema = parameter.containsKey((Object)"parquetSchema") ? parameter.getString("parquetSchema") : "";
            readerJp.set("parquetSchema", (Object)parquetSchema);
        }
    }

    protected static enum fileFormatType {
        TEXT("text"),
        CSV("csv"),
        ORC("orc"),
        SEQ("seq"),
        RC("rc"),
        PARQUET("parquet");

        private final String type;

        private fileFormatType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

