/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.convert.datax2di;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DIJsonProcessor;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.AbstractDataxConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.DataxType;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

class DefaultDataxReaderConverter
extends AbstractDataxConverter {
    private static final Logger log = LoggerFactory.getLogger(DefaultDataxReaderConverter.class);

    DefaultDataxReaderConverter() {
    }

    @Override
    public void convert(JSONObject readerJson, DIJsonProcessor readerJp) {
        Object[] objectArray;
        JSONObject parameter = readerJson.getJSONObject("parameter");
        if (parameter == null) {
            log.warn("reader.parameter.can.not.be.null");
            return;
        }
        String splitPk = parameter.containsKey((Object)"splitPk") ? parameter.getString("splitPk") : "";
        JSONArray columnArr = parameter.containsKey((Object)"column") ? parameter.getJSONArray("column") : new JSONArray();
        ArrayList columns = new ArrayList();
        if (Objects.nonNull(columnArr)) {
            columnArr.forEach(x -> columns.add(x.toString()));
        }
        String whereStr = parameter.containsKey((Object)"where") ? parameter.getString("where") : "";
        JSONArray connection = parameter.getJSONArray("connection");
        if (Objects.nonNull(connection)) {
            JSONObject connectionJSONObject = connection.getJSONObject(0);
            JSONArray jdbcUrls = connectionJSONObject.containsKey((Object)"jdbcUrl") ? connectionJSONObject.getJSONArray("jdbcUrl") : new JSONArray();
            JSONArray querySqlArr = connectionJSONObject.getJSONArray("querySql");
            String jdbcUrlString = jdbcUrls.size() > 0 ? jdbcUrls.getString(0) : "";
            String databaseFromUrl = this.getDatabaseFromUrl(jdbcUrlString);
            JSONArray tables = connectionJSONObject.getJSONArray("table");
            if (Objects.nonNull(tables) && !tables.isEmpty()) {
                readerJp.set("parameter.table", tables.get(0));
            } else if (Objects.nonNull(querySqlArr)) {
                JSONObject connJson = new JSONObject();
                connJson.put("datasource", (Object)databaseFromUrl);
                connJson.put("querySql", (Object)querySqlArr);
                readerJp.set("parameter.connection", (Object)connJson);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)splitPk)) {
            readerJp.set("parameter.splitPk", (Object)splitPk);
        }
        readerJp.set("stepType", (Object)DataxType.MYSQL.getType());
        readerJp.set("parameter.where", (Object)(StringUtils.isBlank((CharSequence)whereStr) ? "" : whereStr));
        if (CollectionUtils.isEmpty(columns)) {
            String[] stringArray = new String[1];
            objectArray = stringArray;
            stringArray[0] = "*";
        } else {
            objectArray = columns.toArray();
        }
        readerJp.set("parameter.column", (Object)objectArray);
    }
}

