/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.convert.datax2di;

import java.util.Arrays;

public enum DataxType {
    MYSQL("mysqlreader", "mysqlwriter", "mysql"),
    POSTGRESQL("postgresqlreader", "postgresqlwriter", "postgresql"),
    ORACLE("oraclereader", "oraclewriter", "oracle"),
    SQLSERVER("sqlserverreader", "sqlserverwriter", "sqlserver"),
    ODPS("odpsreader", "odpswriter", "odps"),
    OSS("ossreader", "osswriter", "oss"),
    HIVE("hdfsreader", "hdfswriter", "hdfs"),
    CLICKHOUSE("clickhousereader", "clickhousewriter", "clickhouse"),
    MONGODB("mongodbreader", "mongodbwriter", "mongodb"),
    HDFS("hdfsreader", "hdfswriter", "hdfs"),
    S3("s3reader", "s3writer", "s3"),
    DEFAULT("dafault", "default", "dafault");

    private String readName;
    private String writerName;
    private String type;

    public String getReadName() {
        return this.readName;
    }

    public String getWriterName() {
        return this.writerName;
    }

    public String getType() {
        return this.type;
    }

    private DataxType(String readName, String writerName, String type) {
        this.readName = readName;
        this.writerName = writerName;
        this.type = type;
    }

    public static DataxType getTypeByReaderName(String readName) {
        return Arrays.stream(DataxType.values()).filter(dataxType -> dataxType.readName.equals(readName)).findFirst().orElse(DEFAULT);
    }

    public static DataxType getTypeByWriterName(String writerName) {
        return Arrays.stream(DataxType.values()).filter(dataxType -> dataxType.writerName.equals(writerName)).findFirst().orElse(DEFAULT);
    }

    public static DataxType getTypeByName(String name) {
        return Arrays.stream(DataxType.values()).filter(dataxType -> dataxType.type.equals(name)).findFirst().orElse(DEFAULT);
    }
}

