/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.convert.datax2di;

import com.aliyun.migration.workflow.migration.common.convert.datax2di.AbstractDataxConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.ClickHouse2ClickHouseForDataXReaderConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.DataxType;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.DefaultDataxReaderConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.Hdfs2HdfsForDataXReaderConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.MongoDB2MongoDBForDataXReaderConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.MySQL2MySQLForDataXReaderConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.Odps2OdpsForDataXReaderConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.Oracle2OracleForDataXReaderConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.Oss2OssForDataXReaderConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.PostgreSQL2PostgreSQLForDataXReaderConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.SqlServer2SqlServerForDataXReaderConverter;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import java.util.HashMap;
import java.util.Map;

public class DataxReaderConvertFactory {
    private BwmConfiguration readerConfiguration;

    public DataxReaderConvertFactory(BwmConfiguration bwmConfiguration) {
        this.readerConfiguration = bwmConfiguration;
    }

    public AbstractDataxConverter getReaderConvert(String readName) {
        Map<String, Object> configurationMap = this.readerConfiguration.getMap("self", new HashMap<String, Object>());
        BwmConfiguration dataxConfiguration = BwmConfiguration.from(configurationMap.getOrDefault("datax.datasource.map", "{}").toString());
        DataxType dataxType = DataxType.getTypeByReaderName(readName);
        String resTypeStr = dataxConfiguration.getString(dataxType.getType(), dataxType.getType());
        DataxType resType = DataxType.getTypeByName(resTypeStr);
        switch (resType) {
            case MYSQL: {
                return new MySQL2MySQLForDataXReaderConverter();
            }
            case POSTGRESQL: {
                return new PostgreSQL2PostgreSQLForDataXReaderConverter();
            }
            case ORACLE: {
                return new Oracle2OracleForDataXReaderConverter();
            }
            case SQLSERVER: {
                return new SqlServer2SqlServerForDataXReaderConverter();
            }
            case ODPS: {
                return new Odps2OdpsForDataXReaderConverter();
            }
            case OSS: {
                return new Oss2OssForDataXReaderConverter();
            }
            case HIVE: 
            case HDFS: {
                return new Hdfs2HdfsForDataXReaderConverter();
            }
            case CLICKHOUSE: {
                return new ClickHouse2ClickHouseForDataXReaderConverter();
            }
            case MONGODB: {
                return new MongoDB2MongoDBForDataXReaderConverter();
            }
        }
        return new DefaultDataxReaderConverter();
    }
}

