/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.convert;

import com.alibaba.fastjson2.JSONArray;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConvert<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractConvert.class);
    protected TaskContext taskContext;

    public String getTargetEngineTypeStr(TaskContext taskContext) {
        try {
            return this.getTgtEngineType(BwmConfiguration.from(taskContext.getBwmConfiguration()));
        }
        catch (Exception e) {
            log.error("Cannot get targetEngineType from config, set default value \"MaxCompute\".");
            return "MaxCompute";
        }
    }

    public String getTgtEngineType(BwmConfiguration bwmConfiguration) {
        BwmConfiguration configuration = bwmConfiguration.getConfiguration("conf");
        Map<String, Object> map = configuration.getMap("settings");
        String engineType = ((Map)Optional.ofNullable(map).orElse(new HashMap())).getOrDefault("workflow.converter.target.engine.type", "MaxCompute").toString();
        return engineType;
    }

    public String getTargetEngineNameStr(TaskContext taskContext) {
        try {
            return this.getTgtEngineName(BwmConfiguration.from(taskContext.getBwmConfiguration()));
        }
        catch (Exception e) {
            log.error("Cannot get targetEngineName from config, set default value with \"MaxCompute\".");
            return "MaxCompute";
        }
    }

    public String getTgtEngineName(BwmConfiguration bwmConfiguration) {
        BwmConfiguration configuration = bwmConfiguration.getConfiguration("conf");
        Map<String, Object> map = configuration.getMap("settings");
        String engineName = ((Map)Optional.ofNullable(map).orElse(new HashMap())).getOrDefault("workflow.converter.target.engine.datasource.name", ((Map)Optional.ofNullable(map).orElse(new HashMap())).getOrDefault("workflow.converter.target.engine.type", "MaxCompute").toString()).toString();
        return engineName;
    }

    public Map<String, String> getOwnerMapping(BwmConfiguration bwmConfiguration) {
        String diDsMap = null;
        diDsMap = bwmConfiguration.get("self") != null ? BwmJsonUtil.toJsonString(bwmConfiguration.getMap("self").get("owner.map")) : BwmJsonUtil.toJsonString(bwmConfiguration.getMap("owner.map"));
        if (diDsMap == null) {
            return new HashMap<String, String>();
        }
        try {
            List jsonArray = JSONArray.parseArray((String)diDsMap, MigrationOwnerMapping.class);
            HashMap<String, String> ownerMapping = new HashMap<String, String>();
            jsonArray.forEach(mapping -> ownerMapping.put(mapping.getSrc(), mapping.getTgt()));
            return ownerMapping;
        }
        catch (Exception e) {
            log.warn("Cannot get ownerMapping from config, set default value with empty map.");
            return new HashMap<String, String>();
        }
    }

    public AbstractConvert(TaskContext taskContext) {
        this.taskContext = taskContext;
    }

    public abstract T convert(T var1);

    public static class MigrationOwnerMapping {
        private String src;
        private String tgt;

        public String getSrc() {
            return this.src;
        }

        public String getTgt() {
            return this.tgt;
        }

        public void setSrc(String src) {
            this.src = src;
        }

        public void setTgt(String tgt) {
            this.tgt = tgt;
        }
    }
}

