/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.config;

import com.alibaba.fastjson2.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class FilterRule {
    private FilterType type;
    private FilterElement element;
    private FilterFieldType field;
    private String value;
    private List<String> valueList;

    public FilterRule(String jsonStr) {
        JSONObject obj = JSONObject.parseObject((String)jsonStr);
        if (obj.containsKey("element")) {
            this.element = FilterElement.getFilterElement(obj.getString("element"));
        }
        if (obj.containsKey("type")) {
            this.type = FilterType.getFilterType(obj.get("type"));
        }
        if (obj.containsKey("field")) {
            this.field = FilterFieldType.getFilterFieldType(obj.get("field"));
        }
        if (obj.containsKey("value")) {
            this.value = obj.getString("value");
            if (this.value != null && !this.value.equals("")) {
                this.valueList = new ArrayList<String>();
                Arrays.stream(this.value.split(",")).forEach(value -> this.valueList.add(value.trim()));
            }
        }
    }

    public Boolean isMatch(String id, String name) {
        if (this.type == null || this.element == null || this.field == null || this.valueList == null || this.valueList.isEmpty()) {
            return true;
        }
        if (this.field.equals((Object)FilterFieldType.ID)) {
            if (StringUtils.isBlank((CharSequence)id)) {
                return ObjectUtils.equals((Object)((Object)this.type), (Object)((Object)FilterType.BLACK));
            }
            if (this.type.equals((Object)FilterType.WHITE)) {
                return this.valueList.contains(id);
            }
            if (this.type.equals((Object)FilterType.BLACK)) {
                return !this.valueList.contains(id);
            }
        } else if (this.field.equals((Object)FilterFieldType.NAME)) {
            if (StringUtils.isBlank((CharSequence)name)) {
                return ObjectUtils.equals((Object)((Object)this.type), (Object)((Object)FilterType.BLACK));
            }
            if (this.type.equals((Object)FilterType.WHITE)) {
                return this.valueList.contains(name);
            }
            if (this.type.equals((Object)FilterType.BLACK)) {
                return !this.valueList.contains(name);
            }
        }
        return false;
    }

    public FilterType getType() {
        return this.type;
    }

    public FilterElement getElement() {
        return this.element;
    }

    public FilterFieldType getField() {
        return this.field;
    }

    public String getValue() {
        return this.value;
    }

    public List<String> getValueList() {
        return this.valueList;
    }

    public static enum FilterElement {
        WORKFLOW("workflow"),
        NODE("node");

        String value;

        private FilterElement(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static FilterElement getFilterElement(String element) {
            for (FilterElement filterElement : FilterElement.values()) {
                if (!filterElement.getValue().equalsIgnoreCase(element)) continue;
                return filterElement;
            }
            return null;
        }
    }

    public static enum FilterType {
        BLACK("black", 0),
        WHITE("white", 1);

        String value;
        Integer code;

        private FilterType(String value, Integer code) {
            this.value = value;
            this.code = code;
        }

        public String getValue() {
            return this.value;
        }

        public Integer getCode() {
            return this.code;
        }

        public static FilterType getFilterType(Object type) {
            if (type instanceof String) {
                for (FilterType filterType : FilterType.values()) {
                    if (!filterType.getValue().equalsIgnoreCase((String)type)) continue;
                    return filterType;
                }
                for (FilterType filterType : FilterType.values()) {
                    if (!String.valueOf(filterType.getCode()).equalsIgnoreCase((String)type)) continue;
                    return filterType;
                }
            }
            if (type instanceof Integer || type instanceof Byte) {
                for (FilterType filterType : FilterType.values()) {
                    if (!filterType.getCode().equals(type)) continue;
                    return filterType;
                }
            }
            return null;
        }
    }

    public static enum FilterFieldType {
        ID("id", 0),
        NAME("name", 1);

        String value;
        Integer code;

        private FilterFieldType(String value, Integer code) {
            this.value = value;
            this.code = code;
        }

        public String getValue() {
            return this.value;
        }

        public Integer getCode() {
            return this.code;
        }

        public static FilterFieldType getFilterFieldType(Object fieldType) {
            if (fieldType instanceof String) {
                for (FilterFieldType filterFieldType : FilterFieldType.values()) {
                    if (!filterFieldType.getValue().equalsIgnoreCase((String)fieldType)) continue;
                    return filterFieldType;
                }
                for (FilterFieldType filterFieldType : FilterFieldType.values()) {
                    if (!String.valueOf(filterFieldType.getCode()).equalsIgnoreCase((String)fieldType)) continue;
                    return filterFieldType;
                }
            }
            if (fieldType instanceof Integer || fieldType instanceof Byte) {
                for (FilterFieldType filterFieldType : FilterFieldType.values()) {
                    if (!filterFieldType.getCode().equals(fieldType)) continue;
                    return filterFieldType;
                }
            }
            return null;
        }
    }
}

