/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.bean;

import com.aliyun.migration.workflow.migration.common.bean.BwmJsonObject;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.google.gson.JsonArray;
import java.util.Collection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BwmJsonArray
extends JSONArray {
    private static final Logger log = LoggerFactory.getLogger(BwmJsonArray.class);

    public BwmJsonArray() {
    }

    public BwmJsonArray(JSONTokener x) throws JSONException {
        super(x);
    }

    public BwmJsonArray(String source) throws JSONException {
        super(source);
    }

    public BwmJsonArray(Collection<?> collection) {
        super(collection);
    }

    public BwmJsonArray(Iterable<?> iter) {
        super(iter);
    }

    public BwmJsonArray(BwmJsonArray array) {
        super((JSONArray)array);
    }

    public BwmJsonArray(JsonArray array) {
        super((Iterable)array);
    }

    public BwmJsonArray(Object array) throws JSONException {
        super(array);
    }

    public BwmJsonArray(int initialCapacity) throws JSONException {
        super(initialCapacity);
    }

    public Object get(int index) {
        try {
            return super.get(index);
        }
        catch (JSONException e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    public BwmJsonObject getJsonObjectWrap(int index) {
        try {
            Object object = this.get(index);
            if (object instanceof BwmJsonObject) {
                return (BwmJsonObject)((Object)object);
            }
            if (object instanceof JSONObject) {
                BwmJsonObject BwmJsonObject2 = new BwmJsonObject(BwmJsonUtil.toJsonString(object));
                this.put(index, (Object)BwmJsonObject2);
                return BwmJsonObject2;
            }
            throw new JSONException("JSONArray[" + index + "] is not a BwmJsonObject.", null);
        }
        catch (JSONException e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    public BwmJsonArray getJsonArrayWrap(int index) {
        try {
            Object object = this.get(index);
            if (object instanceof BwmJsonArray) {
                return (BwmJsonArray)((Object)object);
            }
            if (object instanceof JSONArray) {
                BwmJsonArray array = new BwmJsonArray(BwmJsonUtil.toJsonString(object));
                this.put(index, (Object)array);
                return array;
            }
            throw new JSONException("JSONArray[" + index + "] is not a BwmJsonArray.", null);
        }
        catch (JSONException e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    public String toJsonString() {
        return BwmJsonUtil.toJsonString((Object)this);
    }
}

