/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common;

import com.alibaba.fastjson2.JSONArray;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DataWorksPackage;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.plugin.Converter;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFunctionResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.workflow.migration.common.AbstractConverter;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvert;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvertFactory;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataworksConverter
extends AbstractConverter {
    private static final Logger log = LoggerFactory.getLogger(DataworksConverter.class);

    @Override
    public AbstractConvertFactory getConvertFactory() {
        return null;
    }

    protected DataWorksPackage convertUseMxTransform(String mxConfigFilePath, String sourceFilePath, String targetFilePath) {
        return null;
    }

    @Override
    public Converter init(TaskContext taskContext) throws IOException {
        super.init(taskContext);
        Datasource readerDatasource = taskContext.getReaderDatasource();
        Map readerDatasourceProperties = readerDatasource.getProperties();
        this.sourceFilePath = (String)readerDatasourceProperties.get("export-file-path");
        return this;
    }

    @Override
    public WorkflowProjectPackage convertUseMx() {
        return null;
    }

    @Override
    public WorkflowProjectPackage convertSelf() {
        WorkflowProjectPackage workflowProjectPackage = this.getWorkflowPackage();
        if (Objects.isNull(workflowProjectPackage)) {
            log.warn("not found flow package");
            return null;
        }
        this.taskContext.setWorkflowProjectPackage(BwmJsonUtil.deepCopy(workflowProjectPackage, WorkflowProjectPackage.class));
        if (workflowProjectPackage.getWorkflowProject() != null) {
            String projectId = workflowProjectPackage.getWorkflowProject().getProjectId();
            String projectName = workflowProjectPackage.getWorkflowProject().getName();
            if (workflowProjectPackage.getWorkflowList() != null) {
                for (Workflow workflow2 : workflowProjectPackage.getWorkflowList()) {
                    String workflowId = workflow2.getWorkflowId();
                    String workflowName = workflow2.getWorkflowName();
                    workflow2.setProjectId(projectId);
                    workflow2.setProjectName(projectName);
                    if (workflow2.getWorkflowNodes() == null) continue;
                    for (WorkflowNode workflowNode : workflow2.getWorkflowNodes()) {
                        workflowNode.setProjectId(projectId);
                        workflowNode.setProjectName(projectName);
                        workflowNode.setWorkflowId(workflowId);
                        workflowNode.setWorkflowName(workflowName);
                    }
                }
            }
        }
        boolean isDefaultConvert = Boolean.parseBoolean(((Object)this.selfConfMap.getOrDefault("if.use.default.convert", false)).toString());
        WorkflowProjectPackage targetWorkflowProjectPackage = new WorkflowProjectPackage();
        if (isDefaultConvert) {
            targetWorkflowProjectPackage = this.convertFactory.getDefaultConvert(this.taskContext).convert(workflowProjectPackage);
        } else {
            WorkflowProject tgtWorkflowProject = this.convertFactory.getProjectConvert(this.taskContext).convert(workflowProjectPackage.getWorkflowProject());
            targetWorkflowProjectPackage.setWorkflowProject(tgtWorkflowProject);
            ArrayList tgtWorkflows = new ArrayList();
            ((List)Optional.ofNullable(workflowProjectPackage.getWorkflowList()).orElse(new ArrayList())).forEach(workflow -> {
                if (this.filterRuleGroup.isMatch(workflow).booleanValue()) {
                    Workflow tgtWorkflow = this.convertSingleWorkflow((Workflow)workflow);
                    tgtWorkflows.add(tgtWorkflow);
                }
            });
            targetWorkflowProjectPackage.setWorkflowList(tgtWorkflows);
        }
        Map<String, Object> paramMap = this.getParamMapSetting();
        Map<String, Object> paramValueMapSetting = this.getParamValueMapSetting();
        if (CollectionUtils.isNotEmpty((Collection)targetWorkflowProjectPackage.getWorkflowList())) {
            for (Workflow workflow3 : targetWorkflowProjectPackage.getWorkflowList()) {
                if (workflow3.getCustomProperties() != null && workflow3.getCustomProperties().containsKey("param")) {
                    paramMap.forEach((key, value) -> {
                        if (((Map)workflow3.getCustomProperties().get("param")).containsKey(key)) {
                            ((Map)workflow3.getCustomProperties().get("param")).put(key, value);
                        }
                    });
                }
                if (workflow3.getWorkflowNodes() != null && !workflow3.getWorkflowNodes().isEmpty()) {
                    for (WorkflowNode workflowNode : workflow3.getWorkflowNodes()) {
                        if (workflowNode.getParamMap() == null || workflowNode.getParamMap().isEmpty()) continue;
                        paramMap.forEach((key, value) -> {
                            if (workflowNode.getParamMap().containsKey(key)) {
                                workflowNode.getParamMap().put(key, value);
                            }
                        });
                    }
                }
                if (workflow3.getCustomProperties() != null && workflow3.getCustomProperties().containsKey("param")) {
                    paramValueMapSetting.forEach((key, value) -> {
                        Map workflowParamMap = (Map)workflow3.getCustomProperties().get("param");
                        if (workflowParamMap.containsValue(key)) {
                            workflowParamMap.entrySet().forEach(entry -> {
                                boolean equals = entry.getValue().equals(key);
                                if (equals) {
                                    entry.setValue(value);
                                }
                            });
                        }
                    });
                }
                if (workflow3.getWorkflowNodes() == null || workflow3.getWorkflowNodes().isEmpty()) continue;
                for (WorkflowNode workflowNode : workflow3.getWorkflowNodes()) {
                    Map nodeParamMap = workflowNode.getParamMap();
                    if (nodeParamMap == null || nodeParamMap.isEmpty()) continue;
                    paramValueMapSetting.forEach((key, value) -> {
                        if (nodeParamMap.containsValue(key)) {
                            nodeParamMap.entrySet().forEach(entry -> {
                                boolean equals = entry.getValue().equals(key);
                                if (equals) {
                                    entry.setValue(value);
                                }
                            });
                        }
                    });
                    workflowNode.setParamMap(nodeParamMap);
                }
            }
        }
        return targetWorkflowProjectPackage;
    }

    public Workflow convertSingleWorkflow(Workflow workflow) {
        String cleanedPath;
        log.info("Convert In process: {}", (Object)workflow.getWorkflowName());
        Workflow tgtWorkflow = DataworksConverter.convertAll(this.convertFactory.getWorkflowConvert(this.taskContext), workflow, workflow.getWorkflowId(), workflow.getWorkflowName(), this.taskContext.getStatisticOp().getWorkflowTotalStatisticOp(), this.taskContext.getStatisticOp().getWorkflowSuccessStatisticOp(), this.taskContext.getStatisticOp().getWorkflowFailureStatisticOp());
        if (tgtWorkflow != null) {
            List relationPackages;
            if (tgtWorkflow.getNodeRelations() != null) {
                relationPackages = Optional.ofNullable(tgtWorkflow.getNodeRelations()).orElseGet(ArrayList::new);
            } else {
                relationPackages = Optional.ofNullable(workflow.getNodeRelations()).orElseGet(ArrayList::new);
                tgtWorkflow.setNodeRelations(relationPackages);
            }
            ArrayList orgRelationPackages = new ArrayList(workflow.getNodeRelations());
            ((List)Optional.ofNullable(workflow.getWorkflowNodes()).orElse(new ArrayList())).forEach(workflowNode -> {
                List workflowNodes = tgtWorkflow.getWorkflowNodes();
                ArrayList tgtResWorkflowNodes = new ArrayList();
                workflowNodes.stream().filter(x -> !x.getNodeId().equals(workflowNode.getNodeId())).forEach(x -> tgtResWorkflowNodes.add(x));
                tgtWorkflow.setWorkflowNodes(tgtResWorkflowNodes);
                List<WorkflowNode> tgtNodes = null;
                if (this.filterRuleGroup.isMatch(workflowNode).booleanValue()) {
                    tgtNodes = this.convertSingleNode(tgtWorkflow, (WorkflowNode)workflowNode);
                }
                if (tgtNodes == null) {
                    log.warn("Node Convert In process: {} {}", (Object)workflow.getWorkflowName(), (Object)workflowNode.getNodeName());
                    return;
                }
                this.compactNodeMap((WorkflowNode)workflowNode, tgtNodes);
                this.rebuildRelation(relationPackages, (WorkflowNode)workflowNode, tgtNodes, orgRelationPackages);
                orgRelationPackages.clear();
                orgRelationPackages.addAll(relationPackages);
                Set nodeNameAndIdSets = ((List)Optional.ofNullable(tgtWorkflow.getWorkflowNodes()).orElse(new ArrayList())).stream().map(x -> x.getNodeName() + x.getNodeId()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).collect(Collectors.toSet());
                ((List)Optional.ofNullable(tgtNodes).orElse(new ArrayList())).forEach(tgtNode -> {
                    if (Objects.nonNull(tgtNode.getNodeName()) && !nodeNameAndIdSets.contains(tgtNode.getNodeName() + tgtNode.getNodeId())) {
                        tgtWorkflow.getWorkflowNodes().add(tgtNode);
                    }
                });
            });
            ArrayList tgtFunctions = new ArrayList();
            ((List)Optional.ofNullable(tgtWorkflow.getFunctions()).orElse(new ArrayList())).forEach(workflowFunctionResource -> {
                if (this.inBlackListOrNot(workflowFunctionResource.getName(), workflowFunctionResource.getId(), this.workflowResourceBlackList).booleanValue()) {
                    return;
                }
                WorkflowFunctionResource tgtFunction = DataworksConverter.convertAll(this.convertFactory.getFunctionConvert(this.taskContext), workflowFunctionResource, workflowFunctionResource.getFunctionId(), workflowFunctionResource.getName(), this.taskContext.getStatisticOp().getWorkflowFunTotalStatisticOp(), this.taskContext.getStatisticOp().getWorkflowFunSuccessStatisticOp(), this.taskContext.getStatisticOp().getWorkflowFunFailureStatisticOp());
                tgtFunctions.add(tgtFunction);
            });
            tgtWorkflow.setFunctions(tgtFunctions);
            ArrayList tgtFiles = new ArrayList();
            ((List)Optional.ofNullable(tgtWorkflow.getFiles()).orElse(new ArrayList())).forEach(workflowFileResource -> {
                if (this.inBlackListOrNot(workflowFileResource.getName(), workflowFileResource.getId(), this.workflowResourceBlackList).booleanValue()) {
                    return;
                }
                WorkflowFileResource tgtFile = DataworksConverter.convertAll(this.convertFactory.getFileConvert(this.taskContext), workflowFileResource, workflowFileResource.getFileId(), workflowFileResource.getName(), this.taskContext.getStatisticOp().getWorkflowResourceTotalStatisticOp(), this.taskContext.getStatisticOp().getWorkflowResourceSuccessStatisticOp(), this.taskContext.getStatisticOp().getWorkflowResourceFailureStatisticOp());
                tgtFiles.add(tgtFile);
            });
            tgtWorkflow.setFiles(tgtFiles);
            Map customProperties = workflow.getCustomProperties();
            this.convertCustomProperties(customProperties, tgtWorkflow);
            List triggers = workflow.getTriggers();
            this.convertTrigger(triggers, tgtWorkflow);
            tgtWorkflow.setTriggers(triggers);
            this.convertParam(tgtWorkflow);
        }
        StringBuilder categoryValueSb = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)this.taskContext.getReaderDatasource().getName())) {
            categoryValueSb.append(this.taskContext.getReaderDatasource().getName()).append("/");
        }
        if (StringUtils.isNotEmpty((CharSequence)workflow.getCategoryValue())) {
            categoryValueSb.append(workflow.getCategoryValue()).append("/");
        }
        if ((cleanedPath = categoryValueSb.toString().replaceAll("/{2,}", "/")).endsWith("/")) {
            cleanedPath = cleanedPath.substring(0, cleanedPath.length() - 1);
        }
        tgtWorkflow.setCategoryValue(cleanedPath);
        Map<String, String> ownerMap = this.getOwnerMapping(BwmConfiguration.from(this.taskContext.getBwmConfiguration()));
        if (ownerMap.containsKey(tgtWorkflow.getOwner())) {
            tgtWorkflow.setOwner(ownerMap.get(tgtWorkflow.getOwner()));
        }
        if (!tgtWorkflow.getWorkflowNodes().isEmpty()) {
            for (WorkflowNode workflowNode2 : tgtWorkflow.getWorkflowNodes()) {
                if (!ownerMap.containsKey(workflowNode2.getOwner())) continue;
                workflowNode2.setOwner(ownerMap.get(workflowNode2.getOwner()));
            }
        }
        return tgtWorkflow;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<WorkflowNode> convertSingleNode(Workflow workflow, WorkflowNode workflowNode) {
        log.info("Node Convert In process: {}", (Object)workflowNode.getNodeName());
        ArrayList<WorkflowNode> needConvertNodes = new ArrayList<WorkflowNode>();
        try {
            AbstractConvert<List<WorkflowNode>> convert;
            if (!this.taskContext.getIsUserMx().booleanValue()) {
                needConvertNodes.add(workflowNode);
                convert = this.convertFactory.getNodeListConvert(workflowNode.getNodeType(), this.taskContext, workflow);
                return DataworksConverter.convertAll(convert, needConvertNodes, workflowNode.getNodeId(), workflowNode.getNodeName(), this.taskContext.getStatisticOp().getWorkflowNodeTotalStatisticOp(), this.taskContext.getStatisticOp().getWorkflowNodeSuccessStatisticOp(), this.taskContext.getStatisticOp().getWorkflowNodeFailureStatisticOp());
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)workflowNode.getTempType(), (CharSequence)"custom")) {
                needConvertNodes.add(this.getCustomWorkflowNode(workflowNode));
                convert = this.convertFactory.getCustomNodeConvert(this.taskContext, workflowNode, workflow);
                return DataworksConverter.convertAll(convert, needConvertNodes, workflowNode.getNodeId(), workflowNode.getNodeName(), this.taskContext.getStatisticOp().getWorkflowNodeTotalStatisticOp(), this.taskContext.getStatisticOp().getWorkflowNodeSuccessStatisticOp(), this.taskContext.getStatisticOp().getWorkflowNodeFailureStatisticOp());
            }
            needConvertNodes.add(workflowNode);
            return needConvertNodes;
        }
        catch (Exception e) {
            log.error("get convert error", (Throwable)e);
            this.taskContext.getStatisticOp().getWorkflowNodeTotalStatisticOp().increment(1);
            this.taskContext.getStatisticOp().getWorkflowNodeFailureStatisticOp().incrementFailedOne(workflowNode.getNodeId() + "\u2588" + workflowNode.getNodeName(), e.getMessage());
            return null;
        }
    }

    public Map<String, String> getOwnerMapping(BwmConfiguration bwmConfiguration) {
        String diDsMap = null;
        diDsMap = bwmConfiguration.get("self") != null ? BwmJsonUtil.toJsonString(bwmConfiguration.getMap("self").get("owner.map")) : BwmJsonUtil.toJsonString(bwmConfiguration.getMap("owner.map"));
        if (diDsMap == null) {
            return new HashMap<String, String>();
        }
        try {
            List jsonArray = JSONArray.parseArray((String)diDsMap, AbstractConvert.MigrationOwnerMapping.class);
            HashMap<String, String> ownerMapping = new HashMap<String, String>();
            jsonArray.forEach(mapping -> ownerMapping.put(mapping.getSrc(), mapping.getTgt()));
            return ownerMapping;
        }
        catch (Exception e) {
            log.warn("Cannot get ownerMapping from config, set default value with empty map.");
            return new HashMap<String, String>();
        }
    }
}

