/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.v301;

import java.util.HashMap;
import java.util.Map;

public enum ConditionType {
    NONE(0, "none"),
    JUDGE(1, "judge"),
    DELAY(2, "delay");

    private final int code;
    private final String desc;
    private static final Map<String, ConditionType> CONDITION_TYPE_MAP;

    private ConditionType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public static ConditionType of(String desc) {
        if (CONDITION_TYPE_MAP.containsKey(desc)) {
            return CONDITION_TYPE_MAP.get(desc);
        }
        throw new IllegalArgumentException("invalid type : " + desc);
    }

    static {
        CONDITION_TYPE_MAP = new HashMap<String, ConditionType>();
        for (ConditionType conditionType : ConditionType.values()) {
            CONDITION_TYPE_MAP.put(conditionType.desc, conditionType);
        }
    }
}

