/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.enums;

import com.google.common.base.Functions;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

public enum DbType {
    MYSQL(0, "mysql"),
    POSTGRESQL(1, "postgresql"),
    HIVE(2, "hive"),
    SPARK(3, "spark"),
    CLICKHOUSE(4, "clickhouse"),
    ORACLE(5, "oracle"),
    SQLSERVER(6, "sqlserver"),
    DB2(7, "db2"),
    PRESTO(8, "presto"),
    H2(9, "h2"),
    REDSHIFT(10, "redshift"),
    ATHENA(11, "athena"),
    DLC(12, "DLC");

    private final int code;
    private final String descp;
    private static final Map<Integer, DbType> DB_TYPE_MAP;

    private DbType(int code, String descp) {
        this.code = code;
        this.descp = descp;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescp() {
        return this.descp;
    }

    public static DbType of(int type) {
        if (DB_TYPE_MAP.containsKey(type)) {
            return DB_TYPE_MAP.get(type);
        }
        return null;
    }

    public static DbType ofName(String name) {
        return Arrays.stream(DbType.values()).filter(e -> e.name().equalsIgnoreCase(name)).findFirst().orElseThrow(() -> new NoSuchElementException("no such db type"));
    }

    public boolean isHive() {
        return this == HIVE;
    }

    static {
        DB_TYPE_MAP = Arrays.stream(DbType.values()).collect(Collectors.toMap(DbType::getCode, Functions.identity()));
    }
}

