/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3;

import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.BatchExportProcessDefinitionByIdsRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerApi;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DownloadResourceRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.PaginateResponse;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.QueryDataSourceListByPaginateRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.QueryProcessDefinitionByPaginateRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.QueryResourceListRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.QueryUdfFuncListByPaginateRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.Response;
import com.aliyun.migrationx.common.http.HttpClientUtil;
import com.aliyun.migrationx.common.utils.Config;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DolphinschedulerApiV3Service
implements DolphinSchedulerApi {
    private static final Logger log = LoggerFactory.getLogger(DolphinschedulerApiV3Service.class);
    private static final String HEADER_TOKEN = "token";
    private final String endpoint;
    private final String token;

    public DolphinschedulerApiV3Service(String endpoint, String token) {
        this.endpoint = endpoint;
        this.token = token;
    }

    private HttpGet newHttpGet(String url) throws URISyntaxException {
        HttpGet httpGet = new HttpGet();
        httpGet.setHeader(HEADER_TOKEN, this.token);
        String finalUrl = MessageFormat.format("{0}/dolphinscheduler/{1}", this.endpoint, url);
        httpGet.setURI(new URI(finalUrl));
        return httpGet;
    }

    private HttpPost newHttpPost(String url) throws URISyntaxException {
        HttpPost httpPost = new HttpPost();
        httpPost.setHeader(HEADER_TOKEN, this.token);
        String finalUrl = MessageFormat.format("{0}/dolphinscheduler/{1}", this.endpoint, url);
        httpPost.setURI(new URI(finalUrl));
        return httpPost;
    }

    public PaginateResponse<JsonObject> queryProcessDefinitionByPaging(QueryProcessDefinitionByPaginateRequest request) throws Exception {
        HttpClientUtil client = new HttpClientUtil();
        String url = String.format("projects/%s/process-definition?pageNo=%s&pageSize=%s", request.getProjectCode(), request.getPageNo(), request.getPageSize());
        String responseStr = client.executeAndGet((HttpRequestBase)this.newHttpGet(url));
        return (PaginateResponse)GsonUtils.fromJsonString((String)responseStr, (Type)new TypeToken<PaginateResponse<JsonObject>>(){}.getType());
    }

    @Override
    public String batchExportProcessDefinitionByIds(BatchExportProcessDefinitionByIdsRequest request) throws Exception {
        HttpClientUtil client = new HttpClientUtil();
        String url = String.format("projects/%s/process-definition/batch-export?codes=%s", request.getProjectCode(), Joiner.on((String)",").join((Iterable)ListUtils.emptyIfNull(request.getIds()).stream().distinct().collect(Collectors.toList())));
        return client.executeAndGet((HttpRequestBase)this.newHttpPost(url));
    }

    @Override
    public Response<List<JsonObject>> queryResourceList(QueryResourceListRequest request) throws Exception {
        HttpClientUtil client = new HttpClientUtil();
        String url = String.format("resources/query-by-type?type=%s", request.getType());
        HttpGet httpGet = this.newHttpGet(url);
        String responseStr = client.executeAndGet((HttpRequestBase)httpGet);
        return (Response)GsonUtils.fromJsonString((String)responseStr, (Type)new TypeToken<Response<List<JsonObject>>>(){}.getType());
    }

    @Override
    public List<JsonElement> queryResourceListByPage(QueryResourceListRequest request, int pageNum, int pageSize) throws Exception {
        String url;
        HttpClientUtil client = new HttpClientUtil();
        if (Config.get().isVersion32()) {
            String fullName = request.getFullName() == null ? "" : URLEncoder.encode(request.getFullName());
            url = String.format("resources?type=%s&pageNo=%s&pageSize=%s&fullName=%s&tenantCode=&searchVal=&id=%s", request.getType(), pageNum, pageSize, fullName, request.getDirId());
        } else {
            url = String.format("resources?type=%s&pageNo=%s&pageSize=%s&id=%s", request.getType(), pageNum, pageSize, request.getDirId());
        }
        HttpGet httpGet = this.newHttpGet(url);
        String responseStr = client.executeAndGet((HttpRequestBase)httpGet);
        log.info("response {}", (Object)responseStr);
        Response response = (Response)GsonUtils.fromJsonString((String)responseStr, (Type)new TypeToken<Response<JsonObject>>(){}.getType());
        if (response.getCode() > 0) {
            log.error("response error {}", (Object)responseStr);
            return null;
        }
        JsonObject data = (JsonObject)response.getData();
        if (!data.has("totalList")) {
            log.error("response {}", (Object)responseStr);
            return null;
        }
        return data.get("totalList").getAsJsonArray().asList();
    }

    @Override
    public File downloadResource(DownloadResourceRequest request) throws Exception {
        String url = Config.get().isVersion32() ? String.format("resources/download?fullName=%s", URLEncoder.encode(request.getFullName())) : String.format("resources/%d/download", request.getId());
        HttpClientUtil client = new HttpClientUtil();
        log.info("download resource url: {}", (Object)url);
        HttpGet httpGet = this.newHttpGet(url);
        HttpResponse resp = client.executeAndGetHttpResponse((HttpRequestBase)httpGet);
        if (200 != resp.getStatusLine().getStatusCode()) {
            log.error("response error {}, fullname: {}, url: {}", new Object[]{resp.getStatusLine(), request.getFullName(), url});
            throw new RuntimeException("download file " + url + " error with status " + resp.getStatusLine());
        }
        InputStream inputStream = resp.getEntity().getContent();
        String fileName = Stream.of(resp.getAllHeaders()).filter(header -> StringUtils.equalsIgnoreCase((CharSequence)header.getName(), (CharSequence)"Content-Disposition")).findFirst().map(this::getSuggestedFileName).orElse(null);
        if (StringUtils.isBlank((CharSequence)fileName)) {
            String content = EntityUtils.toString((HttpEntity)resp.getEntity(), (Charset)StandardCharsets.UTF_8);
            Response response = (Response)GsonUtils.fromJsonString((String)content, (Type)new TypeToken<Response<Object>>(){}.getType());
            log.warn("download resource url: {} failed: {}", (Object)url, (Object)Optional.ofNullable(response).map(Response::getMsg).orElse(content));
            return null;
        }
        File tmpFile = new File(request.getDir(), fileName);
        FileOutputStream fileOutputStream = new FileOutputStream(tmpFile);
        IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
        return tmpFile;
    }

    private String getSuggestedFileName(Header contentDispositionHeader) {
        String value = contentDispositionHeader.getValue();
        return Arrays.stream(StringUtils.split((String)value, (String)";")).map(StringUtils::trim).filter(token -> StringUtils.startsWithIgnoreCase((CharSequence)token, (CharSequence)"filename=")).findFirst().map(fileNamePart -> StringUtils.replace((String)fileNamePart, (String)"filename=", (String)"")).map(fileName -> RegExUtils.replaceAll((String)fileName, (String)"^\"", (String)"")).map(fileName -> RegExUtils.replaceAll((String)fileName, (String)"\"$", (String)"")).map(URLDecoder::decode).orElse(null);
    }

    @Override
    public PaginateResponse<JsonObject> queryUdfFuncListByPaging(QueryUdfFuncListByPaginateRequest request) throws Exception {
        HttpClientUtil client = new HttpClientUtil();
        String url = String.format("resources/udf-func?pageNo=%s&pageSize=%s", request.getPageNo(), request.getPageSize());
        HttpGet httpGet = this.newHttpGet(url);
        String responseStr = client.executeAndGet((HttpRequestBase)httpGet);
        return (PaginateResponse)GsonUtils.fromJsonString((String)responseStr, (Type)new TypeToken<PaginateResponse<JsonObject>>(){}.getType());
    }

    @Override
    public PaginateResponse<JsonObject> queryDataSourceListByPaging(QueryDataSourceListByPaginateRequest request) throws Exception {
        HttpClientUtil client = new HttpClientUtil();
        String url = String.format("datasources?pageNo=%s&pageSize=%s", request.getPageNo(), request.getPageSize());
        HttpGet httpGet = this.newHttpGet(url);
        String responseStr = client.executeAndGet((HttpRequestBase)httpGet);
        return (PaginateResponse)GsonUtils.fromJsonString((String)responseStr, (Type)new TypeToken<PaginateResponse<JsonObject>>(){}.getType());
    }

    @Override
    public Response<List<JsonObject>> queryAllProjectList(DolphinSchedulerRequest request) throws Exception {
        HttpClientUtil client = new HttpClientUtil();
        String url = "projects/list";
        HttpGet httpGet = this.newHttpGet(url);
        String responseStr = client.executeAndGet((HttpRequestBase)httpGet);
        return (Response)GsonUtils.fromJsonString((String)responseStr, (Type)new TypeToken<Response<List<JsonObject>>>(){}.getType());
    }
}

