/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task;

import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.enums.Direct;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.process.Property;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.process.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.IParameters;
import com.aliyun.migrationx.common.utils.JSONUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractParameters
implements IParameters {
    public List<Property> localParams;
    public List<Property> varPool;

    @Override
    public abstract boolean checkParameters();

    @Override
    public abstract List<ResourceInfo> getResourceFilesList();

    public List<Property> getLocalParams() {
        return this.localParams;
    }

    public void setLocalParams(List<Property> localParams) {
        this.localParams = localParams;
    }

    public Map<String, Property> getLocalParametersMap() {
        if (this.localParams != null) {
            LinkedHashMap<String, Property> localParametersMaps = new LinkedHashMap<String, Property>();
            for (Property property : this.localParams) {
                localParametersMaps.put(property.getProp(), property);
            }
            return localParametersMaps;
        }
        return null;
    }

    public Map<String, Property> getVarPoolMap() {
        if (this.varPool != null) {
            LinkedHashMap<String, Property> varPoolMap = new LinkedHashMap<String, Property>();
            for (Property property : this.varPool) {
                varPoolMap.put(property.getProp(), property);
            }
            return varPoolMap;
        }
        return null;
    }

    public List<Property> getVarPool() {
        return this.varPool;
    }

    public void setVarPool(String varPool) {
        this.varPool = StringUtils.isEmpty((String)varPool) ? new ArrayList<Property>() : JSONUtils.toList((String)varPool, Property.class);
    }

    public void dealOutParam(String result) {
        if (CollectionUtils.isEmpty(this.localParams)) {
            return;
        }
        List<Property> outProperty = this.getOutProperty(this.localParams);
        if (CollectionUtils.isEmpty(outProperty)) {
            return;
        }
        if (StringUtils.isEmpty((String)result)) {
            this.varPool.addAll(outProperty);
            return;
        }
        Map<String, String> taskResult = AbstractParameters.getMapByString(result);
        if (taskResult == null || taskResult.size() == 0) {
            return;
        }
        for (Property info : outProperty) {
            info.setValue(taskResult.get(info.getProp()));
            this.varPool.add(info);
        }
    }

    public List<Property> getOutProperty(List<Property> params) {
        if (CollectionUtils.isEmpty(params)) {
            return new ArrayList<Property>();
        }
        ArrayList<Property> result = new ArrayList<Property>();
        for (Property info : params) {
            if (info.getDirect() != Direct.OUT) continue;
            result.add(info);
        }
        return result;
    }

    public List<Map<String, String>> getListMapByString(String json) {
        ArrayList<Map<String, String>> allParams = new ArrayList<Map<String, String>>();
        ArrayNode paramsByJson = JSONUtils.parseArray((String)json);
        Iterator listIterator = paramsByJson.iterator();
        while (listIterator.hasNext()) {
            Map param = (Map)JSONUtils.parseObject((String)((JsonNode)listIterator.next()).toString(), (TypeReference)new TypeReference<Map<String, String>>(){});
            allParams.add(param);
        }
        return allParams;
    }

    public static Map<String, String> getMapByString(String result) {
        String[] formatResult = result.split("\\$VarPool\\$");
        HashMap<String, String> format = new HashMap<String, String>();
        for (String info : formatResult) {
            if (StringUtils.isEmpty((String)info) || !info.contains("=")) continue;
            String[] keyValue = info.split("=");
            format.put(keyValue[0], keyValue[1]);
        }
        return format;
    }
}

