/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.utils;

import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.utils.PropertyPlaceholderHelper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaceholderUtils {
    private static final Logger logger = LoggerFactory.getLogger(PlaceholderUtils.class);
    public static final String PLACEHOLDER_PREFIX = "${";
    public static final String PLACEHOLDER_SUFFIX = "}";

    public static String replacePlaceholders(String value, Map<String, String> paramsMap, boolean ignoreUnresolvablePlaceholders) {
        PropertyPlaceholderHelper strictHelper = PlaceholderUtils.getPropertyPlaceholderHelper(false);
        PropertyPlaceholderHelper nonStrictHelper = PlaceholderUtils.getPropertyPlaceholderHelper(true);
        PropertyPlaceholderHelper helper = ignoreUnresolvablePlaceholders ? nonStrictHelper : strictHelper;
        return helper.replacePlaceholders(value, new PropertyPlaceholderResolver(value, paramsMap));
    }

    public static PropertyPlaceholderHelper getPropertyPlaceholderHelper(boolean ignoreUnresolvablePlaceholders) {
        return new PropertyPlaceholderHelper(PLACEHOLDER_PREFIX, PLACEHOLDER_SUFFIX, null, ignoreUnresolvablePlaceholders);
    }

    private static class PropertyPlaceholderResolver
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private final String value;
        private final Map<String, String> paramsMap;

        public PropertyPlaceholderResolver(String value, Map<String, String> paramsMap) {
            this.value = value;
            this.paramsMap = paramsMap;
        }

        @Override
        public String resolvePlaceholder(String placeholderName) {
            try {
                return this.paramsMap.get(placeholderName);
            }
            catch (Exception ex) {
                logger.error("resolve placeholder '{}' in [ {} ]", new Object[]{placeholderName, this.value, ex});
                return null;
            }
        }
    }
}

