/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1;

import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.BatchExportProcessDefinitionByIdsRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerApi;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DownloadResourceRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.PaginateResponse;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.QueryDataSourceListByPaginateRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.QueryProcessDefinitionByPaginateRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.QueryResourceListRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.QueryUdfFuncListByPaginateRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.Response;
import com.aliyun.migrationx.common.http.HttpClientUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DolphinSchedulerApiService
implements DolphinSchedulerApi {
    private static final Logger log = LoggerFactory.getLogger(DolphinSchedulerApiService.class);
    private final String endpoint;
    private final String token;

    public DolphinSchedulerApiService(String endpoint, String token) {
        this.endpoint = endpoint;
        this.token = token;
    }

    public PaginateResponse<JsonObject> queryProcessDefinitionByPaging(QueryProcessDefinitionByPaginateRequest request) throws Exception {
        HttpClientUtil client = new HttpClientUtil();
        HttpGet httpGet = new HttpGet();
        httpGet.setHeader("token", this.token);
        String url = MessageFormat.format("{0}/dolphinscheduler/projects/{1}/process/list-paging?pageNo={2}&pageSize={3}", this.endpoint, request.getProjectName(), String.valueOf(request.getPageNo()), String.valueOf(request.getPageSize()));
        httpGet.setURI(new URI(url));
        String responseStr = client.executeAndGet((HttpRequestBase)httpGet);
        return (PaginateResponse)GsonUtils.fromJsonString((String)responseStr, (Type)new TypeToken<PaginateResponse<JsonObject>>(){}.getType());
    }

    @Override
    public String batchExportProcessDefinitionByIds(BatchExportProcessDefinitionByIdsRequest request) throws Exception {
        HttpClientUtil client = new HttpClientUtil();
        HttpGet httpGet = new HttpGet();
        httpGet.setHeader("token", this.token);
        String url = String.format("%s/dolphinscheduler/projects/%s/process/export?processDefinitionIds=%s", this.endpoint, request.getProjectName(), Joiner.on((String)",").join((Iterable)ListUtils.emptyIfNull(request.getIds()).stream().distinct().collect(Collectors.toList())));
        httpGet.setURI(new URI(url));
        return client.executeAndGet((HttpRequestBase)httpGet);
    }

    @Override
    public Response<List<JsonObject>> queryResourceList(QueryResourceListRequest request) throws Exception {
        HttpClientUtil client = new HttpClientUtil();
        HttpGet httpGet = new HttpGet();
        httpGet.setHeader("token", this.token);
        String url = String.format("%s/dolphinscheduler/resources/list?type=%s", this.endpoint, request.getType());
        httpGet.setURI(new URI(url));
        String responseStr = client.executeAndGet((HttpRequestBase)httpGet);
        return (Response)GsonUtils.fromJsonString((String)responseStr, (Type)new TypeToken<Response<List<JsonObject>>>(){}.getType());
    }

    @Override
    public File downloadResource(DownloadResourceRequest request) throws Exception {
        HttpClientUtil client = new HttpClientUtil();
        HttpGet httpGet = new HttpGet();
        httpGet.setHeader("token", this.token);
        String url = String.format("%s/dolphinscheduler/resources/download?id=%s", this.endpoint, request.getId());
        httpGet.setURI(new URI(url));
        HttpResponse resp = client.executeAndGetHttpResponse((HttpRequestBase)httpGet);
        InputStream inputStream = resp.getEntity().getContent();
        String fileName = Stream.of(resp.getAllHeaders()).filter(header -> StringUtils.equalsIgnoreCase((CharSequence)header.getName(), (CharSequence)"Content-Disposition")).findFirst().map(this::getSuggestedFileName).orElse(null);
        if (StringUtils.isBlank((CharSequence)fileName)) {
            String content = EntityUtils.toString((HttpEntity)resp.getEntity(), (Charset)StandardCharsets.UTF_8);
            Response response = (Response)GsonUtils.fromJsonString((String)content, (Type)new TypeToken<Response<Object>>(){}.getType());
            log.warn("download resource id: {} failed: {}", (Object)request.getId(), (Object)Optional.ofNullable(response).map(Response::getMsg).orElse(content));
            return null;
        }
        File tmpFile = new File(FileUtils.getTempDirectory(), fileName);
        FileOutputStream fileOutputStream = new FileOutputStream(tmpFile);
        IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
        return tmpFile;
    }

    @Override
    public PaginateResponse<JsonObject> queryUdfFuncListByPaging(QueryUdfFuncListByPaginateRequest request) throws Exception {
        HttpClientUtil client = new HttpClientUtil();
        HttpGet httpGet = new HttpGet();
        httpGet.setHeader("token", this.token);
        String url = String.format("%s/dolphinscheduler/resources/udf-func/list-paging?pageNo=%s&pageSize=%s", this.endpoint, request.getPageNo(), request.getPageSize());
        httpGet.setURI(new URI(url));
        String responseStr = client.executeAndGet((HttpRequestBase)httpGet);
        return (PaginateResponse)GsonUtils.fromJsonString((String)responseStr, (Type)new TypeToken<PaginateResponse<JsonObject>>(){}.getType());
    }

    @Override
    public PaginateResponse<JsonObject> queryDataSourceListByPaging(QueryDataSourceListByPaginateRequest request) throws Exception {
        HttpClientUtil client = new HttpClientUtil();
        HttpGet httpGet = new HttpGet();
        httpGet.setHeader("token", this.token);
        String url = String.format("%s/dolphinscheduler/datasources/list-paging?pageNo=%s&pageSize=%s", this.endpoint, request.getPageNo(), request.getPageSize());
        httpGet.setURI(new URI(url));
        String responseStr = client.executeAndGet((HttpRequestBase)httpGet);
        return (PaginateResponse)GsonUtils.fromJsonString((String)responseStr, (Type)new TypeToken<PaginateResponse<JsonObject>>(){}.getType());
    }

    @Override
    public Response<List<JsonObject>> queryAllProjectList(DolphinSchedulerRequest request) throws Exception {
        HttpClientUtil client = new HttpClientUtil();
        HttpGet httpGet = new HttpGet();
        httpGet.setHeader("token", this.token);
        String url = String.format("%s/dolphinscheduler/projects/query-project-list", this.endpoint);
        httpGet.setURI(new URI(url));
        String responseStr = client.executeAndGet((HttpRequestBase)httpGet);
        return (Response)GsonUtils.fromJsonString((String)responseStr, (Type)new TypeToken<Response<List<JsonObject>>>(){}.getType());
    }

    private String getSuggestedFileName(Header contentDispositionHeader) {
        String value = contentDispositionHeader.getValue();
        return Arrays.stream(StringUtils.split((String)value, (String)";")).map(StringUtils::trim).filter(token -> StringUtils.startsWithIgnoreCase((CharSequence)token, (CharSequence)"filename=")).findFirst().map(fileNamePart -> StringUtils.replace((String)fileNamePart, (String)"filename=", (String)"")).map(fileName -> RegExUtils.replaceAll((String)fileName, (String)"^\"", (String)"")).map(fileName -> RegExUtils.replaceAll((String)fileName, (String)"\"$", (String)"")).orElse(null);
    }
}

