/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.domain.constant;

public enum TaskConversionStatusEnum {
    CONVERSION_STATUS_NOT_START("\u8f6c\u6362\u672a\u5f00\u59cb", 0, "NOT_START"),
    CONVERSION_STATUS_READY("\u5f85\u8f6c\u6362", 1, "READY"),
    CONVERSION_STATUS_RUNNING("\u8f6c\u6362\u4e2d", 2, "RUNNING"),
    CONVERSION_STATUS_ALL_SUCCESS("\u8f6c\u6362\u5168\u90e8\u6210\u529f", 3, "ALL_SUCCESS"),
    CONVERSION_STATUS_PARTIAL_SUCCESS("\u8f6c\u6362\u90e8\u5206\u6210\u529f", 4, "PARTIAL_SUCCESS"),
    CONVERSION_STATUS_FAILURE("\u8f6c\u6362\u5931\u8d25", 5, "FAILURE"),
    CONVERSION_STATUS_MANUAL("\u624b\u52a8\u4e0a\u4f20", 6, "MANUAL");

    private final String name;
    private final int statusCode;
    private final String statusName;

    private TaskConversionStatusEnum(String name, int statusCode, String statusName) {
        this.name = name;
        this.statusCode = statusCode;
        this.statusName = statusName;
    }

    public String getName() {
        return this.name;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusName() {
        return this.statusName;
    }

    public static TaskConversionStatusEnum codeOf(int statusCode) {
        for (TaskConversionStatusEnum value : TaskConversionStatusEnum.values()) {
            if (value.getStatusCode() != statusCode) continue;
            return value;
        }
        return CONVERSION_STATUS_NOT_START;
    }

    public static TaskConversionStatusEnum nameOf(String statusName) {
        for (TaskConversionStatusEnum value : TaskConversionStatusEnum.values()) {
            if (!value.getStatusName().equalsIgnoreCase(statusName)) continue;
            return value;
        }
        return CONVERSION_STATUS_NOT_START;
    }
}

