/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migrationx.common.utils;

import com.aliyun.migrationx.common.utils.JSONUtils;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFileUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonFileUtils.class);

    public static List<JsonNode> readJsonLines(File file) throws IOException {
        try (FileInputStream in = JsonFileUtils.openInputStream(file);){
            List<JsonNode> list = JsonFileUtils.readJsonLines(in, null);
            return list;
        }
    }

    public static List<JsonNode> readJsonLines(File file, String key) throws IOException {
        try (FileInputStream in = JsonFileUtils.openInputStream(file);){
            List<JsonNode> list = JsonFileUtils.readJsonLines(in, key);
            return list;
        }
    }

    public static List<JsonNode> readJsonLines(InputStream input, String key) throws IOException {
        return JsonFileUtils.readJsonLines(input, key, StandardCharsets.UTF_8);
    }

    public static List<JsonNode> readJsonLines(InputStream input, String key, Charset charset) throws IOException {
        InputStreamReader reader = new InputStreamReader(input, Charsets.toCharset((Charset)charset));
        return JsonFileUtils.readJsonLines(reader, key);
    }

    public static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static List<JsonNode> readJsonLines(Reader input, String key) throws IOException {
        BufferedReader reader = JsonFileUtils.toBufferedReader(input);
        ArrayList<JsonNode> list = new ArrayList<JsonNode>();
        String line = reader.readLine();
        while (line != null) {
            JsonNode jsonNode = JSONUtils.toJsonNode(line);
            if (StringUtils.isNotEmpty((CharSequence)key)) {
                if (jsonNode.has(key)) {
                    JsonNode taskNode = jsonNode.get(key);
                    list.add(taskNode);
                }
            } else {
                list.add(jsonNode);
            }
            line = reader.readLine();
        }
        return list;
    }

    public static BufferedReader toBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static JsonParser buildJsonParser(InputStream inputStream) {
        try {
            return new JsonFactory().createParser(inputStream);
        }
        catch (IOException e) {
            log.error("create json parser error: {}", (Object)e.getLocalizedMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }
}

