/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migrationx.common.metrics;

import com.aliyun.migrationx.common.metrics.DolphinMetrics;
import com.aliyun.migrationx.common.metrics.Metrics;
import com.aliyun.migrationx.common.metrics.MetricsCollector;
import com.aliyun.migrationx.common.metrics.Progress;
import com.aliyun.migrationx.common.metrics.enums.CollectorType;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DolphinMetricsCollector
implements MetricsCollector {
    private static final Logger log = LoggerFactory.getLogger(DolphinMetricsCollector.class);
    private static final Gson GSON = new Gson();
    public static String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final Gson PrettyGson = new GsonBuilder().setDateFormat(DATE_FORMAT).setPrettyPrinting().create();
    private final List<Metrics> metricsList = new ArrayList<Metrics>();
    private int totalTasks;
    private final Map<String, List<Metrics>> workflowNameMap = new HashMap<String, List<Metrics>>();
    private final Set<Metrics> successDolphinSchedulerTasks = new HashSet<Metrics>();
    private final Set<Metrics> failedDolphinSchedulerTasks = new HashSet<Metrics>();
    private final Set<Metrics> skippedDolphinSchedulerTasks = new HashSet<Metrics>();
    private final Set<Metrics> tempDolphinSchedulerTasks = new HashSet<Metrics>();
    private final Set<Metrics> unSupportedDolphinSchedulerTasks = new HashSet<Metrics>();
    private final Map<String, Integer> typeCounter = new HashMap<String, Integer>();
    private String transformerType;
    private Date startTime;
    private Consumer<Metrics> defaultMetricsConsumer = metrics -> metricsLogger.info("{}", (Object)GSON.toJson(metrics));

    public DolphinMetricsCollector() {
        this.startTime = new Date();
    }

    @Override
    public void setMetricsConsumer(Consumer<Metrics> consumer) {
        this.defaultMetricsConsumer = consumer;
    }

    @Override
    public void setTransformerType(String type) {
        this.transformerType = type;
    }

    @Override
    public void setTotalTasks(int total) {
        this.totalTasks = total;
    }

    @Override
    public synchronized void markSuccessMiddleProcess(Metrics metrics) {
        this.metricsList.add(metrics);
        List<Metrics> metricsList = this.workflowNameMap.get(metrics.getWorkflowName());
        if (metricsList == null) {
            this.workflowNameMap.put(metrics.getWorkflowName(), new ArrayList());
        }
        this.workflowNameMap.get(metrics.getWorkflowName()).add(metrics);
    }

    @Override
    public synchronized void markFailedMiddleProcess(Metrics metrics) {
        this.failedDolphinSchedulerTasks.add(metrics);
    }

    @Override
    public void markSuccessSpecProcess(String workflowName, String nodeName) {
        Metrics metrics = new Metrics();
        metrics.setWorkflowName(workflowName);
        metrics.setDwName(nodeName);
        this.markSuccessSpecProcess(metrics);
    }

    @Override
    public synchronized void markSuccessSpecProcess(Metrics tmp) {
        this.markSuccessSpecProcess(tmp, this.defaultMetricsConsumer);
    }

    @Override
    public synchronized void markSuccessSpecProcess(Metrics tmp, Consumer<Metrics> c) {
        Metrics metrics = this.findMetrics(tmp);
        if (metrics == null) {
            log.error("print metrics error, workflowName {}, nodeName {}", (Object)tmp.getWorkflowName(), (Object)tmp.getDwName());
            return;
        }
        metrics.setTimestamp(System.currentTimeMillis());
        this.successDolphinSchedulerTasks.add(metrics);
        c.accept(metrics);
    }

    @Override
    public void markFailedSpecProcess(String workflowName, String nodeName) {
        Metrics metrics = new Metrics();
        metrics.setWorkflowName(workflowName);
        metrics.setDwName(nodeName);
        this.markFailedSpecProcess(metrics);
    }

    @Override
    public void markFailedSpecProcess(Metrics tmp) {
        Metrics metrics = this.findMetrics(tmp);
        if (metrics == null) {
            log.error("print metrics error, workflowName {}, nodeName {}", (Object)tmp.getWorkflowName(), (Object)tmp.getDwName());
            return;
        }
        metrics.setTimestamp(System.currentTimeMillis());
        this.failedDolphinSchedulerTasks.add(metrics);
    }

    @Override
    public void markSkippedProcess(Metrics metrics) {
        metrics.setTimestamp(System.currentTimeMillis());
        this.skippedDolphinSchedulerTasks.add(metrics);
    }

    @Override
    public void markTempSpecProcess(String workflowName, String nodeName) {
        Metrics metrics = new Metrics();
        metrics.setWorkflowName(workflowName);
        metrics.setDwName(nodeName);
        this.markTempSpecProcess(metrics);
    }

    @Override
    public void markTempSpecProcess(Metrics tmp) {
        Metrics metrics = this.findMetrics(tmp);
        if (metrics == null) {
            log.error("print metrics error, workflowName {}, nodeName {}", (Object)tmp.getWorkflowName(), (Object)tmp.getDwName());
            return;
        }
        metrics.setTimestamp(System.currentTimeMillis());
        this.tempDolphinSchedulerTasks.add(metrics);
    }

    @Override
    public void markUnSupportedSpecProcess(Metrics metrics) {
        this.unSupportedDolphinSchedulerTasks.add(metrics);
    }

    @Override
    public void incrementType(String taskType) {
        Integer count = this.typeCounter.get(taskType);
        if (count == null) {
            this.typeCounter.put(taskType, 1);
        } else {
            this.typeCounter.put(taskType, count + 1);
        }
    }

    private Metrics findMetrics(Metrics tmp) {
        String workflowName = tmp.getWorkflowName();
        String nodeName = tmp.getDwName();
        List<Metrics> metricsList = this.workflowNameMap.get(workflowName);
        if (metricsList == null) {
            throw new RuntimeException("can not find metrics by " + workflowName);
        }
        Metrics metrics = metricsList.stream().filter(m -> m.getDwName().equals(nodeName)).findAny().orElse(null);
        return metrics;
    }

    @Override
    public void finishCollector() {
        this.finishCollector(summary -> summaryLogger.info("{}", (Object)PrettyGson.toJson(summary)));
    }

    @Override
    public void finishCollector(Consumer<Object> c) {
        Summary summary = new Summary();
        summary.setStartTime(this.startTime);
        summary.setEndTime(new Date());
        summary.setTransformerType(this.transformerType);
        summary.setType(CollectorType.DolphinScheduler.name());
        summary.setTotalSuccess(this.successDolphinSchedulerTasks.size());
        summary.setTotalFailed(this.failedDolphinSchedulerTasks.size());
        summary.setTotalSkipped(this.skippedDolphinSchedulerTasks.size());
        summary.setTotalTemp(this.tempDolphinSchedulerTasks.size());
        summary.setTotalUnSupported(this.unSupportedDolphinSchedulerTasks.size());
        c.accept(summary);
        Detail detail = new Detail();
        detail.setSuccess(this.toSummary(this.successDolphinSchedulerTasks));
        detail.setFailed(this.toSummary(this.failedDolphinSchedulerTasks));
        detail.setSkipped(this.toSummary(this.skippedDolphinSchedulerTasks));
        detail.setTemp(this.toSummary(this.tempDolphinSchedulerTasks));
        detail.setUnSupported(this.toSummary(this.unSupportedDolphinSchedulerTasks));
        detail.setTypeCounter(this.typeCounter);
        c.accept(detail);
    }

    private List<Project> toSummary(Set<Metrics> metricsList) {
        HashMap<Long, Project> projectMap = new HashMap<Long, Project>();
        HashMap<Long, Process> processMap = new HashMap<Long, Process>();
        HashMap<Long, Task> taskMap = new HashMap<Long, Task>();
        for (Metrics m : CollectionUtils.emptyIfNull(metricsList)) {
            Task task;
            Process process;
            DolphinMetrics dolphinMetrics = (DolphinMetrics)m;
            Project project = (Project)projectMap.get(dolphinMetrics.getProjectCode());
            if (project == null) {
                project = new Project();
                project.setProjectName(dolphinMetrics.getProjectName());
                project.setProjectCode(dolphinMetrics.getProjectCode());
                projectMap.put(dolphinMetrics.getProjectCode(), project);
            }
            if ((process = (Process)processMap.get(dolphinMetrics.getProcessCode())) == null) {
                process = new Process();
                process.setProcessCode(dolphinMetrics.getProcessCode());
                process.setProcessName(dolphinMetrics.getProcessName());
                processMap.put(dolphinMetrics.getProcessCode(), process);
                project.getProcesses().add(process);
            }
            if ((task = (Task)taskMap.get(dolphinMetrics.getTaskCode())) != null) continue;
            task = new Task();
            task.setTaskCode(dolphinMetrics.getTaskCode());
            task.setTaskName(dolphinMetrics.getTaskName());
            task.setTaskType(dolphinMetrics.getTaskType());
            taskMap.put(dolphinMetrics.getTaskCode(), task);
            process.getTasks().add(task);
        }
        return new ArrayList<Project>(projectMap.values());
    }

    @Override
    public Progress progress() {
        Progress rate = new Progress();
        rate.setTotal(this.totalTasks);
        AtomicInteger counter = new AtomicInteger(0);
        this.workflowNameMap.values().forEach(s -> s.forEach(ss -> counter.incrementAndGet()));
        rate.setMiddleSuccess(counter.get());
        rate.setSuccess(this.successDolphinSchedulerTasks.size());
        rate.setFailed(this.failedDolphinSchedulerTasks.size());
        rate.setSkipped(this.skippedDolphinSchedulerTasks.size());
        return rate;
    }

    public static class Summary {
        private String type;
        private Date startTime;
        private Date endTime;
        private String transformerType;
        private int totalSuccess;
        private int totalFailed;
        private int totalSkipped;
        private int totalTemp;
        private int totalUnSupported;

        public String getType() {
            return this.type;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public String getTransformerType() {
            return this.transformerType;
        }

        public int getTotalSuccess() {
            return this.totalSuccess;
        }

        public int getTotalFailed() {
            return this.totalFailed;
        }

        public int getTotalSkipped() {
            return this.totalSkipped;
        }

        public int getTotalTemp() {
            return this.totalTemp;
        }

        public int getTotalUnSupported() {
            return this.totalUnSupported;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setStartTime(Date startTime) {
            this.startTime = startTime;
        }

        public void setEndTime(Date endTime) {
            this.endTime = endTime;
        }

        public void setTransformerType(String transformerType) {
            this.transformerType = transformerType;
        }

        public void setTotalSuccess(int totalSuccess) {
            this.totalSuccess = totalSuccess;
        }

        public void setTotalFailed(int totalFailed) {
            this.totalFailed = totalFailed;
        }

        public void setTotalSkipped(int totalSkipped) {
            this.totalSkipped = totalSkipped;
        }

        public void setTotalTemp(int totalTemp) {
            this.totalTemp = totalTemp;
        }

        public void setTotalUnSupported(int totalUnSupported) {
            this.totalUnSupported = totalUnSupported;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Summary)) {
                return false;
            }
            Summary other = (Summary)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTotalSuccess() != other.getTotalSuccess()) {
                return false;
            }
            if (this.getTotalFailed() != other.getTotalFailed()) {
                return false;
            }
            if (this.getTotalSkipped() != other.getTotalSkipped()) {
                return false;
            }
            if (this.getTotalTemp() != other.getTotalTemp()) {
                return false;
            }
            if (this.getTotalUnSupported() != other.getTotalUnSupported()) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Date this$startTime = this.getStartTime();
            Date other$startTime = other.getStartTime();
            if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
                return false;
            }
            Date this$endTime = this.getEndTime();
            Date other$endTime = other.getEndTime();
            if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
                return false;
            }
            String this$transformerType = this.getTransformerType();
            String other$transformerType = other.getTransformerType();
            return !(this$transformerType == null ? other$transformerType != null : !this$transformerType.equals(other$transformerType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Summary;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getTotalSuccess();
            result = result * 59 + this.getTotalFailed();
            result = result * 59 + this.getTotalSkipped();
            result = result * 59 + this.getTotalTemp();
            result = result * 59 + this.getTotalUnSupported();
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Date $startTime = this.getStartTime();
            result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
            Date $endTime = this.getEndTime();
            result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
            String $transformerType = this.getTransformerType();
            result = result * 59 + ($transformerType == null ? 43 : $transformerType.hashCode());
            return result;
        }

        public String toString() {
            return "DolphinMetricsCollector.Summary(type=" + this.getType() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", transformerType=" + this.getTransformerType() + ", totalSuccess=" + this.getTotalSuccess() + ", totalFailed=" + this.getTotalFailed() + ", totalSkipped=" + this.getTotalSkipped() + ", totalTemp=" + this.getTotalTemp() + ", totalUnSupported=" + this.getTotalUnSupported() + ")";
        }
    }

    public static class Detail {
        private List<Project> success;
        private List<Project> failed;
        private List<Project> skipped;
        private List<Project> temp;
        private List<Project> unSupported;
        private Map<String, Integer> typeCounter;

        public List<Project> getSuccess() {
            return this.success;
        }

        public List<Project> getFailed() {
            return this.failed;
        }

        public List<Project> getSkipped() {
            return this.skipped;
        }

        public List<Project> getTemp() {
            return this.temp;
        }

        public List<Project> getUnSupported() {
            return this.unSupported;
        }

        public Map<String, Integer> getTypeCounter() {
            return this.typeCounter;
        }

        public void setSuccess(List<Project> success) {
            this.success = success;
        }

        public void setFailed(List<Project> failed) {
            this.failed = failed;
        }

        public void setSkipped(List<Project> skipped) {
            this.skipped = skipped;
        }

        public void setTemp(List<Project> temp) {
            this.temp = temp;
        }

        public void setUnSupported(List<Project> unSupported) {
            this.unSupported = unSupported;
        }

        public void setTypeCounter(Map<String, Integer> typeCounter) {
            this.typeCounter = typeCounter;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Detail)) {
                return false;
            }
            Detail other = (Detail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Project> this$success = this.getSuccess();
            List<Project> other$success = other.getSuccess();
            if (this$success == null ? other$success != null : !((Object)this$success).equals(other$success)) {
                return false;
            }
            List<Project> this$failed = this.getFailed();
            List<Project> other$failed = other.getFailed();
            if (this$failed == null ? other$failed != null : !((Object)this$failed).equals(other$failed)) {
                return false;
            }
            List<Project> this$skipped = this.getSkipped();
            List<Project> other$skipped = other.getSkipped();
            if (this$skipped == null ? other$skipped != null : !((Object)this$skipped).equals(other$skipped)) {
                return false;
            }
            List<Project> this$temp = this.getTemp();
            List<Project> other$temp = other.getTemp();
            if (this$temp == null ? other$temp != null : !((Object)this$temp).equals(other$temp)) {
                return false;
            }
            List<Project> this$unSupported = this.getUnSupported();
            List<Project> other$unSupported = other.getUnSupported();
            if (this$unSupported == null ? other$unSupported != null : !((Object)this$unSupported).equals(other$unSupported)) {
                return false;
            }
            Map<String, Integer> this$typeCounter = this.getTypeCounter();
            Map<String, Integer> other$typeCounter = other.getTypeCounter();
            return !(this$typeCounter == null ? other$typeCounter != null : !((Object)this$typeCounter).equals(other$typeCounter));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Detail;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Project> $success = this.getSuccess();
            result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
            List<Project> $failed = this.getFailed();
            result = result * 59 + ($failed == null ? 43 : ((Object)$failed).hashCode());
            List<Project> $skipped = this.getSkipped();
            result = result * 59 + ($skipped == null ? 43 : ((Object)$skipped).hashCode());
            List<Project> $temp = this.getTemp();
            result = result * 59 + ($temp == null ? 43 : ((Object)$temp).hashCode());
            List<Project> $unSupported = this.getUnSupported();
            result = result * 59 + ($unSupported == null ? 43 : ((Object)$unSupported).hashCode());
            Map<String, Integer> $typeCounter = this.getTypeCounter();
            result = result * 59 + ($typeCounter == null ? 43 : ((Object)$typeCounter).hashCode());
            return result;
        }

        public String toString() {
            return "DolphinMetricsCollector.Detail(success=" + this.getSuccess() + ", failed=" + this.getFailed() + ", skipped=" + this.getSkipped() + ", temp=" + this.getTemp() + ", unSupported=" + this.getUnSupported() + ", typeCounter=" + this.getTypeCounter() + ")";
        }
    }

    public static class Project {
        private String projectName;
        private Long projectCode;
        private List<Process> processes = new ArrayList<Process>();

        public String getProjectName() {
            return this.projectName;
        }

        public Long getProjectCode() {
            return this.projectCode;
        }

        public List<Process> getProcesses() {
            return this.processes;
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public void setProjectCode(Long projectCode) {
            this.projectCode = projectCode;
        }

        public void setProcesses(List<Process> processes) {
            this.processes = processes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Project)) {
                return false;
            }
            Project other = (Project)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$projectCode = this.getProjectCode();
            Long other$projectCode = other.getProjectCode();
            if (this$projectCode == null ? other$projectCode != null : !((Object)this$projectCode).equals(other$projectCode)) {
                return false;
            }
            String this$projectName = this.getProjectName();
            String other$projectName = other.getProjectName();
            if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
                return false;
            }
            List<Process> this$processes = this.getProcesses();
            List<Process> other$processes = other.getProcesses();
            return !(this$processes == null ? other$processes != null : !((Object)this$processes).equals(other$processes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Project;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $projectCode = this.getProjectCode();
            result = result * 59 + ($projectCode == null ? 43 : ((Object)$projectCode).hashCode());
            String $projectName = this.getProjectName();
            result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
            List<Process> $processes = this.getProcesses();
            result = result * 59 + ($processes == null ? 43 : ((Object)$processes).hashCode());
            return result;
        }

        public String toString() {
            return "DolphinMetricsCollector.Project(projectName=" + this.getProjectName() + ", projectCode=" + this.getProjectCode() + ", processes=" + this.getProcesses() + ")";
        }
    }

    public static class Process {
        private String processName;
        private Long processCode;
        private List<Task> tasks = new ArrayList<Task>();

        public String getProcessName() {
            return this.processName;
        }

        public Long getProcessCode() {
            return this.processCode;
        }

        public List<Task> getTasks() {
            return this.tasks;
        }

        public void setProcessName(String processName) {
            this.processName = processName;
        }

        public void setProcessCode(Long processCode) {
            this.processCode = processCode;
        }

        public void setTasks(List<Task> tasks) {
            this.tasks = tasks;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Process)) {
                return false;
            }
            Process other = (Process)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$processCode = this.getProcessCode();
            Long other$processCode = other.getProcessCode();
            if (this$processCode == null ? other$processCode != null : !((Object)this$processCode).equals(other$processCode)) {
                return false;
            }
            String this$processName = this.getProcessName();
            String other$processName = other.getProcessName();
            if (this$processName == null ? other$processName != null : !this$processName.equals(other$processName)) {
                return false;
            }
            List<Task> this$tasks = this.getTasks();
            List<Task> other$tasks = other.getTasks();
            return !(this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Process;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $processCode = this.getProcessCode();
            result = result * 59 + ($processCode == null ? 43 : ((Object)$processCode).hashCode());
            String $processName = this.getProcessName();
            result = result * 59 + ($processName == null ? 43 : $processName.hashCode());
            List<Task> $tasks = this.getTasks();
            result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
            return result;
        }

        public String toString() {
            return "DolphinMetricsCollector.Process(processName=" + this.getProcessName() + ", processCode=" + this.getProcessCode() + ", tasks=" + this.getTasks() + ")";
        }
    }

    public static class Task {
        private String taskName;
        private Long taskCode;
        private String taskType;

        public String getTaskName() {
            return this.taskName;
        }

        public Long getTaskCode() {
            return this.taskCode;
        }

        public String getTaskType() {
            return this.taskType;
        }

        public void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public void setTaskCode(Long taskCode) {
            this.taskCode = taskCode;
        }

        public void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Task)) {
                return false;
            }
            Task other = (Task)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$taskCode = this.getTaskCode();
            Long other$taskCode = other.getTaskCode();
            if (this$taskCode == null ? other$taskCode != null : !((Object)this$taskCode).equals(other$taskCode)) {
                return false;
            }
            String this$taskName = this.getTaskName();
            String other$taskName = other.getTaskName();
            if (this$taskName == null ? other$taskName != null : !this$taskName.equals(other$taskName)) {
                return false;
            }
            String this$taskType = this.getTaskType();
            String other$taskType = other.getTaskType();
            return !(this$taskType == null ? other$taskType != null : !this$taskType.equals(other$taskType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Task;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $taskCode = this.getTaskCode();
            result = result * 59 + ($taskCode == null ? 43 : ((Object)$taskCode).hashCode());
            String $taskName = this.getTaskName();
            result = result * 59 + ($taskName == null ? 43 : $taskName.hashCode());
            String $taskType = this.getTaskType();
            result = result * 59 + ($taskType == null ? 43 : $taskType.hashCode());
            return result;
        }

        public String toString() {
            return "DolphinMetricsCollector.Task(taskName=" + this.getTaskName() + ", taskCode=" + this.getTaskCode() + ", taskType=" + this.getTaskType() + ")";
        }
    }
}

