/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migrationx.common.http;

import com.aliyun.migrationx.common.utils.ExecuteUtils;
import java.net.SocketException;
import java.nio.charset.Charset;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtil.class);
    private static final int TIMEOUT_SECONDS = 60;
    private HttpClient httpClient = HttpClientBuilder.create().build();

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String executeAndGet(final HttpRequestBase httpRequestBase, final int retry, int retryInterval) throws Exception {
        return ExecuteUtils.executeWithRetry(new ExecuteUtils.ExecuteCommand<String>(){

            @Override
            public String run() throws Exception {
                return HttpClientUtil.this.executeAndGet(httpRequestBase, this.getRetryCount() < retry);
            }

            @Override
            public boolean isRetry(Exception e) {
                return e instanceof SocketException;
            }
        }, retry, retryInterval);
    }

    public String executeAndGet(HttpRequestBase httpRequestBase) throws Exception {
        return this.executeAndGet(httpRequestBase, 1, 1000);
    }

    public String executeAndGet(HttpRequestBase httpRequestBase, boolean retry) throws Exception {
        String responseString;
        block11: {
            if (httpRequestBase == null) {
                throw new IllegalArgumentException("'http Request' can't be null");
            }
            Long start = System.currentTimeMillis();
            try {
                RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).setConnectionRequestTimeout(60000).build();
                httpRequestBase.setConfig(requestConfig);
                log.info("request url: {}, method: {}", (Object)httpRequestBase.getURI(), (Object)httpRequestBase.getMethod());
                HttpResponse response = this.httpClient.execute((HttpUriRequest)httpRequestBase);
                if (response.getStatusLine().getStatusCode() != 200) {
                    log.info("request url: {}, method: {}, status code: {}", new Object[]{httpRequestBase.getURI(), httpRequestBase.getMethod(), response.getStatusLine().getStatusCode()});
                    if (response.getStatusLine().getStatusCode() == 500) {
                        HttpEntity entity = response.getEntity();
                        if (entity != null) {
                            responseString = EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
                            break block11;
                        }
                        throw new Exception("Response Code Is 500, Response Entity Is Null");
                    }
                    throw new Exception("Response Status Code : " + response.getStatusLine().getStatusCode());
                }
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    responseString = EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
                    break block11;
                }
                throw new Exception("Response Code Is 200, Response Entity Is Null");
            }
            catch (Throwable e) {
                log.warn("HttpClientUtil executeAndGet error : ", e);
                throw e;
            }
            finally {
                Long end = System.currentTimeMillis();
                log.info("url: {}, time costed: {} seconds", (Object)httpRequestBase.getURI(), (Object)((end - start) / 1000L));
                if (!retry) {
                    httpRequestBase.releaseConnection();
                    this.httpClient = null;
                }
            }
        }
        return responseString;
    }

    public HttpResponse executeAndGetHttpResponse(HttpRequestBase httpRequestBase) throws Exception {
        if (httpRequestBase == null) {
            throw new IllegalArgumentException("'http Request' can't be null");
        }
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).setConnectionRequestTimeout(60000).build();
        httpRequestBase.setConfig(requestConfig);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)httpRequestBase);
        return response;
    }
}

