/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.openapi.converter;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.RerunMode;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.CronExpressUtil;
import com.aliyun.migration.api.constant.BwmCommonConstant;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.common.utils.CronUtils;
import com.aliyun.migration.workflow.migration.common.utils.CustomCreateFileRequest;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.AbstractDwNodeConverter;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConverter
extends AbstractDwNodeConverter {
    private static final Logger log = LoggerFactory.getLogger(DefaultConverter.class);
    private String defaultPath = "\u4e1a\u52a1\u6d41\u7a0b/%s/%s/";
    private CodeProgramType defaultNodeType = CodeProgramType.VIRTUAL;

    public DefaultConverter() {
    }

    public DefaultConverter(BwmConfiguration taskContextConf) {
        this.taskContextConf = taskContextConf;
    }

    @Override
    public CustomCreateFileRequest convert(WorkflowNode workflowNode) {
        if (Objects.isNull(this.taskContextConf)) {
            this.taskContextConf = BwmConfiguration.newDefault();
        }
        if (workflowNode.getCustomProperties() == null) {
            workflowNode.setCustomProperties(new HashMap());
        }
        if (workflowNode.getRuntimeResource() == null) {
            workflowNode.setRuntimeResource(new HashMap());
        }
        if (workflowNode.getParentTargetIds() == null) {
            workflowNode.setParentTargetIds(new ArrayList());
        }
        CustomCreateFileRequest customCreateFileRequest = new CustomCreateFileRequest();
        customCreateFileRequest.setActionName("CreateFile");
        try {
            customCreateFileRequest.setProjectId(Long.valueOf(Long.parseLong(workflowNode.getProjectId())));
            customCreateFileRequest.setProjectIdentifier(workflowNode.getProjectId());
            customCreateFileRequest.setFileName(workflowNode.getNodeName());
            if (StringUtils.isNumeric((CharSequence)workflowNode.getNodeType())) {
                customCreateFileRequest.setFileType(Integer.valueOf(Integer.parseInt(workflowNode.getNodeType())));
            } else {
                customCreateFileRequest.setFileType(Integer.valueOf(this.defaultNodeType.getCode()));
            }
            customCreateFileRequest.setFileFolderPath(String.format(this.defaultPath, workflowNode.getWorkflowName(), CodeProgramType.getNodeTypeByCode((int)customCreateFileRequest.getFileType()).getCalcEngineType().getNameCn()));
        }
        catch (Exception e) {
            log.error("Some nessary fields are missing in workflow node: {}", (Object)workflowNode.getNodeName());
            throw new RuntimeException(e);
        }
        if (workflowNode.getDescription() != null) {
            customCreateFileRequest.setFileDescription(workflowNode.getDescription());
        }
        if (workflowNode.getScript() != null) {
            customCreateFileRequest.setContent(workflowNode.getScript());
        }
        customCreateFileRequest.setRerunMode(RerunMode.getByValue((int)((Integer)this.taskContextConf.getValue("rerun.mode", (Object)((Integer)workflowNode.getCustomProperties().get("rerun.mode")), (Object)BwmCommonConstant.Dataworks.RERUN_MODE_DEFAULT, Integer.class, BwmServiceErrorCode.CONFIG_ERROR))).name());
        customCreateFileRequest.setParaValue(this.para2String(workflowNode.getParamMap()));
        if (workflowNode.getTrigger() != null) {
            customCreateFileRequest.setStartEffectDate(this.localDatetime2Long(workflowNode.getTrigger().getStartTime()));
            customCreateFileRequest.setEndEffectDate(this.localDatetime2Long(workflowNode.getTrigger().getEndTime()));
            if (customCreateFileRequest.getStartEffectDate() != null && customCreateFileRequest.getEndEffectDate() != null) {
                if (customCreateFileRequest.getStartEffectDate() > customCreateFileRequest.getEndEffectDate()) {
                    customCreateFileRequest.setEndEffectDate(customCreateFileRequest.getStartEffectDate());
                }
                LocalDateTime maxDateTime = LocalDateTime.of(9999, 1, 1, 0, 0, 0);
                if (Objects.nonNull(workflowNode.getTrigger().getEndTime()) && workflowNode.getTrigger().getEndTime().isAfter(maxDateTime)) {
                    customCreateFileRequest.setEndEffectDate(this.localDatetime2Long(maxDateTime));
                }
                if (Objects.nonNull(workflowNode.getTrigger().getStartTime()) && workflowNode.getTrigger().getStartTime().isAfter(maxDateTime)) {
                    customCreateFileRequest.setStartEffectDate(this.localDatetime2Long(maxDateTime));
                }
            }
            customCreateFileRequest.setCronExpress(workflowNode.getTrigger().getCron());
            if (customCreateFileRequest.getCronExpress() != null) {
                String formatCronExpression = CronUtils.formatCronExpression((String)customCreateFileRequest.getCronExpress());
                customCreateFileRequest.setCronExpress(formatCronExpression);
                switch (CronExpressUtil.parseCronToCycleType((String)customCreateFileRequest.getCronExpress())) {
                    case 0: {
                        customCreateFileRequest.setCycleType("DAY");
                        break;
                    }
                    case 1: {
                        customCreateFileRequest.setCycleType("NOT_DAY");
                    }
                }
                if (customCreateFileRequest.getCronExpress().contains(" ? * ")) {
                    customCreateFileRequest.setCycleType("DAY");
                }
                if (customCreateFileRequest.getCronExpress().endsWith(" ?") && !customCreateFileRequest.getCronExpress().endsWith("* ?")) {
                    customCreateFileRequest.setCycleType("DAY");
                }
            }
        } else {
            customCreateFileRequest.setCycleType("DAY");
        }
        customCreateFileRequest.setAutoRerunTimes((Integer)this.taskContextConf.getValue("auto.rerun.times", (Object)((Integer)workflowNode.getCustomProperties().get("auto.rerun.times")), (Object)BwmCommonConstant.Dataworks.AUTO_RERUN_TIMES_DEFAULT, Integer.class, BwmServiceErrorCode.CONFIG_ERROR));
        customCreateFileRequest.setAutoRerunIntervalMillis((Integer)this.taskContextConf.getValue("auto.rerun.interval.millis", (Object)((Integer)workflowNode.getCustomProperties().get("auto.rerun.interval.millis")), (Object)BwmCommonConstant.Dataworks.AUTO_RERUN_INTERVAL_MILLIS_DEFAULT, Integer.class, BwmServiceErrorCode.CONFIG_ERROR));
        customCreateFileRequest.setStop((Boolean)this.taskContextConf.getValue("stop", (Object)((Boolean)workflowNode.getCustomProperties().get("stop")), (Object)BwmCommonConstant.Dataworks.STOP_DEFAULT, Boolean.class, BwmServiceErrorCode.CONFIG_ERROR));
        customCreateFileRequest.setDependentType((String)this.taskContextConf.getValue("dependent.type", (Object)((String)workflowNode.getCustomProperties().get("dependent.type")), (Object)"NONE", String.class, BwmServiceErrorCode.CONFIG_ERROR));
        customCreateFileRequest.setResourceGroupIdentifier((String)this.taskContextConf.getValue("resource.group.identifier", (Object)((String)workflowNode.getRuntimeResource().get("resource.group.identifier")), (Object)"", String.class, BwmServiceErrorCode.CONFIG_ERROR));
        customCreateFileRequest.setAutoParsing((Boolean)this.taskContextConf.getValue("auto.parsing", (Object)((Boolean)workflowNode.getCustomProperties().get("auto.parsing")), (Object)BwmCommonConstant.Dataworks.AUTO_PARSING_DEFAULT, Boolean.class, BwmServiceErrorCode.CONFIG_ERROR));
        customCreateFileRequest.setSchedulerType((String)this.taskContextConf.getValue("scheduler.type", (Object)(workflowNode.getState() != null ? workflowNode.getState().name() : null), (Object)"NORMAL", String.class, BwmServiceErrorCode.CONFIG_ERROR));
        customCreateFileRequest.setStartImmediately((Boolean)this.taskContextConf.getValue("startImmediately", (Object)((Boolean)workflowNode.getCustomProperties().get("startImmediately")), (Object)BwmCommonConstant.Dataworks.START_IMMEDIATELY_DEFAULT, Boolean.class, BwmServiceErrorCode.CONFIG_ERROR));
        customCreateFileRequest.setIgnoreParentSkipRunningProperty((Boolean)this.taskContextConf.getValue("ignore.parent.skip.running.property", (Object)((Boolean)workflowNode.getCustomProperties().get("ignore.parent.skip.running.property")), (Object)BwmCommonConstant.Dataworks.IGNORE_PARENT_SKIP_RUNNING_PROPERTY_DEFAULT, Boolean.class, BwmServiceErrorCode.CONFIG_ERROR));
        customCreateFileRequest.setCreateFolderIfNotExists(Boolean.valueOf(true));
        this.setInputList(workflowNode.getProjectName(), workflowNode, customCreateFileRequest);
        return customCreateFileRequest;
    }

    private String para2String(Map<String, Object> paraMap) {
        if (paraMap == null || paraMap.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : paraMap.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append(" ");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private String datasource2String(List<Datasource> datasourceList) {
        if (datasourceList == null || datasourceList.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Datasource datasource : datasourceList) {
            sb.append(datasource.getName()).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private Long localDatetime2Long(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        try {
            return localDateTime.toInstant(ZoneOffset.ofTotalSeconds(0)).toEpochMilli();
        }
        catch (Exception e) {
            log.error("invalid start time in node");
            return null;
        }
    }
}

