/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.openapi.converter;

import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migration.workflow.migration.common.utils.CustomCreateFileRequest;
import com.aliyun.migration.workflow.migration.dw.openapi.common.DwCommonUtil;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.AbstractDwNodeConverter;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.DefaultConverter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DIConverter
extends AbstractDwNodeConverter {
    private static final Logger log = LoggerFactory.getLogger(DIConverter.class);
    private static final String DEFAULT_PATH = "\u4e1a\u52a1\u6d41\u7a0b/%s/\u6570\u636e\u96c6\u6210";

    @Override
    public CustomCreateFileRequest convert(WorkflowNode workflowNode) {
        DefaultConverter defaultConverter = new DefaultConverter(this.taskContextConf);
        CustomCreateFileRequest request = defaultConverter.convert(workflowNode);
        request.setActionName("CreateDISyncTask");
        request.setProjectId(Long.valueOf(Long.parseLong(workflowNode.getProjectId())));
        request.setTaskName(workflowNode.getNodeName());
        request.setTaskContext(workflowNode.getScript());
        String folderPath = String.format(DEFAULT_PATH, workflowNode.getWorkflowName());
        request.setFolderPath(folderPath);
        request.setFileFolderPath(folderPath);
        request.setTaskType("DI_OFFLINE");
        request.setNodeType(DwCommonUtil.getType(workflowNode.getNodeType()));
        String prefixPath = workflowNode.getScriptPathPreFix();
        request.setPrefixPath(prefixPath);
        workflowNode.setScriptPath(StringUtils.trim((String)workflowNode.getScriptPath()));
        request.setFileName(workflowNode.getNodeName());
        request.setTaskContext(workflowNode.getScript());
        Map configMap = (Map)BwmJsonUtil.parseObject((String)this.taskContextConf.toJSON(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        Object diResourceGroupFromNode = ((Map)Optional.ofNullable(configMap).orElse(new HashMap())).get("di.resource.group.identifier");
        if (Objects.isNull(diResourceGroupFromNode) || StringUtils.isBlank((String)diResourceGroupFromNode.toString())) {
            diResourceGroupFromNode = ((Map)Optional.ofNullable(workflowNode.getRuntimeResource()).orElse(new HashMap())).get("di.resource.group.identifier");
        }
        if (Objects.isNull(diResourceGroupFromNode)) {
            log.error("not.config.di.resource.group");
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.CONFIG_ERROR, (String)"not.config.di.resource.group");
        }
        Float cu = Float.valueOf(0.5f);
        if (Objects.nonNull(configMap) && Objects.nonNull(configMap.get("workflow.di.cu"))) {
            cu = Float.valueOf(Float.parseFloat(configMap.get("workflow.di.cu").toString()));
        } else if (workflowNode.getRuntimeResource() != null && workflowNode.getRuntimeResource().containsKey("workflow.di.cu")) {
            cu = Float.valueOf(Float.parseFloat(((String)workflowNode.getRuntimeResource().get("workflow.di.cu")).toString()));
        }
        ObjectNode diParam = BwmJsonUtil.getDefaultObjectMapper().createObjectNode();
        diParam.put("FileFolderPath", folderPath);
        diParam.put("ResourceGroup", diResourceGroupFromNode.toString());
        diParam.put("Cu", cu);
        request.setTaskParam(diParam.toString());
        this.setInputList(workflowNode.getProjectName(), workflowNode, request);
        return request;
    }

    private String dealSpecialMsg(String scriptContent) {
        return scriptContent;
    }

    private String getLocalScriptFilePath(String rooDir, String scriptPath) {
        return new File(new File(rooDir), scriptPath).getPath();
    }
}

