/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.openapi.converter;

import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.utils.CustomCreateFileRequest;
import com.aliyun.migration.workflow.migration.dw.openapi.common.DwCommonUtil;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.AbstractDwNodeConverter;
import com.aliyun.migration.workflow.migration.dw.openapi.converter.DefaultConverter;
import java.io.File;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class ADBPGConverter
extends AbstractDwNodeConverter {
    private static final String ODPS_FILE_FOLDER_FORMAT = "\u4e1a\u52a1\u6d41\u7a0b/%s/folderADB";

    @Override
    public CustomCreateFileRequest convert(WorkflowNode workflowNode) {
        String projectName = workflowNode.getProjectName();
        DefaultConverter defaultConverter = new DefaultConverter(this.taskContextConf);
        CustomCreateFileRequest customCreateFileRequest = defaultConverter.convert(workflowNode);
        customCreateFileRequest.setFileFolderPath(String.format(ODPS_FILE_FOLDER_FORMAT, workflowNode.getWorkflowName()));
        customCreateFileRequest.setNodeType(DwCommonUtil.getType(workflowNode.getNodeType()));
        String prefixPath = workflowNode.getScriptPathPreFix();
        customCreateFileRequest.setPrefixPath(prefixPath);
        if (Objects.nonNull(this.taskContextConf)) {
            Boolean autoParse = this.taskContextConf.getBool("autoParse", Boolean.FALSE.booleanValue());
            customCreateFileRequest.setAutoParsing(autoParse);
        }
        customCreateFileRequest.setProjectId(Long.valueOf(Long.parseLong(workflowNode.getProjectId())));
        workflowNode.setScriptPath(StringUtils.trim((String)workflowNode.getScriptPath()));
        customCreateFileRequest.setFileName(workflowNode.getNodeName());
        customCreateFileRequest.setContent(workflowNode.getScript());
        this.setInputList(workflowNode.getProjectName(), workflowNode, customCreateFileRequest);
        return customCreateFileRequest;
    }

    private String dealSpecialMsg(String scriptContent) {
        return scriptContent;
    }

    private String getLocalScriptFilePath(String rooDir, String scriptPath) {
        return new File(new File(rooDir), scriptPath).getPath();
    }
}

