/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.newide.deploy.module;

import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.spec.domain.dataworks.node.DataWorksNodeTypeUtils;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.workflow.migration.common.config.WriterProjectMappingRuleGroup;
import com.aliyun.migration.workflow.migration.common.utils.DwNewideClient;
import com.aliyun.migration.workflow.migration.dw.newide.module.DwNewideWriter;
import com.aliyun.migration.workflow.migration.dw.newide.tools.DataWorksTopologicalUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwNewideDeployer
extends DwNewideWriter {
    private static final Logger log = LoggerFactory.getLogger(DwNewideDeployer.class);

    protected void RefreshIdInPackage(WorkflowProjectPackage workflowProjectPackage) {
    }

    public String write() {
        Map<String, DwNewideClient.PipeLineStatus> result = this.deploy();
        return null;
    }

    protected void freshProjectInfoInPackage(WriterProjectMappingRuleGroup writerProjectMappingRuleGroup) {
    }

    public Map<String, DwNewideClient.PipeLineStatus> deploy() {
        ArrayList workflowList = new ArrayList();
        HashMap downstreamDependencies = new HashMap();
        DataWorksTopologicalUtils.sortWorkflowByDependency4DataWorksId((WorkflowProjectPackage)this.workflowProjectPackage, (DataWorksNodeTypeUtils)this.dataWorksNodeTypeUtils, workflowList, downstreamDependencies);
        log.info("workflowList:{}", workflowList);
        HashMap<String, DwNewideClient.PipeLineStatus> deployResult = new HashMap<String, DwNewideClient.PipeLineStatus>();
        HashMap<String, Workflow> workflowProjectMap = new HashMap<String, Workflow>();
        if (this.workflowProjectPackage.getWorkflowList() != null) {
            for (Workflow workflow : this.workflowProjectPackage.getWorkflowList()) {
                String dataworksWorkflowId = StringUtils.isEmpty((String)workflow.getTWorkflowId()) ? workflow.getWorkflowId() : workflow.getTWorkflowId();
                workflowProjectMap.put(dataworksWorkflowId, workflow);
                deployResult.put(dataworksWorkflowId, DwNewideClient.PipeLineStatus.Init);
            }
        }
        Integer index = 1;
        block4: for (String workflowId : workflowList) {
            if (workflowProjectMap.containsKey(workflowId)) {
                Integer n;
                Workflow wf = (Workflow)workflowProjectMap.get(workflowId);
                if (((DwNewideClient.PipeLineStatus)deployResult.get(workflowId)).equals((Object)DwNewideClient.PipeLineStatus.Init)) {
                    Object[] objectArray = new Object[5];
                    n = index;
                    index = index + 1;
                    objectArray[0] = n;
                    objectArray[1] = workflowList.size();
                    objectArray[2] = wf.getWorkflowName();
                    objectArray[3] = wf.getWorkflowId();
                    objectArray[4] = wf.getCategoryValue();
                    log.info("[{}/{}]\u5f00\u59cb\u53d1\u5e03\u6d41\u7a0b:{} - {} - {}", objectArray);
                    DwNewideClient.PipeLineStatus status = this.client.onlineWorkflow(((Workflow)workflowProjectMap.get(workflowId)).getProjectId(), workflowId);
                    deployResult.put(workflowId, status);
                    switch (status) {
                        case Success: {
                            log.info("\u6d41\u7a0b{}\u53d1\u5e03\u6210\u529f", (Object)workflowId);
                            break;
                        }
                        default: {
                            log.info("\u6d41\u7a0b{}\u53d1\u5e03\u5931\u8d25\uff0c\u5176\u4e0b\u6e38Workflow\u5168\u90e8\u53d6\u6d88\u53d1\u5e03", (Object)workflowId);
                            for (String downstreamWorkflowId : (Set)downstreamDependencies.get(workflowId)) {
                                deployResult.put(downstreamWorkflowId, DwNewideClient.PipeLineStatus.Cancel);
                            }
                            continue block4;
                        }
                    }
                    continue;
                }
                Object[] objectArray = new Object[5];
                n = index;
                index = index + 1;
                objectArray[0] = n;
                objectArray[1] = workflowList.size();
                objectArray[2] = wf.getWorkflowName();
                objectArray[3] = wf.getWorkflowId();
                objectArray[4] = wf.getCategoryValue();
                log.info("[{}/{}]\u6d41\u7a0b\u56e0\u4e0a\u6e38\u72b6\u6001\u5f02\u5e38\uff0c\u53d6\u6d88\u53d1\u5e03:{} - {} - {}", objectArray);
                continue;
            }
            Object[] objectArray = new Object[3];
            Integer n = index;
            index = index + 1;
            objectArray[0] = n;
            objectArray[1] = workflowList.size();
            objectArray[2] = workflowId;
            log.info("[{}/{}]\u6d41\u7a0b\u4e0d\u5b58\u5728\uff0c\u8df3\u8fc7", objectArray);
        }
        this.printResult(deployResult, workflowProjectMap);
        return deployResult;
    }

    public void printResult(Map<String, DwNewideClient.PipeLineStatus> deployResult, Map<String, Workflow> workflowProjectMap) {
        StringBuilder overviewSb = new StringBuilder();
        int width = 30;
        overviewSb.append("\n");
        overviewSb.append("=============================================start print deploy result list=======================================================\n");
        overviewSb.append("Result List:");
        overviewSb.append("\n");
        overviewSb.append(this.leftAlign("WorkflowId(inDataWorks)", width));
        overviewSb.append(this.leftAlign("WorkflowName", width));
        overviewSb.append(this.leftAlign("WorkflowPath", width));
        overviewSb.append(this.leftAlign("Result", width));
        overviewSb.append("\n");
        for (String workflowId : deployResult.keySet()) {
            overviewSb.append(this.leftAlign(workflowId, width));
            Workflow workflow = workflowProjectMap.get(workflowId);
            overviewSb.append(this.leftAlign(workflow.getWorkflowName(), width));
            overviewSb.append(this.leftAlign(workflow.getCategoryValue(), width));
            overviewSb.append(this.leftAlign(deployResult.get(workflowId), width));
            overviewSb.append("\n");
        }
        overviewSb.append("=============================================end print deploy result list========================================================");
        log.info(overviewSb.toString());
    }

    private String leftAlign(Object obj, int width) {
        String str = "";
        if (Objects.nonNull(obj)) {
            str = obj.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(str);
        while (sb.length() < width) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public void close() {
    }
}

