/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.file;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.file.visitor.CopyVisitor;
import cn.hutool.core.io.file.visitor.DelVisitor;
import cn.hutool.core.io.file.visitor.MoveVisitor;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.CharsetUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class PathUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDirEmpty(Path dirPath) {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(dirPath);){
            boolean bl = false == dirStream.iterator().hasNext();
            return bl;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static List<File> loopFiles(Path path, int maxDepth, final FileFilter fileFilter) {
        final ArrayList<File> fileList = new ArrayList<File>();
        if (null == path || !Files.exists(path, new LinkOption[0])) {
            return fileList;
        }
        if (!PathUtil.isDirectory(path)) {
            File file = path.toFile();
            if (null == fileFilter || fileFilter.accept(file)) {
                fileList.add(file);
            }
            return fileList;
        }
        PathUtil.walkFiles(path, maxDepth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                File file = path.toFile();
                if (null == fileFilter || fileFilter.accept(file)) {
                    fileList.add(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return fileList;
    }

    public static void walkFiles(Path start, FileVisitor<? super Path> visitor) {
        PathUtil.walkFiles(start, -1, visitor);
    }

    public static void walkFiles(Path start, int maxDepth, FileVisitor<? super Path> visitor) {
        if (maxDepth < 0) {
            maxDepth = Integer.MAX_VALUE;
        }
        try {
            Files.walkFileTree(start, EnumSet.noneOf(FileVisitOption.class), maxDepth, visitor);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static boolean del(Path path) throws IORuntimeException {
        if (Files.notExists(path, new LinkOption[0])) {
            return true;
        }
        try {
            if (PathUtil.isDirectory(path)) {
                Files.walkFileTree(path, DelVisitor.INSTANCE);
            } else {
                PathUtil.delFile(path);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return true;
    }

    public static Path copyFile(Path src, Path dest, StandardCopyOption ... options) throws IORuntimeException {
        return PathUtil.copyFile(src, dest, (CopyOption[])options);
    }

    public static Path copyFile(Path src, Path target, CopyOption ... options) throws IORuntimeException {
        Assert.notNull(src, "Source File is null !", new Object[0]);
        Assert.notNull(target, "Destination File or directiory is null !", new Object[0]);
        Path targetPath = PathUtil.isDirectory(target) ? target.resolve(src.getFileName()) : target;
        PathUtil.mkParentDirs(targetPath);
        try {
            return Files.copy(src, targetPath, options);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Path copy(Path src, Path target, CopyOption ... options) throws IORuntimeException {
        Assert.notNull(src, "Src path must be not null !", new Object[0]);
        Assert.notNull(target, "Target path must be not null !", new Object[0]);
        if (PathUtil.isDirectory(src)) {
            return PathUtil.copyContent(src, target.resolve(src.getFileName()), options);
        }
        return PathUtil.copyFile(src, target, options);
    }

    public static Path copyContent(Path src, Path target, CopyOption ... options) throws IORuntimeException {
        Assert.notNull(src, "Src path must be not null !", new Object[0]);
        Assert.notNull(target, "Target path must be not null !", new Object[0]);
        try {
            Files.walkFileTree(src, new CopyVisitor(src, target, options));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return target;
    }

    public static boolean isDirectory(Path path) {
        return PathUtil.isDirectory(path, false);
    }

    public static boolean isDirectory(Path path, boolean isFollowLinks) {
        LinkOption[] linkOptionArray;
        if (null == path) {
            return false;
        }
        if (isFollowLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] options = linkOptionArray;
        return Files.isDirectory(path, options);
    }

    public static Path getPathEle(Path path, int index) {
        return PathUtil.subPath(path, index, index == -1 ? path.getNameCount() : index + 1);
    }

    public static Path getLastPathEle(Path path) {
        return PathUtil.getPathEle(path, path.getNameCount() - 1);
    }

    public static Path subPath(Path path, int fromIndex, int toIndex) {
        if (null == path) {
            return null;
        }
        int len = path.getNameCount();
        if (fromIndex < 0) {
            if ((fromIndex = len + fromIndex) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex > len) {
            fromIndex = len;
        }
        if (toIndex < 0) {
            if ((toIndex = len + toIndex) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex == toIndex) {
            return null;
        }
        return path.subpath(fromIndex, toIndex);
    }

    public static BasicFileAttributes getAttributes(Path path, boolean isFollowLinks) throws IORuntimeException {
        LinkOption[] linkOptionArray;
        if (null == path) {
            return null;
        }
        if (isFollowLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] options = linkOptionArray;
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, options);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static BufferedInputStream getInputStream(Path path) throws IORuntimeException {
        InputStream in;
        try {
            in = Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return IoUtil.toBuffered(in);
    }

    public static BufferedReader getUtf8Reader(Path path) throws IORuntimeException {
        return PathUtil.getReader(path, CharsetUtil.CHARSET_UTF_8);
    }

    public static BufferedReader getReader(Path path, Charset charset) throws IORuntimeException {
        return IoUtil.getReader((InputStream)PathUtil.getInputStream(path), charset);
    }

    public static byte[] readBytes(Path path) {
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static BufferedOutputStream getOutputStream(Path path) throws IORuntimeException {
        OutputStream in;
        try {
            in = Files.newOutputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return IoUtil.toBuffered(in);
    }

    public static Path rename(Path path, String newName, boolean isOverride) {
        return PathUtil.move(path, path.resolveSibling(newName), isOverride);
    }

    public static Path move(Path src, Path target, boolean isOverride) {
        Assert.notNull(src, "Src path must be not null !", new Object[0]);
        Assert.notNull(target, "Target path must be not null !", new Object[0]);
        if (PathUtil.isDirectory(target)) {
            target = target.resolve(src.getFileName());
        }
        return PathUtil.moveContent(src, target, isOverride);
    }

    public static Path moveContent(Path src, Path target, boolean isOverride) {
        CopyOption[] copyOptionArray;
        Assert.notNull(src, "Src path must be not null !", new Object[0]);
        Assert.notNull(target, "Target path must be not null !", new Object[0]);
        if (isOverride) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        CopyOption[] options = copyOptionArray;
        PathUtil.mkParentDirs(target);
        try {
            return Files.move(src, target, options);
        }
        catch (IOException e) {
            try {
                Files.walkFileTree(src, new MoveVisitor(src, target, options));
                PathUtil.del(src);
            }
            catch (IOException e2) {
                throw new IORuntimeException(e2);
            }
            return target;
        }
    }

    public static boolean equals(Path file1, Path file2) throws IORuntimeException {
        try {
            return Files.isSameFile(file1, file2);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static boolean isFile(Path path, boolean isFollowLinks) {
        LinkOption[] linkOptionArray;
        if (null == path) {
            return false;
        }
        if (isFollowLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] options = linkOptionArray;
        return Files.isRegularFile(path, options);
    }

    public static boolean isSymlink(Path path) {
        return Files.isSymbolicLink(path);
    }

    public static boolean exists(Path path, boolean isFollowLinks) {
        LinkOption[] linkOptionArray;
        if (isFollowLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] options = linkOptionArray;
        return Files.exists(path, options);
    }

    public static boolean isSub(Path parent, Path sub) {
        return PathUtil.toAbsNormal(sub).startsWith(PathUtil.toAbsNormal(parent));
    }

    public static Path toAbsNormal(Path path) {
        Assert.notNull(path);
        return path.toAbsolutePath().normalize();
    }

    public static String getMimeType(Path file) {
        try {
            return Files.probeContentType(file);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Path mkdir(Path dir) {
        if (null != dir && !PathUtil.exists(dir, false)) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
        return dir;
    }

    public static Path mkParentDirs(Path path) {
        return PathUtil.mkdir(path.getParent());
    }

    protected static void delFile(Path path) throws IOException {
        block2: {
            try {
                Files.delete(path);
            }
            catch (AccessDeniedException e) {
                if (path.toFile().delete()) break block2;
                throw e;
            }
        }
    }
}

