/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.provisioning;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.provisioning.DeletePrivateAccesRequest;
import com.databricks.sdk.service.provisioning.DeleteResponse;
import com.databricks.sdk.service.provisioning.GetPrivateAccesRequest;
import com.databricks.sdk.service.provisioning.PrivateAccessService;
import com.databricks.sdk.service.provisioning.PrivateAccessSettings;
import com.databricks.sdk.service.provisioning.ReplaceResponse;
import com.databricks.sdk.service.provisioning.UpsertPrivateAccessSettingsRequest;
import com.databricks.sdk.support.Generated;
import java.io.IOException;
import java.util.Collection;

@Generated
class PrivateAccessImpl
implements PrivateAccessService {
    private final ApiClient apiClient;

    public PrivateAccessImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public PrivateAccessSettings create(UpsertPrivateAccessSettingsRequest request) {
        String path = String.format("/api/2.0/accounts/%s/private-access-settings", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, PrivateAccessSettings.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeletePrivateAccesRequest request) {
        String path = String.format("/api/2.0/accounts/%s/private-access-settings/%s", this.apiClient.configuredAccountID(), request.getPrivateAccessSettingsId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public PrivateAccessSettings get(GetPrivateAccesRequest request) {
        String path = String.format("/api/2.0/accounts/%s/private-access-settings/%s", this.apiClient.configuredAccountID(), request.getPrivateAccessSettingsId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, PrivateAccessSettings.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Collection<PrivateAccessSettings> list() {
        String path = String.format("/api/2.0/accounts/%s/private-access-settings", this.apiClient.configuredAccountID());
        Request req = new Request("GET", path);
        req.withHeader("Accept", "application/json");
        return this.apiClient.getCollection(req, PrivateAccessSettings.class);
    }

    @Override
    public void replace(UpsertPrivateAccessSettingsRequest request) {
        String path = String.format("/api/2.0/accounts/%s/private-access-settings/%s", this.apiClient.configuredAccountID(), request.getPrivateAccessSettingsId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, ReplaceResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

