/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.catalog.CurrentWorkspaceBindings;
import com.databricks.sdk.service.catalog.GetBindingsRequest;
import com.databricks.sdk.service.catalog.GetWorkspaceBindingRequest;
import com.databricks.sdk.service.catalog.UpdateWorkspaceBindings;
import com.databricks.sdk.service.catalog.UpdateWorkspaceBindingsParameters;
import com.databricks.sdk.service.catalog.WorkspaceBindingsResponse;
import com.databricks.sdk.service.catalog.WorkspaceBindingsService;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class WorkspaceBindingsImpl
implements WorkspaceBindingsService {
    private final ApiClient apiClient;

    public WorkspaceBindingsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CurrentWorkspaceBindings get(GetWorkspaceBindingRequest request) {
        String path = String.format("/api/2.1/unity-catalog/workspace-bindings/catalogs/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, CurrentWorkspaceBindings.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public WorkspaceBindingsResponse getBindings(GetBindingsRequest request) {
        String path = String.format("/api/2.1/unity-catalog/bindings/%s/%s", new Object[]{request.getSecurableType(), request.getSecurableName()});
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, WorkspaceBindingsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public CurrentWorkspaceBindings update(UpdateWorkspaceBindings request) {
        String path = String.format("/api/2.1/unity-catalog/workspace-bindings/catalogs/%s", request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CurrentWorkspaceBindings.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public WorkspaceBindingsResponse updateBindings(UpdateWorkspaceBindingsParameters request) {
        String path = String.format("/api/2.1/unity-catalog/bindings/%s/%s", new Object[]{request.getSecurableType(), request.getSecurableName()});
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, WorkspaceBindingsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

