/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.catalog.AccountStorageCredentialsService;
import com.databricks.sdk.service.catalog.AccountsCreateStorageCredential;
import com.databricks.sdk.service.catalog.AccountsStorageCredentialInfo;
import com.databricks.sdk.service.catalog.AccountsUpdateStorageCredential;
import com.databricks.sdk.service.catalog.DeleteAccountStorageCredentialRequest;
import com.databricks.sdk.service.catalog.DeleteResponse;
import com.databricks.sdk.service.catalog.GetAccountStorageCredentialRequest;
import com.databricks.sdk.service.catalog.ListAccountStorageCredentialsRequest;
import com.databricks.sdk.service.catalog.ListAccountStorageCredentialsResponse;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class AccountStorageCredentialsImpl
implements AccountStorageCredentialsService {
    private final ApiClient apiClient;

    public AccountStorageCredentialsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public AccountsStorageCredentialInfo create(AccountsCreateStorageCredential request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s/storage-credentials", this.apiClient.configuredAccountID(), request.getMetastoreId());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, AccountsStorageCredentialInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteAccountStorageCredentialRequest request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s/storage-credentials/%s", this.apiClient.configuredAccountID(), request.getMetastoreId(), request.getStorageCredentialName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public AccountsStorageCredentialInfo get(GetAccountStorageCredentialRequest request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s/storage-credentials/%s", this.apiClient.configuredAccountID(), request.getMetastoreId(), request.getStorageCredentialName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, AccountsStorageCredentialInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListAccountStorageCredentialsResponse list(ListAccountStorageCredentialsRequest request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s/storage-credentials", this.apiClient.configuredAccountID(), request.getMetastoreId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListAccountStorageCredentialsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public AccountsStorageCredentialInfo update(AccountsUpdateStorageCredential request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s/storage-credentials/%s", this.apiClient.configuredAccountID(), request.getMetastoreId(), request.getStorageCredentialName());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, AccountsStorageCredentialInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

