/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.apps;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.service.apps.App;
import com.databricks.sdk.service.apps.AppDeployment;
import com.databricks.sdk.service.apps.AppDeploymentState;
import com.databricks.sdk.service.apps.AppPermissions;
import com.databricks.sdk.service.apps.AppPermissionsRequest;
import com.databricks.sdk.service.apps.AppsImpl;
import com.databricks.sdk.service.apps.AppsService;
import com.databricks.sdk.service.apps.ComputeState;
import com.databricks.sdk.service.apps.CreateAppDeploymentRequest;
import com.databricks.sdk.service.apps.CreateAppRequest;
import com.databricks.sdk.service.apps.DeleteAppRequest;
import com.databricks.sdk.service.apps.GetAppDeploymentRequest;
import com.databricks.sdk.service.apps.GetAppPermissionLevelsRequest;
import com.databricks.sdk.service.apps.GetAppPermissionLevelsResponse;
import com.databricks.sdk.service.apps.GetAppPermissionsRequest;
import com.databricks.sdk.service.apps.GetAppRequest;
import com.databricks.sdk.service.apps.ListAppDeploymentsRequest;
import com.databricks.sdk.service.apps.ListAppDeploymentsResponse;
import com.databricks.sdk.service.apps.ListAppsRequest;
import com.databricks.sdk.service.apps.ListAppsResponse;
import com.databricks.sdk.service.apps.StartAppRequest;
import com.databricks.sdk.service.apps.StopAppRequest;
import com.databricks.sdk.service.apps.UpdateAppRequest;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import com.databricks.sdk.support.Wait;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class AppsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(AppsAPI.class);
    private final AppsService impl;

    public AppsAPI(ApiClient apiClient) {
        this.impl = new AppsImpl(apiClient);
    }

    public AppsAPI(AppsService mock) {
        this.impl = mock;
    }

    public App waitGetAppActive(String name) throws TimeoutException {
        return this.waitGetAppActive(name, Duration.ofMinutes(20L), null);
    }

    public App waitGetAppActive(String name, Duration timeout, Consumer<App> callback) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        List<ComputeState> targetStates = Arrays.asList(ComputeState.ACTIVE);
        List<ComputeState> failureStates = Arrays.asList(ComputeState.ERROR, ComputeState.STOPPED);
        String statusMessage = "polling...";
        int attempt = 1;
        while (System.currentTimeMillis() < deadline) {
            App poll = this.get(new GetAppRequest().setName(name));
            ComputeState status = poll.getComputeStatus().getState();
            statusMessage = String.format("current status: %s", new Object[]{status});
            if (poll.getComputeStatus() != null) {
                statusMessage = poll.getComputeStatus().getMessage();
            }
            if (targetStates.contains((Object)status)) {
                return poll;
            }
            if (callback != null) {
                callback.accept(poll);
            }
            if (failureStates.contains((Object)status)) {
                String msg = String.format("failed to reach ACTIVE, got %s: %s", new Object[]{status, statusMessage});
                throw new IllegalStateException(msg);
            }
            String prefix = String.format("name=%s", name);
            int sleep = attempt;
            if (sleep > 10) {
                sleep = 10;
            }
            LOG.info("{}: ({}) {} (sleeping ~{}s)", new Object[]{prefix, status, statusMessage, sleep});
            try {
                Thread.sleep((long)((double)((long)sleep * 1000L) + Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DatabricksException("Current thread was interrupted", e);
            }
            ++attempt;
        }
        throw new TimeoutException(String.format("timed out after %s: %s", timeout, statusMessage));
    }

    public AppDeployment waitGetDeploymentAppSucceeded(String appName, String deploymentId) throws TimeoutException {
        return this.waitGetDeploymentAppSucceeded(appName, deploymentId, Duration.ofMinutes(20L), null);
    }

    public AppDeployment waitGetDeploymentAppSucceeded(String appName, String deploymentId, Duration timeout, Consumer<AppDeployment> callback) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        List<AppDeploymentState> targetStates = Arrays.asList(AppDeploymentState.SUCCEEDED);
        List<AppDeploymentState> failureStates = Arrays.asList(AppDeploymentState.FAILED);
        String statusMessage = "polling...";
        int attempt = 1;
        while (System.currentTimeMillis() < deadline) {
            AppDeployment poll = this.getDeployment(new GetAppDeploymentRequest().setAppName(appName).setDeploymentId(deploymentId));
            AppDeploymentState status = poll.getStatus().getState();
            statusMessage = String.format("current status: %s", new Object[]{status});
            if (poll.getStatus() != null) {
                statusMessage = poll.getStatus().getMessage();
            }
            if (targetStates.contains((Object)status)) {
                return poll;
            }
            if (callback != null) {
                callback.accept(poll);
            }
            if (failureStates.contains((Object)status)) {
                String msg = String.format("failed to reach SUCCEEDED, got %s: %s", new Object[]{status, statusMessage});
                throw new IllegalStateException(msg);
            }
            String prefix = String.format("appName=%s, deploymentId=%s", appName, deploymentId);
            int sleep = attempt;
            if (sleep > 10) {
                sleep = 10;
            }
            LOG.info("{}: ({}) {} (sleeping ~{}s)", new Object[]{prefix, status, statusMessage, sleep});
            try {
                Thread.sleep((long)((double)((long)sleep * 1000L) + Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DatabricksException("Current thread was interrupted", e);
            }
            ++attempt;
        }
        throw new TimeoutException(String.format("timed out after %s: %s", timeout, statusMessage));
    }

    public App waitGetAppStopped(String name) throws TimeoutException {
        return this.waitGetAppStopped(name, Duration.ofMinutes(20L), null);
    }

    public App waitGetAppStopped(String name, Duration timeout, Consumer<App> callback) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        List<ComputeState> targetStates = Arrays.asList(ComputeState.STOPPED);
        List<ComputeState> failureStates = Arrays.asList(ComputeState.ERROR);
        String statusMessage = "polling...";
        int attempt = 1;
        while (System.currentTimeMillis() < deadline) {
            App poll = this.get(new GetAppRequest().setName(name));
            ComputeState status = poll.getComputeStatus().getState();
            statusMessage = String.format("current status: %s", new Object[]{status});
            if (poll.getComputeStatus() != null) {
                statusMessage = poll.getComputeStatus().getMessage();
            }
            if (targetStates.contains((Object)status)) {
                return poll;
            }
            if (callback != null) {
                callback.accept(poll);
            }
            if (failureStates.contains((Object)status)) {
                String msg = String.format("failed to reach STOPPED, got %s: %s", new Object[]{status, statusMessage});
                throw new IllegalStateException(msg);
            }
            String prefix = String.format("name=%s", name);
            int sleep = attempt;
            if (sleep > 10) {
                sleep = 10;
            }
            LOG.info("{}: ({}) {} (sleeping ~{}s)", new Object[]{prefix, status, statusMessage, sleep});
            try {
                Thread.sleep((long)((double)((long)sleep * 1000L) + Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DatabricksException("Current thread was interrupted", e);
            }
            ++attempt;
        }
        throw new TimeoutException(String.format("timed out after %s: %s", timeout, statusMessage));
    }

    public Wait<App, App> create(App app) {
        return this.create(new CreateAppRequest().setApp(app));
    }

    public Wait<App, App> create(CreateAppRequest request) {
        App response = this.impl.create(request);
        return new Wait<App, App>((timeout, callback) -> this.waitGetAppActive(response.getName(), timeout, callback), response);
    }

    public App delete(String name) {
        return this.delete(new DeleteAppRequest().setName(name));
    }

    public App delete(DeleteAppRequest request) {
        return this.impl.delete(request);
    }

    public Wait<AppDeployment, AppDeployment> deploy(String appName, AppDeployment appDeployment) {
        return this.deploy(new CreateAppDeploymentRequest().setAppName(appName).setAppDeployment(appDeployment));
    }

    public Wait<AppDeployment, AppDeployment> deploy(CreateAppDeploymentRequest request) {
        AppDeployment response = this.impl.deploy(request);
        return new Wait<AppDeployment, AppDeployment>((timeout, callback) -> this.waitGetDeploymentAppSucceeded(request.getAppName(), response.getDeploymentId(), timeout, callback), response);
    }

    public App get(String name) {
        return this.get(new GetAppRequest().setName(name));
    }

    public App get(GetAppRequest request) {
        return this.impl.get(request);
    }

    public AppDeployment getDeployment(String appName, String deploymentId) {
        return this.getDeployment(new GetAppDeploymentRequest().setAppName(appName).setDeploymentId(deploymentId));
    }

    public AppDeployment getDeployment(GetAppDeploymentRequest request) {
        return this.impl.getDeployment(request);
    }

    public GetAppPermissionLevelsResponse getPermissionLevels(String appName) {
        return this.getPermissionLevels(new GetAppPermissionLevelsRequest().setAppName(appName));
    }

    public GetAppPermissionLevelsResponse getPermissionLevels(GetAppPermissionLevelsRequest request) {
        return this.impl.getPermissionLevels(request);
    }

    public AppPermissions getPermissions(String appName) {
        return this.getPermissions(new GetAppPermissionsRequest().setAppName(appName));
    }

    public AppPermissions getPermissions(GetAppPermissionsRequest request) {
        return this.impl.getPermissions(request);
    }

    public Iterable<App> list(ListAppsRequest request) {
        return new Paginator(request, this.impl::list, ListAppsResponse::getApps, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<AppDeployment> listDeployments(String appName) {
        return this.listDeployments(new ListAppDeploymentsRequest().setAppName(appName));
    }

    public Iterable<AppDeployment> listDeployments(ListAppDeploymentsRequest request) {
        return new Paginator(request, this.impl::listDeployments, ListAppDeploymentsResponse::getAppDeployments, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public AppPermissions setPermissions(String appName) {
        return this.setPermissions(new AppPermissionsRequest().setAppName(appName));
    }

    public AppPermissions setPermissions(AppPermissionsRequest request) {
        return this.impl.setPermissions(request);
    }

    public Wait<App, App> start(String name) {
        return this.start(new StartAppRequest().setName(name));
    }

    public Wait<App, App> start(StartAppRequest request) {
        App response = this.impl.start(request);
        return new Wait<App, App>((timeout, callback) -> this.waitGetAppActive(response.getName(), timeout, callback), response);
    }

    public Wait<App, App> stop(String name) {
        return this.stop(new StopAppRequest().setName(name));
    }

    public Wait<App, App> stop(StopAppRequest request) {
        App response = this.impl.stop(request);
        return new Wait<App, App>((timeout, callback) -> this.waitGetAppStopped(response.getName(), timeout, callback), response);
    }

    public App update(String name, App app) {
        return this.update(new UpdateAppRequest().setName(name).setApp(app));
    }

    public App update(UpdateAppRequest request) {
        return this.impl.update(request);
    }

    public AppPermissions updatePermissions(String appName) {
        return this.updatePermissions(new AppPermissionsRequest().setAppName(appName));
    }

    public AppPermissions updatePermissions(AppPermissionsRequest request) {
        return this.impl.updatePermissions(request);
    }

    public AppsService impl() {
        return this.impl;
    }
}

