/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk;

import com.databricks.sdk.WorkspaceClient;
import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.ConfigLoader;
import com.databricks.sdk.core.DatabricksConfig;
import com.databricks.sdk.core.utils.AzureUtils;
import com.databricks.sdk.service.billing.BillableUsageAPI;
import com.databricks.sdk.service.billing.BillableUsageService;
import com.databricks.sdk.service.billing.BudgetPolicyAPI;
import com.databricks.sdk.service.billing.BudgetPolicyService;
import com.databricks.sdk.service.billing.BudgetsAPI;
import com.databricks.sdk.service.billing.BudgetsService;
import com.databricks.sdk.service.billing.LogDeliveryAPI;
import com.databricks.sdk.service.billing.LogDeliveryService;
import com.databricks.sdk.service.billing.UsageDashboardsAPI;
import com.databricks.sdk.service.billing.UsageDashboardsService;
import com.databricks.sdk.service.catalog.AccountMetastoreAssignmentsAPI;
import com.databricks.sdk.service.catalog.AccountMetastoreAssignmentsService;
import com.databricks.sdk.service.catalog.AccountMetastoresAPI;
import com.databricks.sdk.service.catalog.AccountMetastoresService;
import com.databricks.sdk.service.catalog.AccountStorageCredentialsAPI;
import com.databricks.sdk.service.catalog.AccountStorageCredentialsService;
import com.databricks.sdk.service.iam.AccountAccessControlAPI;
import com.databricks.sdk.service.iam.AccountAccessControlService;
import com.databricks.sdk.service.iam.AccountGroupsAPI;
import com.databricks.sdk.service.iam.AccountGroupsService;
import com.databricks.sdk.service.iam.AccountServicePrincipalsAPI;
import com.databricks.sdk.service.iam.AccountServicePrincipalsService;
import com.databricks.sdk.service.iam.AccountUsersAPI;
import com.databricks.sdk.service.iam.AccountUsersService;
import com.databricks.sdk.service.iam.WorkspaceAssignmentAPI;
import com.databricks.sdk.service.iam.WorkspaceAssignmentService;
import com.databricks.sdk.service.oauth2.AccountFederationPolicyAPI;
import com.databricks.sdk.service.oauth2.AccountFederationPolicyService;
import com.databricks.sdk.service.oauth2.CustomAppIntegrationAPI;
import com.databricks.sdk.service.oauth2.CustomAppIntegrationService;
import com.databricks.sdk.service.oauth2.OAuthPublishedAppsAPI;
import com.databricks.sdk.service.oauth2.OAuthPublishedAppsService;
import com.databricks.sdk.service.oauth2.PublishedAppIntegrationAPI;
import com.databricks.sdk.service.oauth2.PublishedAppIntegrationService;
import com.databricks.sdk.service.oauth2.ServicePrincipalFederationPolicyAPI;
import com.databricks.sdk.service.oauth2.ServicePrincipalFederationPolicyService;
import com.databricks.sdk.service.oauth2.ServicePrincipalSecretsAPI;
import com.databricks.sdk.service.oauth2.ServicePrincipalSecretsService;
import com.databricks.sdk.service.provisioning.CredentialsAPI;
import com.databricks.sdk.service.provisioning.CredentialsService;
import com.databricks.sdk.service.provisioning.EncryptionKeysAPI;
import com.databricks.sdk.service.provisioning.EncryptionKeysService;
import com.databricks.sdk.service.provisioning.NetworksAPI;
import com.databricks.sdk.service.provisioning.NetworksService;
import com.databricks.sdk.service.provisioning.PrivateAccessAPI;
import com.databricks.sdk.service.provisioning.PrivateAccessService;
import com.databricks.sdk.service.provisioning.StorageAPI;
import com.databricks.sdk.service.provisioning.StorageService;
import com.databricks.sdk.service.provisioning.VpcEndpointsAPI;
import com.databricks.sdk.service.provisioning.VpcEndpointsService;
import com.databricks.sdk.service.provisioning.Workspace;
import com.databricks.sdk.service.provisioning.WorkspacesAPI;
import com.databricks.sdk.service.provisioning.WorkspacesService;
import com.databricks.sdk.service.settings.AccountIpAccessListsAPI;
import com.databricks.sdk.service.settings.AccountIpAccessListsService;
import com.databricks.sdk.service.settings.AccountSettingsAPI;
import com.databricks.sdk.service.settings.AccountSettingsService;
import com.databricks.sdk.service.settings.NetworkConnectivityAPI;
import com.databricks.sdk.service.settings.NetworkConnectivityService;
import com.databricks.sdk.support.Generated;

@Generated
public class AccountClient {
    private final ApiClient apiClient;
    private final DatabricksConfig config;
    private AccountAccessControlAPI accessControlAPI;
    private BillableUsageAPI billableUsageAPI;
    private BudgetPolicyAPI budgetPolicyAPI;
    private CredentialsAPI credentialsAPI;
    private CustomAppIntegrationAPI customAppIntegrationAPI;
    private EncryptionKeysAPI encryptionKeysAPI;
    private AccountFederationPolicyAPI federationPolicyAPI;
    private AccountGroupsAPI groupsAPI;
    private AccountIpAccessListsAPI ipAccessListsAPI;
    private LogDeliveryAPI logDeliveryAPI;
    private AccountMetastoreAssignmentsAPI metastoreAssignmentsAPI;
    private AccountMetastoresAPI metastoresAPI;
    private NetworkConnectivityAPI networkConnectivityAPI;
    private NetworksAPI networksAPI;
    private OAuthPublishedAppsAPI oAuthPublishedAppsAPI;
    private PrivateAccessAPI privateAccessAPI;
    private PublishedAppIntegrationAPI publishedAppIntegrationAPI;
    private ServicePrincipalFederationPolicyAPI servicePrincipalFederationPolicyAPI;
    private ServicePrincipalSecretsAPI servicePrincipalSecretsAPI;
    private AccountServicePrincipalsAPI servicePrincipalsAPI;
    private AccountSettingsAPI settingsAPI;
    private StorageAPI storageAPI;
    private AccountStorageCredentialsAPI storageCredentialsAPI;
    private UsageDashboardsAPI usageDashboardsAPI;
    private AccountUsersAPI usersAPI;
    private VpcEndpointsAPI vpcEndpointsAPI;
    private WorkspaceAssignmentAPI workspaceAssignmentAPI;
    private WorkspacesAPI workspacesAPI;
    private BudgetsAPI budgetsAPI;

    public AccountClient() {
        this(ConfigLoader.getDefault());
    }

    public AccountClient(DatabricksConfig config) {
        this.config = config;
        this.apiClient = new ApiClient(config);
        this.accessControlAPI = new AccountAccessControlAPI(this.apiClient);
        this.billableUsageAPI = new BillableUsageAPI(this.apiClient);
        this.budgetPolicyAPI = new BudgetPolicyAPI(this.apiClient);
        this.credentialsAPI = new CredentialsAPI(this.apiClient);
        this.customAppIntegrationAPI = new CustomAppIntegrationAPI(this.apiClient);
        this.encryptionKeysAPI = new EncryptionKeysAPI(this.apiClient);
        this.federationPolicyAPI = new AccountFederationPolicyAPI(this.apiClient);
        this.groupsAPI = new AccountGroupsAPI(this.apiClient);
        this.ipAccessListsAPI = new AccountIpAccessListsAPI(this.apiClient);
        this.logDeliveryAPI = new LogDeliveryAPI(this.apiClient);
        this.metastoreAssignmentsAPI = new AccountMetastoreAssignmentsAPI(this.apiClient);
        this.metastoresAPI = new AccountMetastoresAPI(this.apiClient);
        this.networkConnectivityAPI = new NetworkConnectivityAPI(this.apiClient);
        this.networksAPI = new NetworksAPI(this.apiClient);
        this.oAuthPublishedAppsAPI = new OAuthPublishedAppsAPI(this.apiClient);
        this.privateAccessAPI = new PrivateAccessAPI(this.apiClient);
        this.publishedAppIntegrationAPI = new PublishedAppIntegrationAPI(this.apiClient);
        this.servicePrincipalFederationPolicyAPI = new ServicePrincipalFederationPolicyAPI(this.apiClient);
        this.servicePrincipalSecretsAPI = new ServicePrincipalSecretsAPI(this.apiClient);
        this.servicePrincipalsAPI = new AccountServicePrincipalsAPI(this.apiClient);
        this.settingsAPI = new AccountSettingsAPI(this.apiClient);
        this.storageAPI = new StorageAPI(this.apiClient);
        this.storageCredentialsAPI = new AccountStorageCredentialsAPI(this.apiClient);
        this.usageDashboardsAPI = new UsageDashboardsAPI(this.apiClient);
        this.usersAPI = new AccountUsersAPI(this.apiClient);
        this.vpcEndpointsAPI = new VpcEndpointsAPI(this.apiClient);
        this.workspaceAssignmentAPI = new WorkspaceAssignmentAPI(this.apiClient);
        this.workspacesAPI = new WorkspacesAPI(this.apiClient);
        this.budgetsAPI = new BudgetsAPI(this.apiClient);
    }

    public AccountClient(boolean mock) {
        this.apiClient = null;
        this.config = null;
    }

    public AccountAccessControlAPI accessControl() {
        return this.accessControlAPI;
    }

    public BillableUsageAPI billableUsage() {
        return this.billableUsageAPI;
    }

    public BudgetPolicyAPI budgetPolicy() {
        return this.budgetPolicyAPI;
    }

    public CredentialsAPI credentials() {
        return this.credentialsAPI;
    }

    public CustomAppIntegrationAPI customAppIntegration() {
        return this.customAppIntegrationAPI;
    }

    public EncryptionKeysAPI encryptionKeys() {
        return this.encryptionKeysAPI;
    }

    public AccountFederationPolicyAPI federationPolicy() {
        return this.federationPolicyAPI;
    }

    public AccountGroupsAPI groups() {
        return this.groupsAPI;
    }

    public AccountIpAccessListsAPI ipAccessLists() {
        return this.ipAccessListsAPI;
    }

    public LogDeliveryAPI logDelivery() {
        return this.logDeliveryAPI;
    }

    public AccountMetastoreAssignmentsAPI metastoreAssignments() {
        return this.metastoreAssignmentsAPI;
    }

    public AccountMetastoresAPI metastores() {
        return this.metastoresAPI;
    }

    public NetworkConnectivityAPI networkConnectivity() {
        return this.networkConnectivityAPI;
    }

    public NetworksAPI networks() {
        return this.networksAPI;
    }

    public OAuthPublishedAppsAPI oAuthPublishedApps() {
        return this.oAuthPublishedAppsAPI;
    }

    public PrivateAccessAPI privateAccess() {
        return this.privateAccessAPI;
    }

    public PublishedAppIntegrationAPI publishedAppIntegration() {
        return this.publishedAppIntegrationAPI;
    }

    public ServicePrincipalFederationPolicyAPI servicePrincipalFederationPolicy() {
        return this.servicePrincipalFederationPolicyAPI;
    }

    public ServicePrincipalSecretsAPI servicePrincipalSecrets() {
        return this.servicePrincipalSecretsAPI;
    }

    public AccountServicePrincipalsAPI servicePrincipals() {
        return this.servicePrincipalsAPI;
    }

    public AccountSettingsAPI settings() {
        return this.settingsAPI;
    }

    public StorageAPI storage() {
        return this.storageAPI;
    }

    public AccountStorageCredentialsAPI storageCredentials() {
        return this.storageCredentialsAPI;
    }

    public UsageDashboardsAPI usageDashboards() {
        return this.usageDashboardsAPI;
    }

    public AccountUsersAPI users() {
        return this.usersAPI;
    }

    public VpcEndpointsAPI vpcEndpoints() {
        return this.vpcEndpointsAPI;
    }

    public WorkspaceAssignmentAPI workspaceAssignment() {
        return this.workspaceAssignmentAPI;
    }

    public WorkspacesAPI workspaces() {
        return this.workspacesAPI;
    }

    public BudgetsAPI budgets() {
        return this.budgetsAPI;
    }

    public AccountClient withAccessControlImpl(AccountAccessControlService accountAccessControl) {
        return this.withAccessControlAPI(new AccountAccessControlAPI(accountAccessControl));
    }

    public AccountClient withAccessControlAPI(AccountAccessControlAPI accountAccessControl) {
        this.accessControlAPI = accountAccessControl;
        return this;
    }

    public AccountClient withBillableUsageImpl(BillableUsageService billableUsage) {
        return this.withBillableUsageAPI(new BillableUsageAPI(billableUsage));
    }

    public AccountClient withBillableUsageAPI(BillableUsageAPI billableUsage) {
        this.billableUsageAPI = billableUsage;
        return this;
    }

    public AccountClient withBudgetPolicyImpl(BudgetPolicyService budgetPolicy) {
        return this.withBudgetPolicyAPI(new BudgetPolicyAPI(budgetPolicy));
    }

    public AccountClient withBudgetPolicyAPI(BudgetPolicyAPI budgetPolicy) {
        this.budgetPolicyAPI = budgetPolicy;
        return this;
    }

    public AccountClient withCredentialsImpl(CredentialsService credentials) {
        return this.withCredentialsAPI(new CredentialsAPI(credentials));
    }

    public AccountClient withCredentialsAPI(CredentialsAPI credentials) {
        this.credentialsAPI = credentials;
        return this;
    }

    public AccountClient withCustomAppIntegrationImpl(CustomAppIntegrationService customAppIntegration) {
        return this.withCustomAppIntegrationAPI(new CustomAppIntegrationAPI(customAppIntegration));
    }

    public AccountClient withCustomAppIntegrationAPI(CustomAppIntegrationAPI customAppIntegration) {
        this.customAppIntegrationAPI = customAppIntegration;
        return this;
    }

    public AccountClient withEncryptionKeysImpl(EncryptionKeysService encryptionKeys) {
        return this.withEncryptionKeysAPI(new EncryptionKeysAPI(encryptionKeys));
    }

    public AccountClient withEncryptionKeysAPI(EncryptionKeysAPI encryptionKeys) {
        this.encryptionKeysAPI = encryptionKeys;
        return this;
    }

    public AccountClient withFederationPolicyImpl(AccountFederationPolicyService accountFederationPolicy) {
        return this.withFederationPolicyAPI(new AccountFederationPolicyAPI(accountFederationPolicy));
    }

    public AccountClient withFederationPolicyAPI(AccountFederationPolicyAPI accountFederationPolicy) {
        this.federationPolicyAPI = accountFederationPolicy;
        return this;
    }

    public AccountClient withGroupsImpl(AccountGroupsService accountGroups) {
        return this.withGroupsAPI(new AccountGroupsAPI(accountGroups));
    }

    public AccountClient withGroupsAPI(AccountGroupsAPI accountGroups) {
        this.groupsAPI = accountGroups;
        return this;
    }

    public AccountClient withIpAccessListsImpl(AccountIpAccessListsService accountIpAccessLists) {
        return this.withIpAccessListsAPI(new AccountIpAccessListsAPI(accountIpAccessLists));
    }

    public AccountClient withIpAccessListsAPI(AccountIpAccessListsAPI accountIpAccessLists) {
        this.ipAccessListsAPI = accountIpAccessLists;
        return this;
    }

    public AccountClient withLogDeliveryImpl(LogDeliveryService logDelivery) {
        return this.withLogDeliveryAPI(new LogDeliveryAPI(logDelivery));
    }

    public AccountClient withLogDeliveryAPI(LogDeliveryAPI logDelivery) {
        this.logDeliveryAPI = logDelivery;
        return this;
    }

    public AccountClient withMetastoreAssignmentsImpl(AccountMetastoreAssignmentsService accountMetastoreAssignments) {
        return this.withMetastoreAssignmentsAPI(new AccountMetastoreAssignmentsAPI(accountMetastoreAssignments));
    }

    public AccountClient withMetastoreAssignmentsAPI(AccountMetastoreAssignmentsAPI accountMetastoreAssignments) {
        this.metastoreAssignmentsAPI = accountMetastoreAssignments;
        return this;
    }

    public AccountClient withMetastoresImpl(AccountMetastoresService accountMetastores) {
        return this.withMetastoresAPI(new AccountMetastoresAPI(accountMetastores));
    }

    public AccountClient withMetastoresAPI(AccountMetastoresAPI accountMetastores) {
        this.metastoresAPI = accountMetastores;
        return this;
    }

    public AccountClient withNetworkConnectivityImpl(NetworkConnectivityService networkConnectivity) {
        return this.withNetworkConnectivityAPI(new NetworkConnectivityAPI(networkConnectivity));
    }

    public AccountClient withNetworkConnectivityAPI(NetworkConnectivityAPI networkConnectivity) {
        this.networkConnectivityAPI = networkConnectivity;
        return this;
    }

    public AccountClient withNetworksImpl(NetworksService networks) {
        return this.withNetworksAPI(new NetworksAPI(networks));
    }

    public AccountClient withNetworksAPI(NetworksAPI networks) {
        this.networksAPI = networks;
        return this;
    }

    public AccountClient withOAuthPublishedAppsImpl(OAuthPublishedAppsService oAuthPublishedApps) {
        return this.withOAuthPublishedAppsAPI(new OAuthPublishedAppsAPI(oAuthPublishedApps));
    }

    public AccountClient withOAuthPublishedAppsAPI(OAuthPublishedAppsAPI oAuthPublishedApps) {
        this.oAuthPublishedAppsAPI = oAuthPublishedApps;
        return this;
    }

    public AccountClient withPrivateAccessImpl(PrivateAccessService privateAccess) {
        return this.withPrivateAccessAPI(new PrivateAccessAPI(privateAccess));
    }

    public AccountClient withPrivateAccessAPI(PrivateAccessAPI privateAccess) {
        this.privateAccessAPI = privateAccess;
        return this;
    }

    public AccountClient withPublishedAppIntegrationImpl(PublishedAppIntegrationService publishedAppIntegration) {
        return this.withPublishedAppIntegrationAPI(new PublishedAppIntegrationAPI(publishedAppIntegration));
    }

    public AccountClient withPublishedAppIntegrationAPI(PublishedAppIntegrationAPI publishedAppIntegration) {
        this.publishedAppIntegrationAPI = publishedAppIntegration;
        return this;
    }

    public AccountClient withServicePrincipalFederationPolicyImpl(ServicePrincipalFederationPolicyService servicePrincipalFederationPolicy) {
        return this.withServicePrincipalFederationPolicyAPI(new ServicePrincipalFederationPolicyAPI(servicePrincipalFederationPolicy));
    }

    public AccountClient withServicePrincipalFederationPolicyAPI(ServicePrincipalFederationPolicyAPI servicePrincipalFederationPolicy) {
        this.servicePrincipalFederationPolicyAPI = servicePrincipalFederationPolicy;
        return this;
    }

    public AccountClient withServicePrincipalSecretsImpl(ServicePrincipalSecretsService servicePrincipalSecrets) {
        return this.withServicePrincipalSecretsAPI(new ServicePrincipalSecretsAPI(servicePrincipalSecrets));
    }

    public AccountClient withServicePrincipalSecretsAPI(ServicePrincipalSecretsAPI servicePrincipalSecrets) {
        this.servicePrincipalSecretsAPI = servicePrincipalSecrets;
        return this;
    }

    public AccountClient withServicePrincipalsImpl(AccountServicePrincipalsService accountServicePrincipals) {
        return this.withServicePrincipalsAPI(new AccountServicePrincipalsAPI(accountServicePrincipals));
    }

    public AccountClient withServicePrincipalsAPI(AccountServicePrincipalsAPI accountServicePrincipals) {
        this.servicePrincipalsAPI = accountServicePrincipals;
        return this;
    }

    public AccountClient withSettingsImpl(AccountSettingsService accountSettings) {
        return this.withSettingsAPI(new AccountSettingsAPI(accountSettings));
    }

    public AccountClient withSettingsAPI(AccountSettingsAPI accountSettings) {
        this.settingsAPI = accountSettings;
        return this;
    }

    public AccountClient withStorageImpl(StorageService storage) {
        return this.withStorageAPI(new StorageAPI(storage));
    }

    public AccountClient withStorageAPI(StorageAPI storage) {
        this.storageAPI = storage;
        return this;
    }

    public AccountClient withStorageCredentialsImpl(AccountStorageCredentialsService accountStorageCredentials) {
        return this.withStorageCredentialsAPI(new AccountStorageCredentialsAPI(accountStorageCredentials));
    }

    public AccountClient withStorageCredentialsAPI(AccountStorageCredentialsAPI accountStorageCredentials) {
        this.storageCredentialsAPI = accountStorageCredentials;
        return this;
    }

    public AccountClient withUsageDashboardsImpl(UsageDashboardsService usageDashboards) {
        return this.withUsageDashboardsAPI(new UsageDashboardsAPI(usageDashboards));
    }

    public AccountClient withUsageDashboardsAPI(UsageDashboardsAPI usageDashboards) {
        this.usageDashboardsAPI = usageDashboards;
        return this;
    }

    public AccountClient withUsersImpl(AccountUsersService accountUsers) {
        return this.withUsersAPI(new AccountUsersAPI(accountUsers));
    }

    public AccountClient withUsersAPI(AccountUsersAPI accountUsers) {
        this.usersAPI = accountUsers;
        return this;
    }

    public AccountClient withVpcEndpointsImpl(VpcEndpointsService vpcEndpoints) {
        return this.withVpcEndpointsAPI(new VpcEndpointsAPI(vpcEndpoints));
    }

    public AccountClient withVpcEndpointsAPI(VpcEndpointsAPI vpcEndpoints) {
        this.vpcEndpointsAPI = vpcEndpoints;
        return this;
    }

    public AccountClient withWorkspaceAssignmentImpl(WorkspaceAssignmentService workspaceAssignment) {
        return this.withWorkspaceAssignmentAPI(new WorkspaceAssignmentAPI(workspaceAssignment));
    }

    public AccountClient withWorkspaceAssignmentAPI(WorkspaceAssignmentAPI workspaceAssignment) {
        this.workspaceAssignmentAPI = workspaceAssignment;
        return this;
    }

    public AccountClient withWorkspacesImpl(WorkspacesService workspaces) {
        return this.withWorkspacesAPI(new WorkspacesAPI(workspaces));
    }

    public AccountClient withWorkspacesAPI(WorkspacesAPI workspaces) {
        this.workspacesAPI = workspaces;
        return this;
    }

    public AccountClient withBudgetsImpl(BudgetsService budgets) {
        return this.withBudgetsAPI(new BudgetsAPI(budgets));
    }

    public AccountClient withBudgetsAPI(BudgetsAPI budgets) {
        this.budgetsAPI = budgets;
        return this;
    }

    public ApiClient apiClient() {
        return this.apiClient;
    }

    public DatabricksConfig config() {
        return this.config;
    }

    public WorkspaceClient getWorkspaceClient(Workspace workspace) {
        String host = this.config.getDatabricksEnvironment().getDeploymentUrl(workspace.getDeploymentName());
        DatabricksConfig config = this.config.newWithWorkspaceHost(host);
        AzureUtils.getAzureWorkspaceResourceId(workspace).map(config::setAzureWorkspaceResourceId);
        return new WorkspaceClient(config);
    }
}

