/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.util;

import java.util.Collection;
import java.util.StringTokenizer;
import org.dozer.fieldmap.HintContainer;
import org.dozer.propertydescriptor.DozerPropertyDescriptor;
import org.dozer.propertydescriptor.PropertyDescriptorFactory;
import org.dozer.util.MappingUtils;

public class DeepHierarchyUtils {
    public static Object getDeepFieldValue(Object srcObj, String fieldName, boolean isIndexed, int index, HintContainer srcDeepIndexHintContainer) {
        DozerPropertyDescriptor[] hierarchy;
        Object parentObj;
        Object hierarchyValue = parentObj = srcObj;
        for (DozerPropertyDescriptor hierarchyElement : hierarchy = DeepHierarchyUtils.getDeepFieldHierarchy(srcObj.getClass(), fieldName, srcDeepIndexHintContainer)) {
            parentObj = hierarchyValue = hierarchyElement.getPropertyValue(parentObj);
            if (hierarchyValue == null) break;
        }
        if (isIndexed) {
            hierarchyValue = MappingUtils.getIndexedValue(hierarchyValue, index);
        }
        return hierarchyValue;
    }

    public static Class<?> getDeepFieldType(Class<?> clazz, String fieldName, HintContainer deepIndexHintContainer) {
        DozerPropertyDescriptor[] hierarchy = DeepHierarchyUtils.getDeepFieldHierarchy(clazz, fieldName, deepIndexHintContainer);
        return hierarchy[hierarchy.length - 1].getPropertyType();
    }

    public static Class<?> getDeepGenericType(Class<?> clazz, String fieldName, HintContainer deepIndexHintContainer) {
        DozerPropertyDescriptor[] hierarchy = DeepHierarchyUtils.getDeepFieldHierarchy(clazz, fieldName, deepIndexHintContainer);
        return hierarchy[hierarchy.length - 1].genericType();
    }

    private static DozerPropertyDescriptor[] getDeepFieldHierarchy(Class<?> parentClass, String field, HintContainer deepIndexHintContainer) {
        if (!MappingUtils.isDeepMapping(field)) {
            MappingUtils.throwMappingException("Field does not contain deep field delimiter");
        }
        StringTokenizer toks = new StringTokenizer(field, ".");
        Class<?> latestClass = parentClass;
        DozerPropertyDescriptor[] hierarchy = new DozerPropertyDescriptor[toks.countTokens()];
        int index = 0;
        int hintIndex = 0;
        while (toks.hasMoreTokens()) {
            DozerPropertyDescriptor propDescriptor;
            String aFieldName;
            String theFieldName = aFieldName = toks.nextToken();
            int collectionIndex = -1;
            if (aFieldName.contains("[")) {
                theFieldName = aFieldName.substring(0, aFieldName.indexOf("["));
                collectionIndex = Integer.parseInt(aFieldName.substring(aFieldName.indexOf("[") + 1, aFieldName.indexOf("]")));
            }
            if ((propDescriptor = PropertyDescriptorFactory.getPropertyDescriptor(latestClass, null, null, null, null, false, collectionIndex > -1, collectionIndex, theFieldName, null, false, null, null, null, null)) == null) {
                MappingUtils.throwMappingException("Exception occurred determining deep field hierarchy for Class --> " + parentClass.getName() + ", Field --> " + field + ".  Unable to determine property descriptor for Class --> " + latestClass.getName() + ", Field Name: " + aFieldName);
            }
            latestClass = propDescriptor.getPropertyType();
            if (toks.hasMoreTokens()) {
                if (latestClass.isArray()) {
                    latestClass = latestClass.getComponentType();
                } else if (Collection.class.isAssignableFrom(latestClass)) {
                    Class<?> genericType = propDescriptor.genericType();
                    if (genericType == null && deepIndexHintContainer == null) {
                        MappingUtils.throwMappingException("Hint(s) or Generics not specified.  Hint(s) or Generics must be specified for deep mapping with indexed field(s). Exception occurred determining deep field hierarchy for Class --> " + parentClass.getName() + ", Field --> " + field + ".  Unable to determine property descriptor for Class --> " + latestClass.getName() + ", Field Name: " + aFieldName);
                    }
                    if (genericType != null) {
                        latestClass = genericType;
                    } else {
                        latestClass = deepIndexHintContainer.getHint(hintIndex);
                        ++hintIndex;
                    }
                }
            }
            hierarchy[index++] = propDescriptor;
        }
        return hierarchy;
    }
}

