/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.oozie.domain;

import com.aliyun.migration.workflow.migration.common.type.OozieNodeType;
import com.aliyun.migration.workflow.migration.oozie.domain.OozieDataEvent;
import com.aliyun.migration.workflow.migration.oozie.domain.OozieDataSet;
import com.aliyun.migration.workflow.migration.oozie.domain.OozieDataSets;
import com.aliyun.migration.workflow.migration.oozie.domain.OozieFSOperation;
import com.aliyun.migration.workflow.migration.oozie.domain.OozieFSType;
import com.aliyun.migration.workflow.migration.oozie.domain.OoziePipeType;
import com.aliyun.migration.workflow.migration.oozie.domain.OoziePrepare;
import com.aliyun.migration.workflow.migration.oozie.domain.OozieStreaming;
import com.aliyun.migration.workflow.migration.oozie.domain.OozieWorkflow;
import com.aliyun.migration.workflow.migration.oozie.domain.OozieWorkflowNode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OoziePackageFileService {
    private static final Logger log = LoggerFactory.getLogger(OoziePackageFileService.class);

    public Properties readProperties(File propertiesFile) throws IOException {
        Properties properties = new Properties();
        properties.load(propertiesFile.toURI().toURL().openStream());
        return properties;
    }

    public OozieWorkflow readWorkflowPackageFile(File xmlFile, ArrayList<File> propertiesFiles, ArrayList<File> coordinatorFiles) throws IOException {
        OozieWorkflow workflow = new OozieWorkflow();
        if (propertiesFiles != null & propertiesFiles.size() > 0) {
            for (File file : propertiesFiles) {
                Properties properties = this.readProperties(file);
                for (Object object : properties.keySet()) {
                    workflow.addParameter((String)object, (String)properties.get(object));
                }
            }
        }
        boolean replaceFlag = true;
        while (replaceFlag) {
            replaceFlag = false;
            for (String key : workflow.getParameters().keySet()) {
                String string;
                String value = workflow.getParameters().get(key);
                if (value.equals(string = this.checkReference(value, workflow))) continue;
                replaceFlag = true;
                workflow.addParameter(key, string);
            }
            if (replaceFlag) continue;
        }
        SAXReader sAXReader = new SAXReader();
        Document document = null;
        if (coordinatorFiles != null & coordinatorFiles.size() > 0) {
            for (File file : coordinatorFiles) {
                try {
                    document = sAXReader.read(file);
                }
                catch (DocumentException e) {
                    System.out.println(e.getMessage());
                }
                this.readCoordinatorXML(document.getRootElement(), workflow);
            }
        }
        try {
            document = sAXReader.read(xmlFile);
        }
        catch (DocumentException e) {
            System.out.println(e.getMessage());
        }
        if (document == null) {
            log.warn("cannot get workflow element");
            return null;
        }
        workflow.setName(this.checkReference(document.getRootElement().attributeValue("name"), workflow));
        workflow.setId(workflow.getName());
        workflow.setAppPath(xmlFile.getParentFile().getName());
        log.info("workflow name: {}", (Object)workflow.getName());
        workflow.setXmlns(document.getRootElement().getQName().getNamespaceURI());
        if (document.getRootElement().element("parameters") != null && document.getRootElement().element("parameters").elements("property").size() > 0) {
            for (Element element : document.getRootElement().element("parameters").elements("property")) {
                String name = element.element("name").getStringValue();
                String value = element.element("value") == null ? null : this.checkReference(element.element("value").getStringValue(), workflow);
                workflow.addParameter(name, value);
            }
        }
        replaceFlag = true;
        while (replaceFlag) {
            replaceFlag = false;
            for (String string : workflow.getParameters().keySet()) {
                String newValue;
                String value = workflow.getParameters().get(string);
                if (value.equals(newValue = this.checkReference(value, workflow))) continue;
                replaceFlag = true;
                workflow.addParameter(string, newValue);
            }
            if (replaceFlag) continue;
        }
        for (Element element : document.getRootElement().elements()) {
            if (element.getQName().getName() == "parameters") continue;
            if (element.getQName().getName() == "info") {
                for (Element slaElement : element.elements()) {
                    workflow.addSla(this.checkReference(slaElement.getQName().getName(), workflow), this.checkReference(slaElement.getStringValue(), workflow));
                }
                continue;
            }
            OozieWorkflowNode node = this.readNodeXML(element, workflow);
            if (node == null) continue;
            node.setName(node.getId());
            workflow.addNode(node);
        }
        return workflow;
    }

    private void readCoordinatorXML(Element coordinatorElement, OozieWorkflow workflow) {
        OozieDataEvent oozieDataEvent;
        workflow.setFrequency(this.checkELConstant(coordinatorElement.attributeValue("frequency"), workflow));
        workflow.setStartTime(this.checkReference(coordinatorElement.attributeValue("start"), workflow));
        workflow.setEndTime(this.checkReference(coordinatorElement.attributeValue("end"), workflow));
        workflow.setTimeZone(this.checkReference(coordinatorElement.attributeValue("timezone"), workflow));
        if (coordinatorElement.element("controls") != null) {
            if (coordinatorElement.element("controls").element("timeout") != null) {
                workflow.setTimeOut(this.checkReference(coordinatorElement.element("controls").element("timeout").getStringValue(), workflow));
            }
            if (coordinatorElement.element("controls").element("concurrency") != null) {
                workflow.setConcurrency(this.checkReference(coordinatorElement.element("controls").element("concurrency").getStringValue(), workflow));
            }
            if (coordinatorElement.element("controls").element("execution") != null) {
                workflow.setExecutionMode(this.checkReference(coordinatorElement.element("controls").element("execution").getStringValue(), workflow));
            }
            if (coordinatorElement.element("controls").element("throttle") != null) {
                workflow.setThrottle(this.checkReference(coordinatorElement.element("controls").element("throttle").getStringValue(), workflow));
            }
        }
        if (coordinatorElement.element("datasets") != null) {
            OozieDataSets oozieDataSets = new OozieDataSets();
            if (coordinatorElement.element("datasets").elements("include").size() > 0) {
                for (Element includeElement : coordinatorElement.element("datasets").elements("include")) {
                    oozieDataSets.addSharedDataset(this.checkReference(includeElement.getStringValue(), workflow));
                }
            }
            if (coordinatorElement.element("datasets").elements("dataset").size() > 0) {
                for (Element datasetElement : coordinatorElement.element("datasets").elements("dataset")) {
                    OozieDataSet oozieDataSet = new OozieDataSet();
                    oozieDataSet.setName(this.checkReference(datasetElement.attributeValue("name"), workflow));
                    oozieDataSet.setFrequency(this.checkReference(datasetElement.attributeValue("frequency"), workflow));
                    oozieDataSet.setInitialInstance(this.checkReference(datasetElement.attributeValue("initial-instance"), workflow));
                    oozieDataSet.setTimezone(this.checkReference(datasetElement.attributeValue("timezone"), workflow));
                    oozieDataSet.setUriTemplate(this.checkReference(datasetElement.element("uri-template").getStringValue(), workflow));
                    oozieDataSets.addDataset(oozieDataSet);
                }
            }
            workflow.setDataSets(oozieDataSets);
        }
        if (coordinatorElement.element("input-events") != null) {
            for (Element inputEventElement : coordinatorElement.element("input-events").elements("data-in")) {
                oozieDataEvent = new OozieDataEvent();
                oozieDataEvent.setType("in");
                oozieDataEvent.setName(this.checkReference(inputEventElement.attributeValue("name"), workflow));
                oozieDataEvent.setDataset(this.checkReference(inputEventElement.attributeValue("dataset"), workflow));
                if (inputEventElement.elements("instance").size() > 0) {
                    for (Element instanceElement : inputEventElement.elements("instance")) {
                        oozieDataEvent.addInstance(this.checkReference(instanceElement.getStringValue(), workflow));
                    }
                }
                if (inputEventElement.element("start-instance") != null) {
                    oozieDataEvent.setStartInstance(this.checkReference(inputEventElement.element("start-instance").getStringValue(), workflow));
                }
                if (inputEventElement.element("end-instance") != null) {
                    oozieDataEvent.setEndInstance(this.checkReference(inputEventElement.element("end-instance").getStringValue(), workflow));
                }
                workflow.addDataEvent(oozieDataEvent);
            }
        }
        if (coordinatorElement.element("output-events") != null) {
            for (Element inputEventElement : coordinatorElement.element("output-events").elements("data-out")) {
                oozieDataEvent = new OozieDataEvent();
                oozieDataEvent.setType("out");
                oozieDataEvent.setName(this.checkReference(inputEventElement.attributeValue("name"), workflow));
                oozieDataEvent.setDataset(inputEventElement.attributeValue("dataset"));
                if (inputEventElement.elements("instance").size() > 0) {
                    for (Element instanceElement : inputEventElement.elements("instance")) {
                        oozieDataEvent.addInstance(this.checkReference(instanceElement.getStringValue(), workflow));
                    }
                }
                if (inputEventElement.element("start-instance") != null) {
                    oozieDataEvent.setStartInstance(this.checkReference(inputEventElement.element("start-instance").getStringValue(), workflow));
                }
                if (inputEventElement.element("end-instance") != null) {
                    oozieDataEvent.setEndInstance(this.checkReference(inputEventElement.element("end-instance").getStringValue(), workflow));
                }
                workflow.addDataEvent(oozieDataEvent);
            }
        }
        if (coordinatorElement.element("action") != null && coordinatorElement.element("action").element("workflow") != null) {
            if (coordinatorElement.element("action").element("workflow").element("app-path") != null) {
                workflow.setAppPath(this.checkReference(coordinatorElement.element("action").element("workflow").element("app-path").getStringValue(), workflow));
            }
            if (coordinatorElement.element("action").element("workflow").element("configuration") != null) {
                for (Element confElement : coordinatorElement.element("action").element("workflow").element("configuration").elements("property")) {
                    workflow.addProperty(this.checkReference(confElement.element("name").getStringValue(), workflow), this.checkReference(confElement.element("value").getStringValue(), workflow));
                }
            }
        }
    }

    private OozieWorkflowNode readNodeXML(Element nodeElement, OozieWorkflow workflow) {
        if (nodeElement.getQName().getName() != "action") {
            return this.dealWorkflowControlNode(nodeElement, workflow);
        }
        return this.dealActionNode(nodeElement, workflow);
    }

    private OozieWorkflowNode dealWorkflowControlNode(Element nodeElement, OozieWorkflow workflow) {
        OozieWorkflowNode node = new OozieWorkflowNode();
        node.setName(nodeElement.attributeValue("name") != null ? this.checkReference(nodeElement.attributeValue("name"), workflow) : this.checkReference(nodeElement.attributeValue("to"), workflow));
        node.setId(workflow.getId() + "_" + node.getName());
        String outXmlName = nodeElement.getQName().getName();
        node.setType(OozieNodeType.of((String)outXmlName, (String)""));
        switch (node.getType()) {
            case START: {
                node.addChildNode(node.getId());
                node.setName(workflow.getId() + "_START");
                node.setId(workflow.getId() + "_START");
                break;
            }
            case END: {
                node.setName(workflow.getId() + "_END");
                node.setId(workflow.getId() + "_END");
                break;
            }
            case KILL: {
                node.setName(workflow.getId() + "_KILL");
                node.setId(workflow.getId() + "_KILL");
                if (nodeElement.element("message") == null) break;
                String logMessage = this.checkReference(nodeElement.element("message").getStringValue(), workflow);
                node.setLogMessage(logMessage);
                break;
            }
            case DECISION: {
                for (Element switchcase : nodeElement.element("switch").elements("case")) {
                    String condition = this.checkReference(switchcase.getStringValue(), workflow);
                    String target = this.checkReference(switchcase.attributeValue("to"), workflow);
                    if (target.equals("end")) {
                        target = "END";
                    } else if (target.equals("kill")) {
                        target = "KILL";
                    }
                    node.addCondition(condition.trim(), target);
                    node.addChildNode(workflow.getId() + "_" + target);
                }
                if (nodeElement.element("switch").element("default") == null) break;
                String defaultTarget = this.checkReference(nodeElement.element("switch").element("default").attributeValue("to"), workflow);
                if (defaultTarget.equals("end")) {
                    defaultTarget = "END";
                } else if (defaultTarget.equals("kill")) {
                    defaultTarget = "KILL";
                }
                node.addCondition("default", this.checkReference(defaultTarget, workflow));
                node.addChildNode(workflow.getId() + "_" + defaultTarget);
                break;
            }
            case FORK: {
                for (Element target : nodeElement.elements("path")) {
                    String targetName = this.checkReference(target.attributeValue("start"), workflow);
                    if (targetName.equals("end")) {
                        targetName = "END";
                    } else if (targetName.equals("kill")) {
                        targetName = "KILL";
                    }
                    node.addChildNode(workflow.getId() + "_" + targetName);
                }
                break;
            }
            case JOIN: {
                String target = this.checkReference(nodeElement.attributeValue("to"), workflow);
                if (target.equals("end")) {
                    target = "END";
                } else if (target.equals("kill")) {
                    target = "KILL";
                }
                node.addChildNode(workflow.getId() + "_" + target);
                break;
            }
        }
        return node;
    }

    private OozieWorkflowNode dealActionNode(Element nodeElement, OozieWorkflow workflow) {
        Iterator value;
        String path;
        String value2;
        OozieWorkflowNode node = new OozieWorkflowNode();
        Element actionElement = (Element)nodeElement.elements().get(0);
        node.setName(nodeElement.attributeValue("name") != null ? this.checkReference(nodeElement.attributeValue("name"), workflow) : this.checkReference(nodeElement.attributeValue("to"), workflow));
        node.setId(workflow.getId() + "_" + node.getName());
        String outXmlName = nodeElement.getQName().getName();
        String inXmlName = actionElement.getQName().getName();
        try {
            node.setType(OozieNodeType.of((String)outXmlName, (String)inXmlName));
        }
        catch (Exception e) {
            log.error("unsupport node type: {}", (Object)inXmlName);
            return null;
        }
        if (actionElement.element("configuration") != null) {
            for (Object confElement : actionElement.element("configuration").elements("property")) {
                String key = confElement.element("name").getStringValue();
                value2 = this.checkReference(confElement.element("value").getStringValue(), workflow);
                node.addConf(key, value2);
            }
        }
        if (actionElement.element("resource-manager") != null) {
            node.setResourceManager(this.checkReference(actionElement.element("resource-manager").getStringValue(), workflow));
        }
        if (actionElement.element("name-node") != null) {
            node.setNameNode(this.checkReference(actionElement.element("name-node").getStringValue(), workflow));
        }
        if (actionElement.element("prepare") != null) {
            String path2;
            Iterator prepare = new OoziePrepare();
            for (Element deleteElement : actionElement.element("prepare").elements("delete")) {
                path2 = this.checkReference(deleteElement.attributeValue("path"), workflow);
                ((OoziePrepare)((Object)prepare)).addDeletePath(path2);
            }
            for (Element mkdirElement : actionElement.element("prepare").elements("mkdir")) {
                path2 = this.checkReference(mkdirElement.attributeValue("path"), workflow);
                ((OoziePrepare)((Object)prepare)).addMkdirPath(path2);
            }
            node.setPrepare((OoziePrepare)((Object)prepare));
        }
        if (actionElement.element("job-xml") != null) {
            node.setJobXml(this.checkReference(actionElement.element("job-xml").getStringValue(), workflow));
        }
        if (actionElement.elements("file").size() > 0) {
            for (Element fileElement : actionElement.elements("file")) {
                path = this.checkReference(fileElement.getStringValue(), workflow);
                node.addFilePath(path);
            }
        }
        if (actionElement.elements("archive").size() > 0) {
            for (Element archiveElement : actionElement.elements("archive")) {
                path = this.checkReference(archiveElement.getStringValue(), workflow);
                node.addArchivePath(path);
            }
        }
        if (actionElement.elements("argument").size() > 0) {
            for (Element argumentElement : actionElement.elements("argument")) {
                value = this.checkReference(argumentElement.getStringValue(), workflow);
                node.addArgument((String)((Object)value));
            }
        }
        if (actionElement.elements("arg").size() > 0) {
            for (Element argumentElement : actionElement.elements("arg")) {
                value = this.checkReference(argumentElement.getStringValue(), workflow);
                node.addArgument((String)((Object)value));
            }
        }
        switch (node.getType()) {
            case MAPREDUCE: {
                if (actionElement.element("streaming") != null) {
                    String value3;
                    Iterator streaming = new OozieStreaming();
                    Element streamingElement = actionElement.element("streaming");
                    if (streamingElement.element("mapper") != null) {
                        ((OozieStreaming)((Object)streaming)).setMapperProcess(this.checkReference(streamingElement.element("mapper").getStringValue(), workflow));
                    }
                    if (streamingElement.element("reducer") != null) {
                        ((OozieStreaming)((Object)streaming)).setReducerProcess(this.checkReference(streamingElement.element("reducer").getStringValue(), workflow));
                    }
                    if (streamingElement.element("record-reader") != null) {
                        ((OozieStreaming)((Object)streaming)).setRecordReaderClass(this.checkReference(streamingElement.element("record-reader").getStringValue(), workflow));
                    }
                    if (streamingElement.elements("record-reader-mapping").size() > 0) {
                        for (Element recordReaderMappingElement : streamingElement.elements("record-reader-mapping")) {
                            value3 = this.checkReference(recordReaderMappingElement.getStringValue(), workflow);
                            ((OozieStreaming)((Object)streaming)).addRecordReaderMapping(value3);
                        }
                    }
                    if (streamingElement.elements("env").size() > 0) {
                        for (Element envElement : streamingElement.elements("env")) {
                            value3 = this.checkReference(envElement.getStringValue(), workflow);
                            ((OozieStreaming)((Object)streaming)).addEnvValue(value3);
                        }
                    }
                    node.setStreaming((OozieStreaming)((Object)streaming));
                }
                if (actionElement.element("pipes") != null) {
                    for (Element pipesElement : actionElement.element("pipes").elements()) {
                        OoziePipeType type = OoziePipeType.of(pipesElement.getQName().getName());
                        value2 = this.checkReference(pipesElement.getStringValue(), workflow);
                        node.addPipes(type.getName(), value2);
                    }
                }
                if (actionElement.element("config-class") == null) break;
                node.setConfigClass(this.checkReference(actionElement.element("config-class").getStringValue(), workflow));
                break;
            }
            case PIG: {
                if (actionElement.element("script") != null) {
                    node.setScript(this.checkReference(actionElement.element("script").getStringValue(), workflow));
                }
                if (actionElement.elements("param").size() <= 0) break;
                for (Element paramElement : actionElement.elements("param")) {
                    value = this.checkReference(paramElement.getStringValue(), workflow);
                    node.addParams((String)((Object)value));
                }
                break;
            }
            case FS: {
                for (Element fsOperationElement : actionElement.elements()) {
                    OozieFSOperation operation = new OozieFSOperation();
                    operation.setType(OozieFSType.of(fsOperationElement.getQName().getName()));
                    operation.setPath(this.checkReference(fsOperationElement.attributeValue("path"), workflow));
                    operation.setSkipTrash(fsOperationElement.attributeValue("skip-trash") == null ? null : Boolean.valueOf(this.checkReference(fsOperationElement.attributeValue("skip-trash"), workflow)));
                    operation.setSource(this.checkReference(fsOperationElement.attributeValue("source"), workflow));
                    operation.setTarget(this.checkReference(fsOperationElement.attributeValue("target"), workflow));
                    operation.setPermissions(this.checkReference(fsOperationElement.attributeValue("permissions"), workflow));
                    operation.setDirFiles(fsOperationElement.attributeValue("dir-files") == null ? null : Boolean.valueOf(this.checkReference(fsOperationElement.attributeValue("dir-files"), workflow)));
                    operation.setGroup(this.checkReference(fsOperationElement.attributeValue("group"), workflow));
                    operation.setReplicationFactor(this.checkReference(fsOperationElement.attributeValue("replication-factor"), workflow));
                    node.addOperation(operation);
                }
                break;
            }
            case SUBWORKFLOW: {
                if (actionElement.element("app-path") != null) {
                    node.setAppPath(this.checkReference(actionElement.element("app-path").getStringValue(), workflow));
                }
                node.setPropagratedConfiguration(actionElement.element("propagate-configuration") != null);
                break;
            }
            case JAVA: {
                if (actionElement.element("main-class") != null) {
                    node.setJavaMainClass(this.checkReference(actionElement.element("main-class").getStringValue(), workflow));
                }
                if (actionElement.element("java-opts") != null) {
                    node.setJavaOpts(this.checkReference(actionElement.element("java-opts").getStringValue(), workflow));
                }
                node.setPropagratedConfiguration(actionElement.element("capture-output") != null);
                break;
            }
        }
        if (nodeElement.element("ok") != null) {
            String okTarget = this.checkReference(nodeElement.element("ok").attributeValue("to"), workflow);
            if (okTarget.equals("end")) {
                okTarget = "END";
            } else if (okTarget.equals("kill")) {
                okTarget = "KILL";
            }
            node.addChildNode(workflow.getId() + "_" + okTarget);
        }
        if (nodeElement.element("error") != null) {
            String errorTarget = this.checkReference(nodeElement.element("error").attributeValue("to"), workflow);
            if (errorTarget.equals("end")) {
                errorTarget = "END";
            } else if (errorTarget.equals("kill")) {
                errorTarget = "KILL";
            }
            node.setFailTarget(workflow.getId() + "_" + errorTarget);
        }
        return node;
    }

    String checkReference(String str, OozieWorkflow workflow) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return str;
        }
        if (workflow.getParameters() == null) {
            return str;
        }
        if (workflow.getParameters().size() == 0) {
            return str;
        }
        String regex = "\\$\\{(.+?)\\}";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        StringBuffer resultBuffer = new StringBuffer();
        while (matcher.find()) {
            String key = matcher.group(1);
            String replacement = workflow.getParameters().get(key);
            if (replacement == null) continue;
            replacement = replacement.replaceAll("\\$", "RDS_CHAR_DOLLAR");
            matcher.appendReplacement(resultBuffer, replacement);
        }
        matcher.appendTail(resultBuffer);
        return resultBuffer.toString().replaceAll("RDS_CHAR_DOLLAR", "\\$");
    }

    String checkELConstant(String str, OozieWorkflow workflow) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return str;
        }
        this.checkReference(str, workflow);
        for (elConstant regex : elConstant.values()) {
            Pattern pattern = Pattern.compile(regex.getRegex());
            Matcher matcher = pattern.matcher(str);
            if (!matcher.matches()) continue;
            String context = str.substring(regex.getStartPos(), str.length() - regex.getEndPos());
            return regex.getCron().replace("$", context);
        }
        return str + " ? *";
    }

    public static enum elConstant {
        MIN("^\\$\\{coord\\:minutes\\((.*)\\)\\}$", "0 0/$ * * * ? *", "${coord:minutes(".length(), ")}".length()),
        HOURS("^\\$\\{coord\\:hours\\((.*)\\)\\}$", "0 0 0/$ * * ? *", "${coord:hours(".length(), ")}".length()),
        DAYS("^\\$\\{coord\\:days\\((.*)\\)\\}$", "0 0 0 0/$ * ? *", "${coord:days(".length(), ")}".length()),
        MONTHS("^\\$\\{coord\\:months\\((.*)\\)\\}$", "0 0 0 0 0/$ ? *", "${coord:months(".length(), ")}".length());

        private String regex;
        private String cron;
        private int startPos;
        private int endPos;

        private elConstant(String regex, String cron, int startPos, int endPos) {
            this.regex = regex;
            this.cron = cron;
            this.startPos = startPos;
            this.endPos = endPos;
        }

        public String getRegex() {
            return this.regex;
        }

        public String getCron() {
            return this.cron;
        }

        public int getStartPos() {
            return this.startPos;
        }

        public int getEndPos() {
            return this.endPos;
        }
    }
}

